/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.render.groovy;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import groovy.lang.GroovyClassLoader;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.DisposableCacheValue;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.component.annotation.Component;

@Component(roles={ParseGroovyFromString.class})
@Singleton
public class ParseGroovyFromString {
    @Inject
    private CacheManager cacheManager;
    private Cache<CachedGroovyClass> classCache;

    public void flushCache() {
        if (this.classCache != null) {
            this.classCache.dispose();
        }
        this.classCache = null;
    }

    private void initCache(XWikiContext xcontext) throws XWikiException {
        int classCacheSize = 100;
        try {
            String capacity = xcontext.getWiki().Param("xwiki.render.groovy.classcache.capacity");
            if (capacity != null) {
                classCacheSize = Integer.parseInt(capacity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initCache(classCacheSize, xcontext);
    }

    private void initCache(int iClassCapacity, XWikiContext context) throws XWikiException {
        try {
            LRUCacheConfiguration configuration = new LRUCacheConfiguration("xwiki.groovy.class", iClassCapacity);
            this.classCache = this.cacheManager.createNewLocalCache((CacheConfiguration)configuration);
        }
        catch (CacheException e) {
            throw new XWikiException(16, 16001, "Failed to initilize caches", e);
        }
    }

    private void prepareCache(XWikiContext context) {
        try {
            if (this.classCache == null) {
                this.initCache(context);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object parseGroovyFromString(String script, XWikiContext context) throws XWikiException {
        this.prepareCache(context);
        ClassLoader parentClassLoader = (ClassLoader)context.get("parentclassloader");
        try {
            Class gc;
            CachedGroovyClass cgc = (CachedGroovyClass)this.classCache.get(script);
            if (cgc == null) {
                GroovyClassLoader gcl = parentClassLoader == null ? new GroovyClassLoader() : new GroovyClassLoader(parentClassLoader);
                gc = gcl.parseClass(script);
                cgc = new CachedGroovyClass(gc);
                this.classCache.set(script, (Object)cgc);
            } else {
                gc = cgc.getGroovyClass();
            }
            return gc.newInstance();
        }
        catch (Exception e) {
            throw new XWikiException(14, 14001, "Failed compiling groovy script", e);
        }
    }

    private class CachedGroovyClass
    implements DisposableCacheValue {
        protected Class<?> cl;

        CachedGroovyClass(Class<?> cl) {
            this.cl = cl;
        }

        public Class<?> getGroovyClass() {
            return this.cl;
        }

        public void dispose() throws Exception {
            if (this.cl != null) {
                InvokerHelper.removeClass(this.cl);
            }
        }
    }
}

