/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.redirection;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.mandatory.RedirectClassDocumentInitializer;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.redirection.RedirectionFilter;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceManager;
import org.xwiki.resource.entity.EntityResourceReference;

@Component
@Singleton
@Named(value="XWiki.RedirectClass")
public class RedirectClassRedirectionFilter
implements RedirectionFilter {
    @Inject
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private ResourceReferenceManager resourceReferenceManager;

    @Override
    public boolean redirect(XWikiContext context) throws XWikiException {
        WikiReference wikiReference = context.getWikiReference();
        XWikiDocument doc = context.getDoc();
        BaseObject redirectObj = doc.getXObject((EntityReference)RedirectClassDocumentInitializer.REFERENCE);
        if (redirectObj == null) {
            return false;
        }
        String location = redirectObj.getStringValue("location");
        if (StringUtils.isBlank((CharSequence)location)) {
            return false;
        }
        DocumentReference locationReference = this.resolver.resolve((Object)location, new Object[]{wikiReference});
        ResourceReference resourceReference = this.resourceReferenceManager.getResourceReference();
        EntityResourceReference entityResource = (EntityResourceReference)resourceReference;
        EntityReference entityReference = entityResource.getEntityReference();
        if (entityReference.getType().ordinal() > EntityType.DOCUMENT.ordinal()) {
            EntityReference parentDocument = entityReference.extractReference(EntityType.DOCUMENT);
            locationReference = entityReference.replaceParent(parentDocument, (EntityReference)locationReference);
        }
        String url = context.getWiki().getURL((EntityReference)locationReference, context.getAction(), context.getRequest().getQueryString(), null, context);
        try {
            context.getResponse().sendRedirect(url);
        }
        catch (IOException e) {
            throw new XWikiException("Failed to redirect.", e);
        }
        return true;
    }
}

