/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.query;

import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.query.QueryExecutor;

@Component
@Singleton
public class ConfiguredQueryExecutorProvider
implements Provider<QueryExecutor> {
    @Inject
    private ComponentManager manager;
    @Inject
    private Execution exec;
    @Inject
    private QueryExecutor queryExecutor;
    @Inject
    private Logger logger;
    private boolean initialized;

    private void init() {
        XWikiContext context;
        try {
            context = (XWikiContext)this.exec.getContext().getProperty("xwikicontext");
        }
        catch (NullPointerException e) {
            this.logger.warn("The QueryExecutor was called without an XWikiContext available. This means the old core (and likely the storage engine) is probably not yet initialized. The default QueryExecutor will be returned.", (Throwable)e);
            return;
        }
        String storeName = context.getWiki().Param("xwiki.store.main.hint", "default");
        try {
            this.queryExecutor = (QueryExecutor)this.manager.getInstance(QueryExecutor.class, storeName);
        }
        catch (ComponentLookupException e) {
            this.logger.warn("Could not find a QueryExecutor with hint [{}] which is the hint for the storage engine, defined in your XWiki configuration under the [xwiki.store.main.hint] property. The default QueryExecutor will be used instead. Reason: [{}]", (Object)storeName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        this.initialized = true;
    }

    public QueryExecutor get() {
        if (!this.initialized) {
            this.init();
        }
        return this.queryExecutor;
    }
}

