/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.observation.remote.converter;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDeletedDocument;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.observation.remote.converter.AbstractXWikiEventConverter;
import com.xpn.xwiki.store.XWikiCacheStore;
import com.xpn.xwiki.store.XWikiRecycleBinStoreInterface;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.bridge.event.DocumentVersionRangeDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.remote.LocalEventData;
import org.xwiki.observation.remote.RemoteEventData;

@Component
@Singleton
@Named(value="document")
public class DocumentEventConverter
extends AbstractXWikiEventConverter {
    private static final Set<Class<? extends Event>> EVENTS = new HashSet<Class<? extends Event>>(){
        {
            this.add(DocumentDeletedEvent.class);
            this.add(DocumentCreatedEvent.class);
            this.add(DocumentUpdatedEvent.class);
            this.add(DocumentVersionRangeDeletedEvent.class);
        }
    };

    public boolean toRemote(LocalEventData localEvent, RemoteEventData remoteEvent) {
        if (EVENTS.contains(localEvent.getEvent().getClass())) {
            remoteEvent.setEvent((Serializable)localEvent.getEvent());
            remoteEvent.setSource(this.serializeXWikiDocument((XWikiDocument)localEvent.getSource()));
            remoteEvent.setData(this.serializeXWikiContext((XWikiContext)localEvent.getData()));
            return true;
        }
        return false;
    }

    public boolean fromRemote(RemoteEventData remoteEvent, LocalEventData localEvent) {
        if (EVENTS.contains(remoteEvent.getEvent().getClass())) {
            XWikiContext xcontext = this.unserializeXWikiContext(remoteEvent.getData());
            try {
                if (xcontext != null) {
                    localEvent.setData((Object)xcontext);
                    localEvent.setEvent((Event)remoteEvent.getEvent());
                    if (remoteEvent.getEvent() instanceof DocumentDeletedEvent) {
                        localEvent.setSource((Object)this.unserializeDeletedDocument(remoteEvent.getSource(), xcontext));
                    } else {
                        localEvent.setSource((Object)this.unserializeDocument(remoteEvent.getSource()));
                    }
                }
            }
            catch (XWikiException e) {
                this.logger.error("Failed to convert remote event [{}]", (Object)remoteEvent, (Object)e);
            }
            return true;
        }
        return false;
    }

    private XWikiDocument unserializeDeletedDocument(Serializable remoteData, XWikiContext xcontext) throws XWikiException {
        Map remoteDataMap = (Map)((Object)remoteData);
        DocumentReference docReference = (DocumentReference)remoteDataMap.get("docname");
        Locale locale = LocaleUtils.toLocale((String)((String)remoteDataMap.get("doclanguage")));
        XWikiDocument doc = new XWikiDocument(docReference, locale);
        XWikiDocument origDoc = new XWikiDocument(docReference, locale);
        XWiki xwiki = xcontext.getWiki();
        XWikiRecycleBinStoreInterface store = xwiki.getRecycleBinStore();
        XWikiDeletedDocument[] deletedDocuments = store.getAllDeletedDocuments(origDoc, xcontext, true);
        if (deletedDocuments != null && deletedDocuments.length > 0) {
            long index = deletedDocuments[0].getId();
            try {
                origDoc = store.restoreFromRecycleBin(index, xcontext, true);
            }
            catch (Exception e) {
                this.logger.error("Failed to restore deleted document [{}]", (Object)docReference, (Object)e);
            }
        }
        doc.setOriginalDocument(origDoc);
        if (xcontext.getWiki().getStore() instanceof XWikiCacheStore) {
            ((XWikiCacheStore)xcontext.getWiki().getStore()).invalidate(doc);
        }
        return doc;
    }
}

