/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.objects.classes;

import com.xpn.xwiki.internal.store.hibernate.HibernateStore;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.DBStringListProperty;
import com.xpn.xwiki.objects.LargeStringProperty;
import com.xpn.xwiki.objects.StringListProperty;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.store.DatabaseProduct;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.ClassPropertyReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryBuilder;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="usedValues")
@Singleton
public class UsedValuesListQueryBuilder
implements QueryBuilder<ListClass> {
    private static final String PROP_VALUE = "prop.value";
    @Inject
    private Logger logger;
    @Inject
    private QueryManager queryManager;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private HibernateStore hibernateStore;

    public Query build(ListClass listClass) throws QueryException {
        String statement;
        boolean usesClobColumn = this.usesClobColumn(listClass);
        SelectColumnAndFromTable selectAndFrom = this.getSelectColumnAndFromTable(listClass);
        if (usesClobColumn) {
            String selectColumn = selectAndFrom.selectColumn();
            String fromTable = selectAndFrom.fromTable();
            String fromTableProp2 = fromTable.replace(" as prop", " as prop2");
            String selectColumnProp2 = selectColumn.replace("prop.", "prop2.");
            statement = String.format("select %1$s as stringValue, 1L as unfilterable0 from BaseObject as obj, %2$s where obj.className = :className   and obj.name <> :templateName   and prop.id.id = obj.id   and prop.id.name = :propertyName   and not exists (    select 1 from %3$s     where prop2.id.name = :propertyName       and prop2.id.id < prop.id.id       and FUNCTION('DBMS_LOB.COMPARE', %4$s, %1$s) = 0  ) order by obj.id", selectColumn, fromTable, fromTableProp2, selectColumnProp2);
        } else {
            statement = String.format("select %1$s as stringValue, count(*) as unfilterable0 from BaseObject as obj, %2$s where obj.className = :className and obj.name <> :templateName and prop.id.id = obj.id and prop.id.name = :propertyName group by %1$s order by unfilterable0 desc", selectAndFrom.selectColumn(), selectAndFrom.fromTable());
        }
        Query query = this.queryManager.createQuery(statement, "hql");
        this.bindParameterValues(query, listClass);
        query.addFilter((QueryFilter)new ViewableValueFilter(listClass));
        query.setWiki(((ClassPropertyReference)listClass.getReference()).extractReference(EntityType.WIKI).getName());
        return query;
    }

    private boolean usesClobColumn(ListClass listClass) {
        if (this.hibernateStore.getDatabaseProductName() != DatabaseProduct.ORACLE) {
            return false;
        }
        BaseProperty property = listClass.newProperty();
        return property instanceof StringListProperty || property instanceof LargeStringProperty;
    }

    private SelectColumnAndFromTable getSelectColumnAndFromTable(ListClass listClass) {
        BaseProperty property = listClass.newProperty();
        SelectColumnAndFromTable result = property instanceof StringListProperty ? new SelectColumnAndFromTable("prop.textValue", "StringListProperty as prop") : (property instanceof DBStringListProperty ? new SelectColumnAndFromTable("listItem", "DBStringListProperty as prop join prop.list listItem") : (property instanceof LargeStringProperty ? new SelectColumnAndFromTable(PROP_VALUE, "LargeStringProperty as prop") : new SelectColumnAndFromTable(PROP_VALUE, "StringProperty as prop")));
        return result;
    }

    private void bindParameterValues(Query query, ListClass listClass) {
        String className = listClass.getObject().getName();
        query.bindValue("className", (Object)className);
        query.bindValue("propertyName", (Object)listClass.getName());
        query.bindValue("templateName", (Object)this.getTemplateName(className));
    }

    private String getTemplateName(String className) {
        return Strings.CS.removeEnd(className, (CharSequence)"Class") + "Template";
    }

    private boolean canView(ListClass listClass, String value, long count) {
        long offset = ThreadLocalRandom.current().nextLong(count);
        SelectColumnAndFromTable selectAndFrom = this.getSelectColumnAndFromTable(listClass);
        String selectColumn = selectAndFrom.selectColumn();
        String comparison = this.usesClobColumn(listClass) ? String.format("FUNCTION('DBMS_LOB.COMPARE', %s, :propertyValue) = 0", selectColumn) : String.format("%s = :propertyValue", selectColumn);
        String statement = String.format("select obj.name from BaseObject as obj, %s where obj.className = :className and obj.name <> :templateName and prop.id.id = obj.id and prop.id.name = :propertyName and %s", selectAndFrom.fromTable(), comparison);
        try {
            DocumentReference documentReference;
            Query query = this.queryManager.createQuery(statement, "hql");
            this.bindParameterValues(query, listClass);
            query.bindValue("propertyValue", (Object)value);
            query.setWiki(((ClassPropertyReference)listClass.getReference()).extractReference(EntityType.WIKI).getName());
            query.setOffset((int)offset).setLimit(1);
            List results = query.execute();
            if (!results.isEmpty() && this.authorization.hasAccess(Right.VIEW, (EntityReference)(documentReference = this.documentReferenceResolver.resolve((Object)((String)results.get(0)), new Object[0])))) {
                return true;
            }
        }
        catch (QueryException e) {
            this.logger.warn("Failed to check if the list value is viewable. Root cause is [{}]. Continue assuming the value is not viewable.", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return false;
    }

    private record SelectColumnAndFromTable(String selectColumn, String fromTable) {
    }

    private class ViewableValueFilter
    implements QueryFilter {
        private final ListClass listClass;

        ViewableValueFilter(ListClass listClass) {
            this.listClass = listClass;
        }

        public String filterStatement(String statement, String language) {
            return statement;
        }

        public List filterResults(List results) {
            LinkedList filteredResults = new LinkedList();
            for (Object result : results) {
                Long count;
                Object[] row = (Object[])result;
                String value = (String)row[0];
                if (!UsedValuesListQueryBuilder.this.canView(this.listClass, value, count = (Long)row[1])) continue;
                filteredResults.add(result);
            }
            return filteredResults;
        }
    }
}

