/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.objects.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.DBListClass;
import com.xpn.xwiki.objects.classes.DBTreeListClass;
import com.xpn.xwiki.objects.classes.EmailClass;
import com.xpn.xwiki.objects.classes.PasswordClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.xwiki.component.annotation.Component;
import org.xwiki.mail.GeneralMailConfiguration;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryBuilder;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;

@Component
@Named(value="implicitlyAllowedValues")
@Singleton
public class ImplicitlyAllowedValuesDBListQueryBuilder
implements QueryBuilder<DBListClass> {
    private static final String DOC_PREFIX = "doc.";
    private static final String OBJ_PREFIX = "obj.";
    private static final String CLASS_NAME = "className";
    private static final String TEMPLATE_NAME = "templateName";
    private static final String COLUMN_SEPARATOR = ", ";
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="viewableAllowedDBListPropertyValue")
    private QueryFilter viewableValueFilter;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private GeneralMailConfiguration mailConfiguration;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;

    public Query build(DBListClass dbListClass) throws QueryException {
        DBListQuerySpec spec = new DBListQuerySpec();
        spec.wiki = dbListClass.getOwnerDocument().getDocumentReference().getWikiReference().getName();
        spec.className = StringUtils.defaultString((String)dbListClass.getClassname());
        spec.idField = StringUtils.defaultString((String)dbListClass.getIdField());
        spec.valueField = StringUtils.defaultString((String)dbListClass.getValueField());
        spec.parentField = dbListClass instanceof DBTreeListClass ? ((DBTreeListClass)dbListClass).getParentField() : "";
        spec.hasClassName = !StringUtils.isBlank((CharSequence)spec.className);
        spec.hasIdField = !StringUtils.isBlank((CharSequence)spec.idField);
        spec.hasValueField = !StringUtils.isBlank((CharSequence)spec.valueField);
        spec.hasParentField = !StringUtils.isBlank((CharSequence)spec.parentField);
        return this.build(spec);
    }

    private Query build(DBListQuerySpec spec) throws QueryException {
        String statement = "select doc.name from XWikiDocument doc where 1 = 0";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (spec.hasIdField || spec.hasValueField) {
            statement = this.getStatementWhenIdOrValueFieldsAreSpecified(spec, parameters);
        } else if (spec.hasClassName) {
            statement = "select distinct doc.fullName from XWikiDocument as doc, BaseObject as obj where doc.fullName = obj.name and obj.className = :className and doc.fullName <> :templateName";
            parameters.put(CLASS_NAME, spec.className);
            parameters.put(TEMPLATE_NAME, this.getTemplateName(spec.className));
        }
        Query query = this.queryManager.createQuery(statement, "hql");
        query.setWiki(spec.wiki);
        for (Map.Entry entry : parameters.entrySet()) {
            query.bindValue((String)entry.getKey(), entry.getValue());
        }
        query.addFilter(this.viewableValueFilter);
        return query;
    }

    private void addFieldToQuery(String fieldName, String fieldAlias, DBListQuerySpec spec, List<String> selectClause, List<String> fromClause, List<String> whereClause, Map<String, Object> parameters) throws QueryException {
        if (fieldName.startsWith(DOC_PREFIX) || fieldName.startsWith(OBJ_PREFIX)) {
            this.checkSimpleFieldName(fieldName);
            selectClause.add(fieldName);
        } else if (!spec.hasClassName) {
            this.checkSimpleFieldName(fieldName);
            selectClause.add(DOC_PREFIX + fieldName);
        } else {
            try {
                PropertyInterface propertyInterface;
                if (spec.xClass == null) {
                    DocumentReference classReference = this.documentReferenceResolver.resolve((Object)spec.className, new Object[]{new WikiReference(spec.wiki)});
                    XWikiContext xWikiContext = (XWikiContext)this.contextProvider.get();
                    spec.xClass = xWikiContext.getWiki().getXClass(classReference, xWikiContext);
                }
                if ((propertyInterface = spec.xClass.get(fieldName)) instanceof PasswordClass) {
                    throw new QueryException("Queries for password field [%s] on class [%s] aren't allowed".formatted(fieldName, spec.className), null);
                }
                if (propertyInterface instanceof EmailClass && this.mailConfiguration.shouldObfuscate()) {
                    throw new QueryException("Queries for email property [%s] on class [%s] aren't allowed as email obfuscation is enabled.".formatted(fieldName, spec.className), null);
                }
                selectClause.add(fieldAlias + ".value");
                fromClause.add("StringProperty as " + fieldAlias);
                whereClause.add(String.format("obj.id = %1$s.id.id and %1$s.id.name = :%1$s", fieldAlias));
                parameters.put(fieldAlias, fieldName);
            }
            catch (XWikiException e) {
                throw new QueryException("Failed to get the XClass definition", null, (Throwable)e);
            }
        }
    }

    private void checkSimpleFieldName(String fieldName) throws QueryException {
        if (!StringUtils.isAlphanumeric((CharSequence)Strings.CS.removeStart(Strings.CS.removeStart(StringUtils.strip((String)fieldName), (CharSequence)DOC_PREFIX), (CharSequence)OBJ_PREFIX))) {
            throw new QueryException("Invalid field name [%s]".formatted(fieldName), null);
        }
    }

    private String getStatementWhenIdOrValueFieldsAreSpecified(DBListQuerySpec spec, Map<String, Object> parameters) throws QueryException {
        if (!spec.hasIdField || spec.idField.equals(spec.valueField) && !spec.hasParentField) {
            spec.idField = spec.valueField;
            spec.hasIdField = true;
            spec.valueField = spec.hasParentField ? spec.valueField : "";
            spec.hasValueField = spec.hasParentField;
        } else if (!spec.hasValueField && spec.hasParentField) {
            spec.valueField = spec.idField;
            spec.hasValueField = true;
        }
        return this.getStatementWhenIdFieldIsSpecified(spec, parameters);
    }

    private String getStatementWhenIdFieldIsSpecified(DBListQuerySpec spec, Map<String, Object> parameters) throws QueryException {
        ArrayList<String> selectClause = new ArrayList<String>();
        ArrayList<String> fromClause = new ArrayList<String>();
        ArrayList<String> whereClause = new ArrayList<String>();
        selectClause.add("doc.fullName as unfilterable0");
        fromClause.add("XWikiDocument as doc");
        if (spec.hasClassName || spec.idField.startsWith(OBJ_PREFIX) || spec.valueField.startsWith(OBJ_PREFIX) || spec.parentField.startsWith(OBJ_PREFIX)) {
            fromClause.add("BaseObject as obj");
            whereClause.add("doc.fullName = obj.name");
            if (spec.hasClassName) {
                whereClause.add("obj.className = :className and doc.fullName <> :templateName");
                parameters.put(CLASS_NAME, spec.className);
                parameters.put(TEMPLATE_NAME, this.getTemplateName(spec.className));
            }
        }
        this.addFieldToQuery(spec.idField, "idProp", spec, selectClause, fromClause, whereClause, parameters);
        if (spec.hasValueField) {
            this.addFieldToQuery(spec.valueField, "valueProp", spec, selectClause, fromClause, whereClause, parameters);
            if (spec.hasParentField) {
                this.addFieldToQuery(spec.parentField, "parentProp", spec, selectClause, fromClause, whereClause, parameters);
            }
        }
        StringBuilder statementBuilder = new StringBuilder("select distinct ").append(StringUtils.join(selectClause, (String)COLUMN_SEPARATOR)).append(" from ").append(StringUtils.join(fromClause, (String)COLUMN_SEPARATOR));
        if (whereClause.size() > 0) {
            statementBuilder.append(" where ").append(StringUtils.join(whereClause, (String)" and "));
        }
        return statementBuilder.toString();
    }

    private String getTemplateName(String className) {
        return StringUtils.removeEnd((String)className, (String)"Class") + "Template";
    }

    private static final class DBListQuerySpec {
        private String wiki;
        private String className;
        private String idField;
        private String valueField;
        private String parentField;
        private boolean hasClassName;
        private boolean hasIdField;
        private boolean hasValueField;
        private boolean hasParentField;
        private BaseClass xClass;

        private DBListQuerySpec() {
        }
    }
}

