/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.objects.classes;

import com.xpn.xwiki.objects.classes.DBListClass;
import java.io.StringWriter;
import java.io.Writer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.Query;
import org.xwiki.query.QueryBuilder;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.security.authorization.AuthorExecutor;
import org.xwiki.security.authorization.DocumentAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.VelocityManager;

@Component
@Named(value="explicitlyAllowedValues")
@Singleton
public class ExplicitlyAllowedValuesDBListQueryBuilder
implements QueryBuilder<DBListClass> {
    @Inject
    private Logger logger;
    @Inject
    private DocumentAuthorizationManager authorizationManager;
    @Inject
    private AuthorExecutor authorExecutor;
    @Inject
    private Provider<VelocityManager> velocityManagerProvider;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    @Named(value="secure")
    private QueryManager secureQueryManager;

    public Query build(DBListClass dbListClass) throws QueryException {
        DocumentReference documentReference;
        String statement = dbListClass.getSql();
        DocumentReference authorReference = dbListClass.getOwnerDocument().getAuthorReference();
        if (this.authorizationManager.hasAccess(Right.SCRIPT, EntityType.DOCUMENT, authorReference, documentReference = dbListClass.getOwnerDocument().getDocumentReference())) {
            String namespace = (String)this.entityReferenceSerializer.serialize(dbListClass.getReference(), new Object[0]);
            try {
                statement = (String)this.authorExecutor.call(() -> this.evaluateVelocityCode(dbListClass.getSql(), namespace), authorReference, documentReference);
            }
            catch (Exception e) {
                this.logger.warn("Failed to evaluate the Velocity code from the query [{}]. Root cause is [{}]. Continuing with the raw query.", (Object)statement, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        Query query = this.secureQueryManager.createQuery(statement, "hql");
        query.setWiki(documentReference.getWikiReference().getName());
        return query;
    }

    private String evaluateVelocityCode(String code, String namespace) throws Exception {
        VelocityManager velocityManager = (VelocityManager)this.velocityManagerProvider.get();
        VelocityContext velocityContext = velocityManager.getVelocityContext();
        VelocityEngine velocityEngine = velocityManager.getVelocityEngine();
        StringWriter writer = new StringWriter();
        velocityEngine.evaluate((Context)velocityContext, (Writer)writer, namespace, code);
        return writer.toString();
    }
}

