/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.objects.classes;

import com.xpn.xwiki.objects.classes.DBListClass;
import com.xpn.xwiki.objects.classes.PageClass;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.Query;
import org.xwiki.query.QueryBuilder;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.text.StringUtils;

@Component
@Singleton
public class DefaultPageQueryBuilder
implements QueryBuilder<PageClass> {
    @Inject
    @Named(value="explicitlyAllowedValues")
    private QueryBuilder<DBListClass> explicitlyAllowedValuesQueryBuilder;
    @Inject
    @Named(value="implicitlyAllowedValues")
    private QueryBuilder<PageClass> implicitlyAllowedValuesQueryBuilder;
    @Inject
    @Named(value="document")
    private QueryFilter documentFilter;
    @Inject
    @Named(value="viewable")
    private QueryFilter viewableFilter;
    @Inject
    @Named(value="hidden/document")
    private Provider<QueryFilter> hiddenFilterProvider;

    public Query build(PageClass pageClass) throws QueryException {
        Query query;
        if (StringUtils.isEmpty((CharSequence)pageClass.getSql())) {
            query = this.implicitlyAllowedValuesQueryBuilder.build((Object)pageClass);
            query.addFilter((QueryFilter)this.hiddenFilterProvider.get());
            query.addFilter(this.documentFilter);
        } else {
            query = this.explicitlyAllowedValuesQueryBuilder.build((Object)pageClass);
            query.addFilter(this.documentFilter);
            query.addFilter(this.viewableFilter);
        }
        return query;
    }
}

