/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.objects.classes;

import com.xpn.xwiki.objects.classes.GroupsClass;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.Query;
import org.xwiki.query.QueryBuilder;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;

@Component
@Singleton
public class DefaultGroupsQueryBuilder
implements QueryBuilder<GroupsClass> {
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="document")
    private QueryFilter documentFilter;
    @Inject
    @Named(value="viewable")
    private QueryFilter viewableFilter;

    public Query build(GroupsClass groupsClass) throws QueryException {
        String statement = "select distinct doc.fullName as groupReference, doc.title as groupName," + " lower(doc.fullName) as lowerGroupReference " + "from XWikiDocument doc, BaseObject obj " + "where doc.fullName = obj.name and obj.className = 'XWiki.XWikiGroups'" + " and doc.space = 'XWiki' and doc.name <> 'XWikiGroupTemplate' " + "order by lowerGroupReference, groupReference";
        Query query = this.queryManager.createQuery(statement, "hql");
        query.addFilter(this.documentFilter);
        query.addFilter(this.viewableFilter);
        query.setWiki(groupsClass.getOwnerDocument().getDocumentReference().getWikiReference().getName());
        return query;
    }
}

