/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.model.reference;

import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.properties.ConverterManager;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;
import org.xwiki.properties.converter.Converter;

@Component
@Singleton
public class DocumentReferenceConverter
extends AbstractConverter<DocumentReference> {
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> stringResolver;
    @Inject
    @Named(value="currentgetdocument")
    private DocumentReferenceResolver<EntityReference> referenceResolver;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private ConverterManager converterManager;
    @Inject
    private Logger logger;

    protected DocumentReference convertToType(Type type, Object value) {
        DocumentReference result;
        if (value == null) {
            result = null;
        } else if (value instanceof EntityReference) {
            result = this.referenceResolver.resolve((Object)((EntityReference)value), new Object[0]);
        } else {
            Converter converter = this.converterManager.getConverter(value.getClass());
            if (converter != null) {
                try {
                    result = (DocumentReference)converter.convert(DocumentReference.class, value);
                }
                catch (ConversionException e) {
                    this.logger.warn("The type [{}] cannot be converted natively to DocumentReference, falling back on using toString to convert it.", (Object)value.getClass().getName());
                    result = this.stringResolver.resolve((Object)value.toString(), new Object[0]);
                }
            } else {
                result = this.stringResolver.resolve((Object)value.toString(), new Object[0]);
            }
        }
        return result;
    }

    protected String convertToString(DocumentReference value) {
        if (value == null) {
            return null;
        }
        return (String)this.serializer.serialize((EntityReference)value, new Object[0]);
    }
}

