/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.model.reference;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;

@Component
@Named(value="current")
@Singleton
public class CurrentSpaceReferenceProvider
implements Provider<SpaceReference> {
    @Inject
    @Named(value="current")
    private Provider<WikiReference> wikiReferenceProvider;
    @Inject
    @Named(value="current")
    private EntityReferenceProvider provider;

    public SpaceReference get() {
        EntityReference currentWiki = (EntityReference)this.wikiReferenceProvider.get();
        EntityReference currentSpace = this.provider.getDefaultReference(EntityType.SPACE);
        EntityReference result = currentWiki;
        for (EntityReference spaceReference : currentSpace.getReversedReferenceChain()) {
            result = new SpaceReference(spaceReference.getName(), result);
        }
        return (SpaceReference)result;
    }
}

