/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.model.reference;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.DefaultEntityReferenceProvider;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.PageReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;

@Component
@Named(value="current")
@Singleton
public class CurrentEntityReferenceProvider
extends DefaultEntityReferenceProvider {
    @Inject
    @Named(value="readonly")
    private Provider<XWikiContext> xcontextProvider;

    public EntityReference getDefaultReference(EntityType type) {
        WikiReference result = null;
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (xcontext != null) {
            XWikiDocument currentDoc;
            if (type == EntityType.WIKI) {
                result = xcontext.getWikiReference();
            } else if (type == EntityType.SPACE) {
                XWikiDocument currentDoc2 = xcontext.getDoc();
                if (currentDoc2 != null) {
                    SpaceReference spaceReference = currentDoc2.getDocumentReference().getLastSpaceReference();
                    result = spaceReference.removeParent((EntityReference)spaceReference.getWikiReference());
                }
            } else if (type == EntityType.DOCUMENT) {
                XWikiDocument currentDoc3 = xcontext.getDoc();
                if (currentDoc3 != null) {
                    DocumentReference documentReference = currentDoc3.getDocumentReference();
                    result = documentReference.removeParent((EntityReference)documentReference.getLastSpaceReference());
                }
            } else if (type == EntityType.PAGE && (currentDoc = xcontext.getDoc()) != null) {
                PageReference pageReference = currentDoc.getPageReference();
                result = pageReference.removeParent((EntityReference)pageReference.getWikiReference());
            }
        }
        if (result == null) {
            result = super.getDefaultReference(type);
        }
        return result;
    }
}

