/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.model.reference;

import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.PageReference;
import org.xwiki.model.reference.PageReferenceResolver;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

public abstract class AbstractCurrentGetReferenceResolver {
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<EntityReference> currentDocumentResolver;
    @Inject
    @Named(value="current")
    private PageReferenceResolver<EntityReference> currentPageResolver;
    @Inject
    @Named(value="current")
    private EntityReferenceResolver<EntityReference> currentResolver;
    @Inject
    private PageReferenceResolver<EntityReference> defaultPageResolver;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    protected EntityReference resolveInternal(EntityReference initialReference, Object ... parameters) {
        PageReference reference;
        if (initialReference.getType() == EntityType.WIKI) {
            String wikiId = initialReference.getName();
            try {
                WikiDescriptor wikiDescriptor = this.wikiDescriptorManager.getById(wikiId);
                if (wikiDescriptor != null) {
                    return wikiDescriptor.getMainPageReference();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to get wiki descriptor while resolving reference [%s]", initialReference), e);
            }
        }
        if (initialReference.getType().ordinal() >= EntityType.PAGE.ordinal()) {
            reference = this.defaultPageResolver.resolve((Object)initialReference, parameters);
        } else if (initialReference.getType().ordinal() <= EntityType.SPACE.ordinal()) {
            EntityReference currentParentReference = this.currentResolver.resolve((Object)initialReference, initialReference.getType(), parameters);
            reference = currentParentReference;
        } else {
            reference = this.currentDocumentResolver.resolve((Object)initialReference, parameters);
        }
        return reference;
    }
}

