/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.mandatory;

import com.xpn.xwiki.doc.AbstractMandatoryClassInitializer;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.BaseClass;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.sheet.SheetBinder;

@Component
@Named(value="XWiki.XWikiUsers")
@Singleton
public class XWikiUsersDocumentInitializer
extends AbstractMandatoryClassInitializer {
    public static final LocalDocumentReference XWIKI_USERS_DOCUMENT_REFERENCE = new LocalDocumentReference("XWiki", "XWikiUsers");
    public static final String CLASS_REFERENCE_STRING = "XWiki." + XWIKI_USERS_DOCUMENT_REFERENCE.getName();
    private static final String EMAIL_FIELD = "email";
    private static final String TIMEZONE_FIELD = "timezone";
    @Inject
    @Named(value="class")
    private SheetBinder classSheetBinder;

    public XWikiUsersDocumentInitializer() {
        super((EntityReference)XWIKI_USERS_DOCUMENT_REFERENCE);
    }

    @Override
    protected void createClass(BaseClass xclass) {
        xclass.addTextField("first_name", "First Name", 30);
        xclass.addTextField("last_name", "Last Name", 30);
        xclass.addEmailField(EMAIL_FIELD, "e-Mail", 30);
        xclass.addPasswordField("password", "Password", 10);
        xclass.addPasswordField("validkey", "Validation Key", 10);
        xclass.addBooleanField("active", "Active", "active");
        xclass.addTextField("company", "Company", 30);
        xclass.addTextField("blog", "Blog", 60);
        xclass.addTextField("blogfeed", "Blog Feed", 60);
        xclass.addTextAreaField("comment", "Comment", 40, 5);
        xclass.addStaticListField("imtype", "IM Type", "AIM|Yahoo|Jabber|MSN|Skype|ICQ");
        xclass.addTextField("imaccount", "imaccount", 30);
        xclass.addStaticListField("editor", "Default Editor", "Text|Wysiwyg");
        xclass.addStaticListField("usertype", "User type", "Simple|Advanced", "Simple");
        xclass.addStaticListField("underline", "Underline links", "OnlyInlineLinks|Yes|No", "OnlyInlineLinks");
        xclass.addBooleanField("displayHiddenDocuments", "Display Hidden Documents", "yesno");
        xclass.addTimezoneField(TIMEZONE_FIELD, "Time Zone", 30);
        xclass.addPageField("skin", "skin", 30);
        xclass.addTextField("avatar", "Avatar", 30);
        xclass.addTextField("phone", "Phone", 30);
        xclass.addTextAreaField("address", "Address", 40, 3);
        xclass.addBooleanField("extensionConflictSetup", "Enable extension conflict setup", "yesno");
        xclass.addBooleanField("email_checked", "Email address verified");
    }

    @Override
    public boolean updateDocument(XWikiDocument document) {
        boolean needsUpdate = super.updateDocument(document);
        if (this.classSheetBinder.getSheets((DocumentModelBridge)document).isEmpty()) {
            String wikiName = document.getDocumentReference().getWikiReference().getName();
            DocumentReference sheet = new DocumentReference(wikiName, "XWiki", "XWikiUserSheet");
            needsUpdate |= this.classSheetBinder.bind((DocumentModelBridge)document, sheet);
        }
        return needsUpdate;
    }
}

