/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.mandatory;

import com.xpn.xwiki.doc.AbstractMandatoryClassInitializer;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.BaseClass;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.sheet.SheetBinder;

@Component
@Named(value="XWiki.XWikiGroups")
@Singleton
public class XWikiGroupsDocumentInitializer
extends AbstractMandatoryClassInitializer {
    public static final LocalDocumentReference XWIKI_GROUPS_DOCUMENT_REFERENCE = new LocalDocumentReference("XWiki", "XWikiGroups");
    public static final String PROPERTY_MEMBER = "member";
    @Inject
    @Named(value="class")
    private SheetBinder classSheetBinder;

    public XWikiGroupsDocumentInitializer() {
        super((EntityReference)XWIKI_GROUPS_DOCUMENT_REFERENCE);
    }

    @Override
    protected void createClass(BaseClass xclass) {
        xclass.addTextField(PROPERTY_MEMBER, "Member", 30);
    }

    @Override
    public boolean updateDocument(XWikiDocument document) {
        boolean needUpdate = super.updateDocument(document);
        if (this.classSheetBinder.getSheets((DocumentModelBridge)document).isEmpty()) {
            String wikiName = document.getDocumentReference().getWikiReference().getName();
            DocumentReference sheet = new DocumentReference(wikiName, "XWiki", "XWikiGroupSheet");
            needUpdate |= this.classSheetBinder.bind((DocumentModelBridge)document, sheet);
        }
        return needUpdate;
    }
}

