/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.mandatory;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.MandatoryDocumentInitializer;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
@Named(value="XWiki.XWikiAllGroup")
public class XWikiAllGroupDocumentInitializer
implements MandatoryDocumentInitializer {
    private static final String DOCUMENT_NAME = "XWikiAllGroup";
    private static final String CLASS_NAME = "XWikiGroups";
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Logger logger;

    @Override
    public EntityReference getDocumentReference() {
        return new LocalDocumentReference("XWiki", DOCUMENT_NAME);
    }

    @Override
    public boolean updateDocument(XWikiDocument document) {
        boolean needsUpdate = false;
        LocalDocumentReference classReference = new LocalDocumentReference("XWiki", CLASS_NAME);
        if (document.getCreatorReference() == null) {
            document.setCreatorReference(new DocumentReference(this.wikiDescriptorManager.getMainWikiId(), "XWiki", "superadmin"));
            needsUpdate = true;
        }
        if (document.getAuthorReference() == null) {
            document.setAuthorReference(document.getCreatorReference());
            needsUpdate = true;
        }
        if (document.getParentReference() == null) {
            document.setParentReference((EntityReference)classReference);
            needsUpdate = true;
        }
        if (!document.isHidden().booleanValue()) {
            document.setHidden(true);
            needsUpdate = true;
        }
        if (document.getXObject((EntityReference)classReference) == null) {
            try {
                BaseObject obj = document.newXObject((EntityReference)classReference, (XWikiContext)this.xcontextProvider.get());
                obj.setStringValue("member", "");
                needsUpdate = true;
            }
            catch (XWikiException e) {
                this.logger.error(String.format("Impossible to add an object to the document XWiki.XWikiAllGroups in the wiki [%s].", document.getDocumentReference().getWikiReference().getName()), (Throwable)e);
            }
        }
        return needsUpdate;
    }
}

