/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.mandatory;

import com.xpn.xwiki.doc.AbstractMandatoryClassInitializer;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.StaticListClass;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.context.concurrent.ContextStoreManager;
import org.xwiki.localization.LocalizationManager;
import org.xwiki.model.reference.EntityReference;

public abstract class AbstractAsyncClassDocumentInitializer
extends AbstractMandatoryClassInitializer {
    public static final String XPROPERTY_ASYNC_ENABLED = "async_enabled";
    public static final String XPROPERTY_ASYNC_CACHED = "async_cached";
    public static final String XPROPERTY_ASYNC_CONTEXT = "async_context";
    @Inject
    private ContextStoreManager contextStore;
    @Inject
    private LocalizationManager localization;
    @Inject
    private Logger logger;

    public AbstractAsyncClassDocumentInitializer(EntityReference reference) {
        super(reference);
    }

    @Override
    protected void createClass(BaseClass xclass) {
        List<String> contextEntries;
        xclass.addBooleanField(XPROPERTY_ASYNC_ENABLED, "Asynchronous rendering", null, Boolean.FALSE);
        xclass.addBooleanField(XPROPERTY_ASYNC_CACHED, "Cached", null, Boolean.FALSE);
        try {
            contextEntries = this.contextStore.getSupportedEntries();
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to get supported context entries", (Throwable)e);
            contextEntries = Collections.emptyList();
        }
        StringBuilder entriesString = new StringBuilder();
        for (String entry : contextEntries) {
            if (entriesString.length() > 0) {
                entriesString.append('|');
            }
            entriesString.append(entry);
            String translation = this.localization.getTranslationPlain("rendering.async.context.entry." + entry, this.localization.getDefaultLocale(), new Object[0]);
            if (translation == null) continue;
            entriesString.append('=');
            entriesString.append(translation);
        }
        StaticListClass asyncClass = xclass.addStaticListField(XPROPERTY_ASYNC_CONTEXT);
        asyncClass.setPrettyName("Context elements");
        asyncClass.setSize(5);
        asyncClass.setMultiSelect(true);
        asyncClass.setValues(entriesString.toString());
        asyncClass.setSeparator(", ");
    }
}

