/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.job;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.job.JobRequestContext;
import com.xpn.xwiki.web.XWikiServletRequestStub;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.event.JobStartedEvent;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="com.xpn.xwiki.internal.job.JobRequestContextInitializer")
@Singleton
@Deprecated
public class JobRequestContextInitializer
extends AbstractEventListener {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Logger logger;

    public JobRequestContextInitializer() {
        super(JobRequestContextInitializer.class.getName(), new Event[]{new JobStartedEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiContext xcontext;
        JobStartedEvent jobStartedEvent = (JobStartedEvent)event;
        JobRequestContext jobRequestContext = (JobRequestContext)jobStartedEvent.getRequest().getProperty("oldcore.xwikicontext");
        if (jobRequestContext != null && (xcontext = (XWikiContext)this.xcontextProvider.get()) != null) {
            if (jobRequestContext.isWikiIdSet()) {
                xcontext.setWikiId(jobRequestContext.getWikiId());
            }
            if (jobRequestContext.isUserReferenceSet()) {
                xcontext.setUserReference(jobRequestContext.getUserReference());
            }
            if (jobRequestContext.isDocumentSet()) {
                XWikiDocument document = this.getDocument(jobRequestContext, xcontext);
                xcontext.setDoc(document);
            }
            if (jobRequestContext.isSDocumentSet()) {
                XWikiDocument sdocument = this.getSDocument(jobRequestContext, xcontext);
                xcontext.put("sdoc", sdocument);
            }
            if (jobRequestContext.isRequestSet()) {
                xcontext.setRequest(new XWikiServletRequestStub(jobRequestContext.getRequestURL(), jobRequestContext.getRequestContextPath(), jobRequestContext.getRequestParameters()));
            }
        }
    }

    private XWikiDocument getDocument(JobRequestContext jobRequestContext, XWikiContext xcontext) {
        if (jobRequestContext.getDocument() != null) {
            return jobRequestContext.getDocument();
        }
        if (jobRequestContext.getDocumentReference() != null) {
            try {
                return xcontext.getWiki().getDocument(jobRequestContext.getDocumentReference(), xcontext);
            }
            catch (XWikiException e) {
                this.logger.error("Failed to get document with reference [{}]", (Object)jobRequestContext.getDocumentReference(), (Object)e);
            }
        }
        return null;
    }

    private XWikiDocument getSDocument(JobRequestContext jobRequestContext, XWikiContext xcontext) {
        if (jobRequestContext.getSDocument() != null) {
            return jobRequestContext.getSDocument();
        }
        if (jobRequestContext.getSDocumentReference() != null) {
            try {
                return xcontext.getWiki().getDocument(jobRequestContext.getSDocumentReference(), xcontext);
            }
            catch (XWikiException e) {
                this.logger.error("Failed to get secure document with reference [{}]", (Object)jobRequestContext.getSDocumentReference(), (Object)e);
            }
        }
        return null;
    }
}

