/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.filter.output;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.filter.XWikiDocumentFilter;
import com.xpn.xwiki.internal.filter.XWikiDocumentFilterCollection;
import com.xpn.xwiki.internal.filter.output.AbstractEntityOutputFilterStream;
import com.xpn.xwiki.internal.filter.output.BaseClassOutputFilterStream;
import com.xpn.xwiki.internal.filter.output.BaseObjectOutputFilterStream;
import com.xpn.xwiki.internal.filter.output.EntityOutputFilterStream;
import com.xpn.xwiki.internal.filter.output.XWikiAttachmentOutputFilterStream;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.math.NumberUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.filter.FilterDescriptorManager;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.input.InputSource;
import org.xwiki.localization.LocalizationContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.WrappingListener;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.user.UserReference;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class XWikiDocumentOutputFilterStream
extends AbstractEntityOutputFilterStream<XWikiDocument>
implements Initializable {
    @Inject
    private FilterDescriptorManager filterManager;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    private LocalizationContext localizationContext;
    @Inject
    private EntityOutputFilterStream<XWikiAttachment> attachmentFilter;
    @Inject
    private EntityOutputFilterStream<BaseClass> classFilter;
    @Inject
    private EntityOutputFilterStream<BaseObject> objectFilter;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    private WrappingListener contentListener = new WrappingListener();
    private DefaultWikiPrinter currentWikiPrinter;
    private Syntax previousTargetSyntax;
    private Locale currentLocale;
    private String currentVersion;
    private FilterEventParameters currentLocaleParameters;
    private Locale currentDefaultLocale;
    private UserReference previousCreationAuthor;
    private Date previousCreationDate;

    public void initialize() throws InitializationException {
        this.initialize(this.attachmentFilter, this.classFilter, this.objectFilter);
    }

    @Override
    protected Object createFilter() {
        ArrayList<XWikiDocumentFilter> filters = new ArrayList<XWikiDocumentFilter>(this.children.size() + 1);
        for (EntityOutputFilterStream child : this.children) {
            filters.add((XWikiDocumentFilter)child.getFilter());
        }
        filters.add(this);
        this.filter = new XWikiDocumentFilterCollection(filters){

            @Override
            public void beginWikiClass(FilterEventParameters parameters) throws FilterException {
                if (!XWikiDocumentOutputFilterStream.this.objectFilter.isEnabled()) {
                    XWikiDocumentOutputFilterStream.this.classFilter.enable();
                }
                super.beginWikiClass(parameters);
            }

            @Override
            public void endWikiClass(FilterEventParameters parameters) throws FilterException {
                super.endWikiClass(parameters);
                XWikiDocumentOutputFilterStream.this.classFilter.disable();
            }

            @Override
            public void beginWikiObject(String name, FilterEventParameters parameters) throws FilterException {
                XWikiDocumentOutputFilterStream.this.objectFilter.enable();
                super.beginWikiObject(name, parameters);
            }

            @Override
            public void endWikiObject(String name, FilterEventParameters parameters) throws FilterException {
                super.endWikiObject(name, parameters);
                XWikiDocumentOutputFilterStream.this.objectFilter.disable();
            }

            @Override
            public void onWikiAttachment(String name, InputStream content, Long size, FilterEventParameters parameters) throws FilterException {
                XWikiDocumentOutputFilterStream.this.attachmentFilter.enable();
                super.onWikiAttachment(name, content, size, parameters);
                XWikiDocumentOutputFilterStream.this.attachmentFilter.disable();
            }
        };
        if (this.contentListener != null) {
            return this.filterManager.createCompositeFilter(new Object[]{this.contentListener, this.filter});
        }
        return this.filter;
    }

    private XWikiAttachmentOutputFilterStream getXWikiAttachmentOutputFilterStream() {
        return (XWikiAttachmentOutputFilterStream)this.attachmentFilter;
    }

    private BaseClassOutputFilterStream getBaseClassOutputFilterStream() {
        return (BaseClassOutputFilterStream)this.classFilter;
    }

    private BaseObjectOutputFilterStream getBaseObjectOutputFilterStream() {
        return (BaseObjectOutputFilterStream)this.objectFilter;
    }

    public void disableRenderingEvents() {
        this.contentListener = null;
    }

    @Override
    protected EntityReference getDefaultReference() {
        EntityReference reference = super.getDefaultReference();
        if (reference != null) {
            return reference;
        }
        if (this.entity != null) {
            return ((XWikiDocument)this.entity).getDocumentReference();
        }
        return null;
    }

    private void begin(FilterEventParameters parameters) throws FilterException {
        XWikiContext xcontext;
        DocumentReference documentReference = this.resolveCurrentDocumentReference();
        if (this.entity == null) {
            this.entity = new XWikiDocument(documentReference, this.currentLocale);
        } else {
            ((XWikiDocument)this.entity).setDocumentReference(documentReference);
            ((XWikiDocument)this.entity).setLocale(this.currentLocale);
        }
        ((XWikiDocument)this.entity).setRestricted(true);
        DocumentReference defaultAuthorDocumentReference = this.properties.isAuthorSet() ? this.properties.getAuthor() : ((xcontext = (XWikiContext)this.xcontextProvider.get()) != null ? xcontext.getUserReference() : null);
        UserReference defaultAuthorReference = this.userDocumentResolver.resolve((Object)defaultAuthorDocumentReference, new Object[0]);
        ((XWikiDocument)this.entity).getAuthors().setEffectiveMetadataAuthor(this.getUserReference("revision_author", parameters, defaultAuthorReference));
        ((XWikiDocument)this.entity).getAuthors().setOriginalMetadataAuthor(this.getUserReference("revision_original_author", parameters, ((XWikiDocument)this.entity).getAuthors().getEffectiveMetadataAuthor()));
        ((XWikiDocument)this.entity).getAuthors().setContentAuthor(this.getUserReference("content_author", parameters, ((XWikiDocument)this.entity).getAuthors().getEffectiveMetadataAuthor()));
        ((XWikiDocument)this.entity).setDate(this.getDate("revision_date", parameters, new Date()));
        ((XWikiDocument)this.entity).setContentUpdateDate(this.getDate("content_date", parameters, ((XWikiDocument)this.entity).getDate()));
        UserReference defaultCreationAuthor = this.previousCreationAuthor;
        Date defaultCreationDate = this.previousCreationDate;
        if (defaultCreationAuthor == null) {
            defaultCreationAuthor = ((XWikiDocument)this.entity).getAuthors().getEffectiveMetadataAuthor();
            defaultCreationDate = ((XWikiDocument)this.entity).getDate();
        }
        ((XWikiDocument)this.entity).getAuthors().setCreator(this.getUserReference("creation_author", this.currentLocaleParameters, defaultCreationAuthor));
        ((XWikiDocument)this.entity).setCreationDate(this.getDate("creation_date", this.currentLocaleParameters, defaultCreationDate));
        ((XWikiDocument)this.entity).setDefaultLocale(this.currentDefaultLocale);
        ((XWikiDocument)this.entity).setSyntax(this.getSyntax("syntax", parameters, null));
        ((XWikiDocument)this.entity).setParentReference(this.getEntityReference("parent_reference", parameters, null));
        ((XWikiDocument)this.entity).setCustomClass(this.getString("customclass", parameters, null));
        ((XWikiDocument)this.entity).setTitle(this.getString("title", parameters, null));
        ((XWikiDocument)this.entity).setDefaultTemplate(this.getString("defaulttemplate", parameters, null));
        ((XWikiDocument)this.entity).setValidationScript(this.getString("validationscript", parameters, null));
        ((XWikiDocument)this.entity).setHidden(this.getBoolean("hidden", parameters, false));
        ((XWikiDocument)this.entity).setMinorEdit(this.getBoolean("revision_minor", parameters, false));
        ((XWikiDocument)this.entity).setEnforceRequiredRights(this.getBoolean("enforce_required_rights", parameters, false));
        String revisions = this.getString("xwiki_jrcsrevisions", this.currentLocaleParameters, null);
        if (revisions != null) {
            try {
                ((XWikiDocument)this.entity).setDocumentArchive(revisions);
            }
            catch (XWikiException e) {
                throw new FilterException("Failed to set document archive", (Throwable)e);
            }
        }
        if (this.currentVersion != null && this.properties.isVersionPreserved()) {
            if (VALID_VERSION.matcher(this.currentVersion).matches()) {
                ((XWikiDocument)this.entity).setVersion(this.currentVersion);
            } else if (NumberUtils.isDigits((String)this.currentVersion)) {
                ((XWikiDocument)this.entity).setVersion(this.currentVersion + ".1");
            }
        }
        ((XWikiDocument)this.entity).setComment(this.getString("revision_comment", parameters, ""));
        if (this.contentListener != null) {
            this.previousTargetSyntax = this.renderingContext.getTargetSyntax();
        }
        if (parameters.containsKey((Object)"content")) {
            ((XWikiDocument)this.entity).setContent(this.getString("content", parameters, null));
            if (this.contentListener != null) {
                this.currentWikiPrinter = null;
                this.contentListener.setWrappedListener(null);
            }
        } else if (this.contentListener != null) {
            if (this.properties != null && this.properties.getDefaultSyntax() != null) {
                ((XWikiDocument)this.entity).setSyntax(this.properties.getDefaultSyntax());
            } else {
                ((XWikiDocument)this.entity).setSyntax(((XWikiDocument)this.entity).getSyntax());
            }
            ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
            String syntaxString = ((XWikiDocument)this.entity).getSyntax().toIdString();
            if (componentManager.hasComponent(PrintRendererFactory.class, syntaxString)) {
                PrintRendererFactory rendererFactory;
                try {
                    rendererFactory = (PrintRendererFactory)componentManager.getInstance(PrintRendererFactory.class, syntaxString);
                }
                catch (ComponentLookupException e) {
                    throw new FilterException(String.format("Failed to find PrintRendererFactory for syntax [%s]", ((XWikiDocument)this.entity).getSyntax()), (Throwable)e);
                }
                this.currentWikiPrinter = new DefaultWikiPrinter();
                ((MutableRenderingContext)this.renderingContext).setTargetSyntax(rendererFactory.getSyntax());
                this.contentListener.setWrappedListener((Listener)rendererFactory.createRenderer((WikiPrinter)this.currentWikiPrinter));
            }
        }
        this.getBaseClassOutputFilterStream().setEntity(((XWikiDocument)this.entity).getXClass());
    }

    private void end(FilterEventParameters parameters) {
        if (this.currentWikiPrinter != null) {
            ((XWikiDocument)this.entity).setContent(this.currentWikiPrinter.getBuffer().toString());
            this.contentListener.setWrappedListener(null);
            this.currentWikiPrinter = null;
        }
        if (this.contentListener != null) {
            ((MutableRenderingContext)this.renderingContext).setTargetSyntax(this.previousTargetSyntax);
        }
    }

    @Override
    public void beginWikiDocument(String name, FilterEventParameters parameters) throws FilterException {
        super.beginWikiDocument(name, parameters);
        this.currentDefaultLocale = parameters.containsKey((Object)"locale") ? this.get((Type)((Object)Locale.class), "locale", parameters, Locale.ROOT) : this.localizationContext.getCurrentLocale();
        this.currentLocale = Locale.ROOT;
        this.currentLocaleParameters = parameters;
        this.begin(parameters);
    }

    @Override
    public void endWikiDocument(String name, FilterEventParameters parameters) throws FilterException {
        this.end(parameters);
        super.endWikiDocument(name, parameters);
        this.currentLocaleParameters = null;
        this.currentLocale = null;
        this.currentDefaultLocale = null;
        this.previousCreationAuthor = null;
        this.previousCreationDate = null;
    }

    @Override
    public void beginWikiDocumentLocale(Locale locale, FilterEventParameters parameters) throws FilterException {
        this.currentLocale = locale;
        this.currentLocaleParameters = parameters;
        this.begin(parameters);
    }

    @Override
    public void endWikiDocumentLocale(Locale locale, FilterEventParameters parameters) throws FilterException {
        this.end(parameters);
        this.currentLocale = null;
        this.currentLocaleParameters = null;
        this.previousCreationAuthor = null;
        this.previousCreationDate = null;
    }

    @Override
    public void beginWikiDocumentRevision(String version, FilterEventParameters parameters) throws FilterException {
        this.currentVersion = version;
        this.begin(parameters);
    }

    @Override
    public void endWikiDocumentRevision(String version, FilterEventParameters parameters) throws FilterException {
        this.end(parameters);
        this.previousCreationAuthor = ((XWikiDocument)this.entity).getAuthors().getCreator();
        this.previousCreationDate = ((XWikiDocument)this.entity).getCreationDate();
        this.currentVersion = null;
    }

    @Override
    public void endWikiClass(FilterEventParameters parameters) throws FilterException {
        this.getBaseClassOutputFilterStream().setEntity(null);
    }

    @Override
    public void onWikiAttachment(String name, InputStream content, Long size, FilterEventParameters parameters) throws FilterException {
        this.endAttachment();
    }

    @Override
    public void endWikiDocumentAttachment(String name, InputSource content, Long size, FilterEventParameters parameters) throws FilterException {
        this.endAttachment();
    }

    private void endAttachment() {
        ((XWikiDocument)this.entity).setAttachment((XWikiAttachment)this.getXWikiAttachmentOutputFilterStream().getEntity());
        this.getXWikiAttachmentOutputFilterStream().setEntity(null);
    }

    @Override
    public void endWikiObject(String name, FilterEventParameters parameters) throws FilterException {
        super.endWikiObject(name, parameters);
        BaseObject baseObject = (BaseObject)this.getBaseObjectOutputFilterStream().getEntity();
        if (baseObject.getNumber() < 0) {
            ((XWikiDocument)this.entity).addXObject(baseObject);
        } else {
            ((XWikiDocument)this.entity).setXObject(baseObject.getNumber(), baseObject);
        }
        this.getBaseObjectOutputFilterStream().setEntity(null);
    }
}

