/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.filter.output;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.filter.output.UserInstanceOutputFilter;
import com.xpn.xwiki.internal.filter.output.UserInstanceOutputProperties;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.output.AbstractBeanOutputFilterStream;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.properties.ConverterManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Named(value="xwiki+instance+users")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class UserInstanceOutputFilterStream
extends AbstractBeanOutputFilterStream<UserInstanceOutputProperties>
implements UserInstanceOutputFilter {
    private static final EntityReference DEFAULT_SPACE = new EntityReference("XWiki", EntityType.SPACE);
    @Inject
    @Named(value="relative")
    private EntityReferenceResolver<String> relativeResolver;
    @Inject
    private WikiDescriptorManager wikis;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private ConverterManager converter;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    private String currentWiki;
    private List<String> members;

    public void close() throws IOException {
    }

    private <T> T get(Type type, String key, FilterEventParameters parameters, T def) {
        if (!parameters.containsKey((Object)key)) {
            return def;
        }
        Object value = parameters.get((Object)key);
        if (value == null) {
            return null;
        }
        if (TypeUtils.isInstance((Object)value, (Type)type)) {
            return (T)value;
        }
        return (T)this.converter.convert(type, value);
    }

    private Date getDate(String key, FilterEventParameters parameters, Date def) {
        return this.get((Type)((Object)Date.class), key, parameters, (Object)def);
    }

    private String getString(String key, FilterEventParameters parameters, String def) {
        return this.get((Type)((Object)String.class), key, parameters, (Object)def);
    }

    private boolean getBoolean(String key, FilterEventParameters parameters, boolean def) {
        return this.get(Boolean.TYPE, key, parameters, def);
    }

    private String getCurrentWiki() {
        String wiki = this.currentWiki;
        if (wiki == null) {
            wiki = this.wikis.getCurrentWikiId();
        }
        return wiki;
    }

    private DocumentReference getUserDocumentReference(String id) {
        return new DocumentReference(this.getCurrentWiki(), DEFAULT_SPACE.getName(), id);
    }

    private XWikiDocument getUserDocument(String id) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return xcontext.getWiki().getDocument(this.getUserDocumentReference(id), xcontext);
    }

    private DocumentReference getGroupDocumentReference(String id) {
        return new DocumentReference(this.getCurrentWiki(), DEFAULT_SPACE.getName(), id);
    }

    private XWikiDocument getGroupDocument(String id) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return xcontext.getWiki().getDocument(this.getGroupDocumentReference(id), xcontext);
    }

    public void beginWiki(String name, FilterEventParameters parameters) throws FilterException {
        this.currentWiki = name;
    }

    public void endWiki(String name, FilterEventParameters parameters) throws FilterException {
        this.currentWiki = null;
    }

    public void beginUser(String name, FilterEventParameters parameters) throws FilterException {
        BaseClass userClass;
        XWikiDocument userDocument;
        try {
            userDocument = this.getUserDocument(name);
            userDocument = userDocument.clone();
        }
        catch (XWikiException e) {
            throw new FilterException("Failed to get an XWikiDocument for user name [" + name + "]", (Throwable)e);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (parameters.containsKey((Object)"firstname")) {
            map.put("first_name", this.getString("firstname", parameters, ""));
        }
        if (parameters.containsKey((Object)"lastname")) {
            map.put("last_name", this.getString("lastname", parameters, ""));
        }
        if (parameters.containsKey((Object)"email")) {
            map.put("email", this.getString("email", parameters, ""));
        }
        map.put("active", this.getBoolean("active", parameters, true) ? 1 : 0);
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            userClass = xcontext.getWiki().getUserClass(xcontext);
        }
        catch (XWikiException e) {
            throw new FilterException("Failed to get user class", (Throwable)e);
        }
        BaseObject userObject = userDocument.getXObject(userClass.getReference());
        if (userObject == null) {
            try {
                userObject = userDocument.newXObject((EntityReference)userClass.getReference(), xcontext);
            }
            catch (XWikiException e) {
                throw new FilterException("Failed to create user object", (Throwable)e);
            }
            try {
                xcontext.getWiki().protectUserPage(userDocument.getFullName(), "edit", userDocument, xcontext);
            }
            catch (XWikiException e) {
                throw new FilterException("Failed to initialize user", (Throwable)e);
            }
        }
        userClass.fromValueMap(map, userObject);
        if (userDocument.isNew()) {
            userDocument.setCreatorReference(userDocument.getDocumentReference());
            userDocument.setAuthorReference(userDocument.getDocumentReference());
            userDocument.setContentAuthorReference(userDocument.getDocumentReference());
            if (((UserInstanceOutputProperties)((Object)this.properties)).isVersionPreserved()) {
                if (parameters.containsKey((Object)"creation_date")) {
                    userDocument.setCreationDate(this.getDate("creation_date", parameters, new Date()));
                }
                if (parameters.containsKey((Object)"revision_date")) {
                    userDocument.setDate(this.getDate("revision_date", parameters, new Date()));
                    userDocument.setContentUpdateDate(this.getDate("revision_date", parameters, new Date()));
                }
            }
            userDocument.setMetaDataDirty(false);
            userDocument.setContentDirty(false);
        }
        try {
            xcontext.getWiki().saveDocument(userDocument, ((UserInstanceOutputProperties)((Object)this.properties)).getSaveComment(), xcontext);
        }
        catch (XWikiException e) {
            throw new FilterException("Failed to save user document", (Throwable)e);
        }
    }

    public void endUser(String name, FilterEventParameters parameters) throws FilterException {
    }

    @Deprecated
    public void beginGroup(String name, FilterEventParameters parameters) throws FilterException {
        this.beginGroupContainer(name, parameters);
    }

    public void beginGroupContainer(String name, FilterEventParameters parameters) throws FilterException {
        this.members = new ArrayList<String>();
    }

    private void addMember(String member, XWikiDocument groupDocument, BaseClass groupClass, XWikiContext xcontext) throws FilterException {
        BaseObject memberObject;
        try {
            memberObject = groupDocument.newXObject((EntityReference)groupClass.getReference(), xcontext);
        }
        catch (XWikiException e) {
            throw new FilterException("Failed to add a group member object", (Throwable)e);
        }
        memberObject.setStringValue("member", member);
    }

    @Deprecated
    public void endGroup(String name, FilterEventParameters parameters) throws FilterException {
        this.endGroupContainer(name, parameters);
    }

    public void endGroupContainer(String name, FilterEventParameters parameters) throws FilterException {
        BaseClass groupClass;
        XWikiDocument groupDocument;
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            groupDocument = this.getGroupDocument(name);
        }
        catch (XWikiException e) {
            throw new FilterException("Failed to get an XWikiDocument for group name [" + name + "]", (Throwable)e);
        }
        try {
            groupClass = xcontext.getWiki().getGroupClass(xcontext);
        }
        catch (XWikiException e) {
            throw new FilterException("Failed to get group class", (Throwable)e);
        }
        if (this.members.isEmpty()) {
            this.addMember("", groupDocument, groupClass, xcontext);
        } else {
            for (String member : this.members) {
                this.addMember(member, groupDocument, groupClass, xcontext);
            }
        }
        try {
            xcontext.getWiki().saveDocument(groupDocument, ((UserInstanceOutputProperties)((Object)this.properties)).getSaveComment(), xcontext);
        }
        catch (XWikiException e) {
            throw new FilterException("Failed to save group document", (Throwable)e);
        }
        this.members = null;
    }

    private void addMember(String name) {
        EntityReference memberReference = this.relativeResolver.resolve((Object)name, EntityType.DOCUMENT, new Object[]{DEFAULT_SPACE});
        this.members.add((String)this.serializer.serialize(memberReference, new Object[0]));
    }

    public void onGroupMemberUser(String name, FilterEventParameters parameters) throws FilterException {
        this.addMember(name);
    }

    public void onGroupMemberGroup(String name, FilterEventParameters parameters) throws FilterException {
        this.addMember(((UserInstanceOutputProperties)((Object)this.properties)).getGroupPrefix() + name + ((UserInstanceOutputProperties)((Object)this.properties)).getGroupSuffix());
    }
}

