/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.filter.output;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.internal.filter.output.AbstractEntityOutputFilterStream;
import com.xpn.xwiki.internal.objects.classes.PropertyClassProvider;
import com.xpn.xwiki.internal.objects.meta.PropertyMetaClassInterface;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class PropertyClassOutputFilterStream
extends AbstractEntityOutputFilterStream<PropertyClass> {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private Logger logger;
    private BaseClass currentXClass;
    private PropertyMetaClassInterface currentClassPropertyMeta;

    public void setCurrentXClass(BaseClass currentXClass) {
        this.currentXClass = currentXClass;
    }

    @Override
    public void beginWikiClassProperty(String name, String type, FilterEventParameters parameters) throws FilterException {
        if (this.enabled) {
            PropertyClassProvider provider;
            block6: {
                ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
                this.currentClassPropertyMeta = null;
                try {
                    if (componentManager.hasComponent(PropertyClassProvider.class, type)) {
                        provider = (PropertyClassProvider)componentManager.getInstance(PropertyClassProvider.class, type);
                        break block6;
                    }
                    String classType = StringUtils.removeEnd((String)StringUtils.substringAfterLast((String)type, (String)"."), (String)"Class");
                    if (componentManager.hasComponent(PropertyClassProvider.class, classType)) {
                        provider = (PropertyClassProvider)componentManager.getInstance(PropertyClassProvider.class, classType);
                        break block6;
                    }
                    this.logger.warn("Unknown property type [{}]", (Object)type);
                    return;
                }
                catch (ComponentLookupException e) {
                    throw new FilterException(String.format("Failed to get instance of the property class provider for type [%s]", type), (Throwable)e);
                }
            }
            this.currentClassPropertyMeta = provider.getDefinition();
            if (this.entity == null) {
                this.entity = (PropertyClass)provider.getInstance();
            }
            ((PropertyClass)this.entity).setName(name);
            ((PropertyClass)this.entity).setObject(this.currentXClass);
        }
    }

    @Override
    public void endWikiClassProperty(String name, String type, FilterEventParameters parameters) throws FilterException {
        if (this.enabled) {
            this.currentClassPropertyMeta = null;
        }
    }

    @Override
    public void onWikiClassPropertyField(String name, String value, FilterEventParameters parameters) throws FilterException {
        if (this.entity != null) {
            PropertyClass propertyClass;
            try {
                propertyClass = (PropertyClass)this.currentClassPropertyMeta.get(name);
            }
            catch (XWikiException e) {
                throw new FilterException(String.format("Failed to get definition of field [%s] for property type [%s]", name, ((PropertyClass)this.entity).getClassType()), (Throwable)e);
            }
            if (propertyClass == null) {
                this.logger.warn("Unknown property meta class field [{}] for property type [{}]", (Object)name, (Object)((PropertyClass)this.entity).getClassType());
                return;
            }
            BaseProperty field = null;
            try {
                field = propertyClass.fromString(value);
            }
            catch (XWikiException e) {
                throw new FilterException(String.format("Failed to parse value [%s] for field [%s]", value, name), (Throwable)e);
            }
            ((PropertyClass)this.entity).safeput(name, field);
        }
    }
}

