/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.filter.input;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.filter.XWikiDocumentFilter;
import com.xpn.xwiki.internal.filter.input.BaseClassEventGenerator;
import com.xpn.xwiki.internal.filter.input.BaseObjectEventGenerator;
import com.xpn.xwiki.internal.filter.input.XWikiAttachmentEventGenerator;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.suigeneris.jrcs.rcs.Version;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.instance.input.DocumentInstanceInputProperties;
import org.xwiki.filter.instance.input.EntityEventGenerator;
import org.xwiki.filter.instance.internal.input.AbstractBeanEntityEventGenerator;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceSerializer;

@Component
@Singleton
public class XWikiDocumentLocaleEventGenerator
extends AbstractBeanEntityEventGenerator<XWikiDocument, XWikiDocumentFilter, DocumentInstanceInputProperties> {
    public static final ParameterizedType ROLE = new DefaultParameterizedType(null, EntityEventGenerator.class, new Type[]{XWikiDocument.class, DocumentInstanceInputProperties.class});
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Logger logger;
    @Inject
    private EntityEventGenerator<XWikiAttachment> attachmentEventGenerator;
    @Inject
    private EntityEventGenerator<BaseClass> classEventGenerator;
    @Inject
    private EntityEventGenerator<BaseObject> objectEventGenerator;
    @Inject
    @Named(value="document")
    private UserReferenceSerializer<DocumentReference> userSerializer;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactwikiSerializer;

    private String toString(UserReference userReference2) {
        DocumentReference userDocumentReference = (DocumentReference)this.userSerializer.serialize(userReference2);
        String userString = userDocumentReference != null ? (String)this.compactwikiSerializer.serialize((EntityReference)userDocumentReference, new Object[0]) : "XWiki.XWikiGuest";
        return userString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(XWikiDocument document, Object filter, XWikiDocumentFilter documentFilter, DocumentInstanceInputProperties properties) throws FilterException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        String currentWiki = xcontext.getWikiId();
        try {
            xcontext.setWikiId(document.getDocumentReference().getWikiReference().getName());
            FilterEventParameters localeParameters = new FilterEventParameters();
            if (properties.isWithJRCSRevisions()) {
                try {
                    localeParameters.put((Object)"xwiki_jrcsrevisions", (Object)document.getDocumentArchive(xcontext).getArchive(xcontext));
                }
                catch (XWikiException e) {
                    this.logger.error("Document [{}] has malformed history", (Object)document.getDocumentReference(), (Object)e);
                }
            }
            localeParameters.put((Object)"creation_author", (Object)this.toString(document.getAuthors().getCreator()));
            localeParameters.put((Object)"creation_date", (Object)document.getCreationDate());
            localeParameters.put((Object)"lastrevision", (Object)document.getVersion());
            documentFilter.beginWikiDocumentLocale(document.getLocale(), localeParameters);
            if (properties.isWithRevisions()) {
                try {
                    for (Version version : document.getRevisions(xcontext)) {
                        XWikiDocument revisionDocument = xcontext.getWiki().getDocument(document, version.toString(), xcontext);
                        this.writeRevision(revisionDocument, filter, documentFilter, properties);
                    }
                }
                catch (XWikiException e) {
                    this.logger.error("Failed to get document [{}] history", (Object)document.getDocumentReference(), (Object)e);
                }
            }
            this.writeRevision(document, filter, documentFilter, properties);
            documentFilter.endWikiDocumentLocale(document.getLocale(), FilterEventParameters.EMPTY);
        }
        finally {
            xcontext.setWikiId(currentWiki);
        }
    }

    private void writeRevision(XWikiDocument document, Object filter, XWikiDocumentFilter documentFilter, DocumentInstanceInputProperties properties) throws FilterException {
        BaseClass xclass;
        FilterEventParameters revisionParameters = new FilterEventParameters();
        if (document.getRelativeParentReference() != null) {
            revisionParameters.put((Object)"parent_reference", (Object)document.getRelativeParentReference());
        }
        revisionParameters.put((Object)"title", (Object)document.getTitle());
        if (!document.getCustomClass().isEmpty()) {
            revisionParameters.put((Object)"customclass", (Object)document.getCustomClass());
        }
        if (!document.getDefaultTemplate().isEmpty()) {
            revisionParameters.put((Object)"defaulttemplate", (Object)document.getDefaultTemplate());
        }
        if (!document.getValidationScript().isEmpty()) {
            revisionParameters.put((Object)"validationscript", (Object)document.getValidationScript());
        }
        revisionParameters.put((Object)"syntax", (Object)document.getSyntax());
        revisionParameters.put((Object)"hidden", (Object)document.isHidden());
        if (document.isEnforceRequiredRights()) {
            revisionParameters.put((Object)"enforce_required_rights", (Object)true);
        }
        revisionParameters.put((Object)"revision_author", (Object)this.toString(document.getAuthors().getEffectiveMetadataAuthor()));
        revisionParameters.put((Object)"revision_original_author", (Object)this.toString(document.getAuthors().getOriginalMetadataAuthor()));
        revisionParameters.put((Object)"revision_comment", (Object)document.getComment());
        revisionParameters.put((Object)"revision_date", (Object)document.getDate());
        revisionParameters.put((Object)"revision_minor", (Object)document.isMinorEdit());
        revisionParameters.put((Object)"content_author", (Object)this.toString(document.getAuthors().getContentAuthor()));
        revisionParameters.put((Object)"content_date", (Object)document.getContentUpdateDate());
        revisionParameters.put((Object)"content", (Object)document.getContent());
        if (properties.isWithWikiDocumentContentHTML()) {
            try {
                XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
                revisionParameters.put((Object)"content_html", (Object)document.getRenderedContent(xcontext));
            }
            catch (XWikiException e) {
                this.logger.error("Failed to render content of document [{}] as HTML", (Object)document.getDocumentReference(), (Object)e);
            }
        }
        documentFilter.beginWikiDocumentRevision(document.getVersion(), revisionParameters);
        if (properties.isWithWikiAttachments()) {
            ArrayList<XWikiAttachment> sortedAttachments = new ArrayList<XWikiAttachment>(document.getAttachmentList());
            Collections.sort(sortedAttachments, new Comparator<XWikiAttachment>(){

                @Override
                public int compare(XWikiAttachment attachement1, XWikiAttachment attachement2) {
                    if (attachement1 == null || attachement2 == null) {
                        int result = 0;
                        if (attachement1 != null) {
                            result = -1;
                        } else if (attachement2 != null) {
                            result = 1;
                        }
                        return result;
                    }
                    return attachement1.getFilename().compareTo(attachement2.getFilename());
                }
            });
            for (XWikiAttachment attachment : sortedAttachments) {
                ((XWikiAttachmentEventGenerator)this.attachmentEventGenerator).write(attachment, filter, documentFilter, properties);
            }
        }
        if (properties.isWithWikiClass() && !(xclass = document.getXClass()).getFieldList().isEmpty()) {
            ((BaseClassEventGenerator)this.classEventGenerator).write(xclass, filter, documentFilter, properties);
        }
        if (properties.isWithWikiObjects()) {
            for (List<BaseObject> xobjects : document.getXObjects().values()) {
                for (BaseObject xobject : xobjects) {
                    if (xobject == null) continue;
                    ((BaseObjectEventGenerator)this.objectEventGenerator).write(xobject, filter, documentFilter, properties);
                }
            }
        }
        documentFilter.endWikiDocumentRevision(document.getVersion(), revisionParameters);
    }
}

