/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.filter.input;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiAttachmentArchive;
import com.xpn.xwiki.internal.filter.XWikiAttachmentFilter;
import com.xpn.xwiki.internal.filter.input.XWikiAttachmentContentInputSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.input.DefaultByteArrayInputSource;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.instance.input.DocumentInstanceInputProperties;
import org.xwiki.filter.instance.input.EntityEventGenerator;
import org.xwiki.filter.instance.internal.input.AbstractBeanEntityEventGenerator;

@Component
@Singleton
public class XWikiAttachmentEventGenerator
extends AbstractBeanEntityEventGenerator<XWikiAttachment, XWikiAttachmentFilter, DocumentInstanceInputProperties> {
    public static final ParameterizedType ROLE = new DefaultParameterizedType(null, EntityEventGenerator.class, new Type[]{XWikiAttachment.class, DocumentInstanceInputProperties.class});
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Logger logger;

    public void write(XWikiAttachment attachment, Object filter, XWikiAttachmentFilter attachmentFilter, DocumentInstanceInputProperties properties) throws FilterException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        FilterEventParameters attachmentParameters = this.getAttachmentParameters(attachment);
        if (properties.isWithWikiAttachmentJRCSRevisions()) {
            try {
                XWikiAttachmentArchive archive = attachment.loadArchive(xcontext);
                if (archive != null) {
                    attachmentParameters.put((Object)"xwiki_jrcsrevisions", (Object)archive.getArchiveAsString(xcontext));
                }
            }
            catch (XWikiException e) {
                this.logger.error("Attachment [{}] has malformed history", (Object)attachment.getReference(), (Object)e);
            }
        }
        this.writeAttachment(attachment, attachmentFilter, properties, attachmentParameters, xcontext);
    }

    private void writeAttachment(XWikiAttachment attachment, XWikiAttachmentFilter attachmentFilter, DocumentInstanceInputProperties properties, FilterEventParameters attachmentParameters, XWikiContext xcontext) throws FilterException {
        if (properties.isWithWikiAttachmentsRevisions()) {
            this.beginEndAttachment(attachment, attachmentFilter, properties, attachmentParameters, xcontext);
        } else {
            this.onAttachment(attachment, attachmentFilter, properties, attachmentParameters, xcontext);
        }
    }

    private void beginEndAttachment(XWikiAttachment attachment, XWikiAttachmentFilter attachmentFilter, DocumentInstanceInputProperties properties, FilterEventParameters attachmentParameters, XWikiContext xcontext) throws FilterException {
        AttachmentSource source = this.getAttachmentSource(attachment, properties, xcontext);
        attachmentFilter.beginWikiDocumentAttachment(attachment.getFilename(), source.source, source.size, attachmentParameters);
        try {
            this.writeRevisions(attachment, attachmentFilter, properties, xcontext);
        }
        catch (XWikiException e) {
            this.logger.error("Failed to write revisions for attachment [{}]", (Object)attachment.getReference(), (Object)e);
        }
        attachmentFilter.endWikiDocumentAttachment(attachment.getFilename(), source.source, source.size, attachmentParameters);
    }

    private AttachmentSource getAttachmentSource(XWikiAttachment attachment, DocumentInstanceInputProperties properties, XWikiContext xcontext) {
        return this.getAttachmentSource(attachment, properties, null, xcontext);
    }

    private AttachmentSource getAttachmentSource(XWikiAttachment attachmentRevision, DocumentInstanceInputProperties properties, XWikiAttachment rootAttachment, XWikiContext xcontext) {
        Long size;
        XWikiAttachmentContentInputSource source;
        String alias = null;
        if (this.isWithWikiAttachmentContent(attachmentRevision, properties)) {
            try {
                source = new XWikiAttachmentContentInputSource(attachmentRevision.getAttachmentContent(xcontext));
                size = attachmentRevision.getLongSize();
            }
            catch (XWikiException e) {
                this.logger.error("Failed to create the source from the content of the attachment [{}]", (Object)attachmentRevision.getReference(), (Object)e);
                source = new DefaultByteArrayInputSource(new byte[0]);
                size = 0L;
            }
            if (rootAttachment != null) {
                try {
                    alias = this.getAlias(attachmentRevision, rootAttachment, xcontext);
                }
                catch (Exception e) {
                    this.logger.error("Failed to search for an alias of the content of attachment [{}] in revision [{}]", new Object[]{rootAttachment.getReference(), attachmentRevision, e});
                }
            }
        } else {
            source = null;
            size = attachmentRevision.getLongSize();
        }
        return new AttachmentSource(size, (InputSource)source, alias);
    }

    private String getAlias(XWikiAttachment attachmentRevision, XWikiAttachment rootAttachment, XWikiContext xcontext) throws XWikiException, IOException {
        if (this.contentEquals(attachmentRevision, rootAttachment, xcontext)) {
            return "";
        }
        String revisionVersion = attachmentRevision.getVersion();
        Object[] versions = rootAttachment.getVersions();
        if (ArrayUtils.isNotEmpty((Object[])versions)) {
            for (Object version : versions) {
                String versionString = version.toString();
                if (revisionVersion.contentEquals(versionString)) {
                    return null;
                }
                try {
                    XWikiAttachment revision = rootAttachment.getAttachmentRevision(versionString, xcontext);
                    if (this.contentEquals(revision, attachmentRevision, xcontext)) {
                        return versionString;
                    }
                }
                catch (XWikiException e) {
                    this.logger.error("Failed to get the revision [{}] for attachment [{}]", new Object[]{versionString, rootAttachment.getReference(), e});
                }
            }
        }
        return null;
    }

    private boolean contentEquals(XWikiAttachment attachment1, XWikiAttachment attachment2, XWikiContext xcontext) throws XWikiException, IOException {
        if (attachment1.getContentLongSize(xcontext) == attachment2.getContentLongSize(xcontext)) {
            try (InputStream stream1 = attachment1.getContentInputStream(xcontext);){
                boolean bl;
                block13: {
                    InputStream stream2 = attachment2.getContentInputStream(xcontext);
                    try {
                        bl = IOUtils.contentEquals((InputStream)stream1, (InputStream)stream2);
                        if (stream2 == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (stream2 != null) {
                            try {
                                stream2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stream2.close();
                }
                return bl;
            }
        }
        return false;
    }

    private boolean isWithWikiAttachmentContent(XWikiAttachment attachmentRevision, DocumentInstanceInputProperties properties) {
        if (properties.isWithWikiAttachmentsContent()) {
            return properties.getAttachmentsContent().isEmpty() || properties.getAttachmentsContent().contains(attachmentRevision.getFilename());
        }
        return false;
    }

    private void onAttachment(XWikiAttachment attachment, XWikiAttachmentFilter attachmentFilter, DocumentInstanceInputProperties properties, FilterEventParameters attachmentParameters, XWikiContext xcontext) throws FilterException {
        Long size;
        InputStream content;
        if (this.isWithWikiAttachmentContent(attachment, properties)) {
            try {
                content = attachment.getContentInputStream(xcontext);
                size = attachment.getLongSize();
            }
            catch (XWikiException e) {
                this.logger.error("Failed to get the content of the attachment [{}]", (Object)attachment.getReference(), (Object)e);
                content = new ByteArrayInputStream(new byte[0]);
                size = 0L;
            }
        } else {
            content = null;
            size = attachment.getLongSize();
        }
        attachmentFilter.onWikiAttachment(attachment.getFilename(), content, size, attachmentParameters);
    }

    private void writeRevisions(XWikiAttachment attachment, XWikiAttachmentFilter attachmentFilter, DocumentInstanceInputProperties properties, XWikiContext xcontext) throws FilterException, XWikiException {
        Object[] versions;
        XWikiAttachmentArchive archive = attachment.getAttachmentArchive(xcontext);
        if (archive != null && ArrayUtils.isNotEmpty((Object[])(versions = archive.getVersions()))) {
            attachmentFilter.beginWikiAttachmentRevisions(FilterEventParameters.EMPTY);
            for (Object version : versions) {
                String versionString = version.toString();
                XWikiAttachment revision = attachment.getAttachmentRevision(versionString, xcontext);
                FilterEventParameters parameters = this.getAttachmentParameters(revision);
                AttachmentSource source = this.getAttachmentSource(revision, properties, attachment, xcontext);
                if (source.alias != null) {
                    parameters.put((Object)"revision_content_alias", (Object)source.alias);
                }
                attachmentFilter.beginWikiAttachmentRevision(versionString, source.source, source.size, parameters);
                attachmentFilter.endWikiAttachmentRevision(versionString, source.source, source.size, parameters);
            }
            attachmentFilter.endWikiAttachmentRevisions(FilterEventParameters.EMPTY);
        }
    }

    private FilterEventParameters getAttachmentParameters(XWikiAttachment attachment) {
        FilterEventParameters attachmentParameters = new FilterEventParameters();
        if (attachment.getAuthor() != null) {
            attachmentParameters.put((Object)"revision_author", (Object)attachment.getAuthor());
        }
        attachmentParameters.put((Object)"revision_comment", (Object)attachment.getComment());
        attachmentParameters.put((Object)"revision_date", (Object)attachment.getDate());
        attachmentParameters.put((Object)"revision", (Object)attachment.getVersion());
        if (StringUtils.isNotEmpty((CharSequence)attachment.getMimeType())) {
            attachmentParameters.put((Object)"mimetype", (Object)attachment.getMimeType());
        }
        if (StringUtils.isNotEmpty((CharSequence)attachment.getCharset())) {
            attachmentParameters.put((Object)"charset", (Object)attachment.getCharset());
        }
        return attachmentParameters;
    }

    private static class AttachmentSource {
        private final long size;
        private final InputSource source;
        private final String alias;

        AttachmentSource(long size, InputSource source, String alias) {
            this.size = size;
            this.source = source;
            this.alias = alias;
        }
    }
}

