/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.filter.input;

import com.xpn.xwiki.internal.filter.PropertyClassFilter;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.PropertyClass;
import java.util.Iterator;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.instance.input.DocumentInstanceInputProperties;
import org.xwiki.filter.instance.internal.input.AbstractBeanEntityEventGenerator;

@Component
@Singleton
public class PropertyClassEventGenerator
extends AbstractBeanEntityEventGenerator<PropertyClass, PropertyClassFilter, DocumentInstanceInputProperties> {
    public void write(PropertyClass xclassProperty, Object filter, PropertyClassFilter propertyFilter, DocumentInstanceInputProperties properties) throws FilterException {
        FilterEventParameters propertyParameters = FilterEventParameters.EMPTY;
        String classType = xclassProperty.getClassType();
        if (xclassProperty.getClass().getSimpleName().equals(classType + "Class")) {
            classType = xclassProperty.getClass().getName();
        }
        propertyFilter.beginWikiClassProperty(xclassProperty.getName(), classType, propertyParameters);
        Iterator it = xclassProperty.getSortedIterator();
        while (it.hasNext()) {
            BaseProperty bprop = (BaseProperty)it.next();
            propertyFilter.onWikiClassPropertyField(bprop.getName(), bprop.toText(), FilterEventParameters.EMPTY);
        }
        propertyFilter.endWikiClassProperty(xclassProperty.getName(), classType, propertyParameters);
    }
}

