/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.filter.input;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.filter.XWikiDocumentFilter;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.descriptor.FilterStreamDescriptor;
import org.xwiki.filter.instance.input.AbstractInstanceInputEventGenerator;
import org.xwiki.filter.instance.input.EntityEventGenerator;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.properties.BeanManager;

@Component
@Named(value="documents")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DocumentInstanceInputEventGenerator
extends AbstractInstanceInputEventGenerator<XWikiDocumentFilter> {
    @Inject
    protected BeanManager beanManager;
    @Inject
    private EntityEventGenerator<XWikiDocument> documentLocaleParser;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public FilterStreamDescriptor getDescriptor() {
        return this.documentLocaleParser.getDescriptor();
    }

    public void setWikiDocumentParameters(String name, FilterEventParameters documentParameters) throws FilterException {
        XWikiDocument defaultDocument;
        DocumentReference reference = new DocumentReference(name, new SpaceReference(this.currentReference));
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            defaultDocument = xcontext.getWiki().getDocument(reference, xcontext);
        }
        catch (XWikiException e) {
            throw new FilterException("Failed to get document [" + String.valueOf(reference) + "]", (Throwable)e);
        }
        documentParameters.put((Object)"locale", (Object)defaultDocument.getDefaultLocale());
    }

    public void beginWikiDocument(String name, FilterEventParameters parameters) throws FilterException {
        List<Locale> locales;
        XWikiDocument defaultDocument;
        super.beginWikiDocument(name, parameters);
        DocumentReference reference = new DocumentReference(this.currentReference);
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            defaultDocument = xcontext.getWiki().getDocument(reference, xcontext);
        }
        catch (XWikiException e) {
            throw new FilterException("Failed to get document [" + String.valueOf(reference) + "]", (Throwable)e);
        }
        this.documentLocaleParser.write((Object)defaultDocument, this.filter, this.properties);
        try {
            locales = defaultDocument.getTranslationLocales(xcontext);
        }
        catch (XWikiException e) {
            throw new FilterException("Failed to get translations of document [" + String.valueOf(reference) + "]", (Throwable)e);
        }
        for (Locale locale : locales) {
            try {
                XWikiDocument translationDocument = defaultDocument.getTranslatedDocument(locale, xcontext);
                this.documentLocaleParser.write((Object)translationDocument, this.filter, this.properties);
            }
            catch (XWikiException e) {
                throw new FilterException("Failed to get document [" + String.valueOf(reference) + "] for locale [" + String.valueOf(locale) + "]", (Throwable)e);
            }
        }
    }
}

