/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.filter.input;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.internal.filter.BaseObjectFilter;
import com.xpn.xwiki.internal.filter.input.BaseClassEventGenerator;
import com.xpn.xwiki.internal.filter.input.BasePropertyEventGenerator;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.instance.input.DocumentInstanceInputProperties;
import org.xwiki.filter.instance.input.EntityEventGenerator;
import org.xwiki.filter.instance.internal.input.AbstractBeanEntityEventGenerator;

@Component
@Singleton
public class BaseObjectEventGenerator
extends AbstractBeanEntityEventGenerator<BaseObject, BaseObjectFilter, DocumentInstanceInputProperties> {
    public static final ParameterizedType ROLE = new DefaultParameterizedType(null, EntityEventGenerator.class, new Type[]{BaseObject.class, DocumentInstanceInputProperties.class});
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private EntityEventGenerator<BaseClass> classEventGenerator;
    @Inject
    private EntityEventGenerator<BaseProperty> propertyEventGenerator;

    public void write(BaseObject xobject, Object filter, BaseObjectFilter objectFilter, DocumentInstanceInputProperties properties) throws FilterException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        FilterEventParameters objectParameters = new FilterEventParameters();
        objectParameters.put((Object)"name", (Object)xobject.getName());
        objectParameters.put((Object)"class_reference", (Object)xobject.getClassName());
        objectParameters.put((Object)"guid", (Object)xobject.getGuid());
        objectParameters.put((Object)"number", (Object)xobject.getNumber());
        objectFilter.beginWikiObject(xobject.getReference() != null ? ((BaseObjectReference)((Object)xobject.getReference())).getName() : null, objectParameters);
        BaseClass xclass = xobject.getXClass(xcontext);
        ((BaseClassEventGenerator)this.classEventGenerator).write(xclass, filter, objectFilter, properties);
        Iterator it = xobject.getSortedIterator();
        while (it.hasNext()) {
            BaseProperty xproperty = (BaseProperty)it.next();
            String pname = xproperty.getName();
            if (!StringUtils.isNotBlank((CharSequence)pname)) continue;
            PropertyInterface propertyInterface = xclass.get(pname);
            if (propertyInterface instanceof PropertyClass) {
                PropertyClass propertyClass = (PropertyClass)propertyInterface;
                if (properties.getExcludedPropertyTypes().contains(propertyClass.getClassType())) continue;
            }
            ((BasePropertyEventGenerator)this.propertyEventGenerator).write(xproperty, filter, (Map)properties);
        }
        objectFilter.endWikiObject(((BaseObjectReference)((Object)xobject.getReference())).getName(), objectParameters);
    }
}

