/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.filter;

import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.filter.output.EntityOutputFilterStream;
import com.xpn.xwiki.internal.filter.output.XWikiDocumentOutputFilterStream;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.input.BeanInputFilterStream;
import org.xwiki.filter.input.BeanInputFilterStreamFactory;
import org.xwiki.filter.input.InputFilterStreamFactory;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.instance.input.BeanEntityEventGenerator;
import org.xwiki.filter.instance.input.DocumentInstanceInputProperties;
import org.xwiki.filter.instance.input.EntityEventGenerator;
import org.xwiki.filter.instance.output.DocumentInstanceOutputProperties;
import org.xwiki.filter.output.BeanOutputFilterStream;
import org.xwiki.filter.output.BeanOutputFilterStreamFactory;
import org.xwiki.filter.output.OutputFilterStreamFactory;
import org.xwiki.filter.output.OutputTarget;
import org.xwiki.filter.output.StringWriterOutputTarget;
import org.xwiki.filter.xar.input.XARInputProperties;
import org.xwiki.filter.xar.internal.XARFilter;
import org.xwiki.filter.xar.output.XAROutputProperties;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;

@Component(roles={XWikiDocumentFilterUtils.class})
@Singleton
public class XWikiDocumentFilterUtils {
    @Inject
    @Named(value="xwiki+xar/1.6")
    private InputFilterStreamFactory xarInputFilterStreamFactory;
    @Inject
    @Named(value="xwiki+xar/1.6")
    private OutputFilterStreamFactory xarOutputFilterStreamFactory;
    @Inject
    private ComponentManager componentManager;

    private <T> Class<T> getClass(Object entity) {
        Class entityClass = entity instanceof Class ? (Class<XWikiDocument>)entity : (entity instanceof XWikiDocument ? XWikiDocument.class : (entity instanceof XWikiAttachment ? XWikiAttachment.class : (entity instanceof BaseClass ? BaseClass.class : (entity instanceof BaseObject ? BaseObject.class : (entity instanceof BaseProperty ? BaseProperty.class : (entity instanceof PropertyClass ? PropertyClass.class : entity.getClass()))))));
        return entityClass;
    }

    private XARInputProperties.SourceType getSourceType(Class<?> entityClass) throws FilterException {
        XARInputProperties.SourceType sourceType;
        if (entityClass == XWikiDocument.class) {
            sourceType = XARInputProperties.SourceType.DOCUMENT;
        } else if (entityClass == XWikiAttachment.class) {
            sourceType = XARInputProperties.SourceType.ATTACHMENT;
        } else if (entityClass == BaseClass.class) {
            sourceType = XARInputProperties.SourceType.CLASS;
        } else if (entityClass == BaseObject.class) {
            sourceType = XARInputProperties.SourceType.OBJECT;
        } else if (entityClass == BaseProperty.class) {
            sourceType = XARInputProperties.SourceType.OBJECTPROPERTY;
        } else if (entityClass == PropertyClass.class) {
            sourceType = XARInputProperties.SourceType.CLASSPROPERTY;
        } else {
            throw new FilterException("Unsupported type [" + String.valueOf(entityClass) + "]");
        }
        return sourceType;
    }

    public <T> T importEntity(Object entity, InputSource source) throws FilterException, IOException, ComponentLookupException {
        DocumentInstanceOutputProperties documentProperties = new DocumentInstanceOutputProperties();
        XARInputProperties xarProperties = new XARInputProperties();
        return (T)this.importEntity(this.getClass(entity), entity instanceof Class ? null : entity, source, xarProperties, documentProperties);
    }

    public <T> T importEntity(Class<T> entityClass, T entity, InputSource source, XARInputProperties xarProperties, DocumentInstanceOutputProperties documentProperties) throws FilterException, IOException, ComponentLookupException {
        EntityOutputFilterStream filterStream = (EntityOutputFilterStream)this.componentManager.getInstance((Type)new DefaultParameterizedType(null, EntityOutputFilterStream.class, new Type[]{entityClass}));
        filterStream.setProperties(documentProperties);
        filterStream.setEntity(entity);
        if (filterStream instanceof XWikiDocumentOutputFilterStream) {
            ((XWikiDocumentOutputFilterStream)filterStream).disableRenderingEvents();
        }
        xarProperties.setSourceType(this.getSourceType(entityClass));
        xarProperties.setSource(source);
        BeanInputFilterStream xarReader = ((BeanInputFilterStreamFactory)this.xarInputFilterStreamFactory).createInputFilterStream((Object)xarProperties);
        xarReader.read(filterStream.getFilter());
        xarReader.close();
        return (T)filterStream.getEntity();
    }

    public XWikiDocument importDocument(InputSource source, XARInputProperties xarProperties, DocumentInstanceOutputProperties documentProperties) throws FilterException, IOException, ComponentLookupException {
        return this.importEntity(XWikiDocument.class, null, source, xarProperties, documentProperties);
    }

    public String exportEntity(Object entity) throws ComponentLookupException, FilterException, IOException {
        return this.exportEntity(entity, new XAROutputProperties());
    }

    public String exportEntity(Object entity, XAROutputProperties xarProperties) throws ComponentLookupException, FilterException, IOException {
        return this.exportEntity(entity, xarProperties, new DocumentInstanceInputProperties());
    }

    public void exportEntity(Object entity, OutputTarget target) throws ComponentLookupException, FilterException, IOException {
        this.exportEntity(entity, target, new DocumentInstanceInputProperties());
    }

    public void exportEntity(Object entity, OutputTarget target, DocumentInstanceInputProperties documentProperties) throws ComponentLookupException, FilterException, IOException {
        this.exportEntity(entity, target, new XAROutputProperties(), documentProperties);
    }

    public String exportEntity(Object entity, XAROutputProperties xarProperties, DocumentInstanceInputProperties documentProperties) throws ComponentLookupException, FilterException, IOException {
        StringWriterOutputTarget target = new StringWriterOutputTarget();
        this.exportEntity(entity, (OutputTarget)target, xarProperties, documentProperties);
        return target.toString();
    }

    public void exportEntity(Object entity, OutputTarget target, XAROutputProperties xarProperties, DocumentInstanceInputProperties documentProperties) throws ComponentLookupException, FilterException, IOException {
        documentProperties.setVerbose(false);
        xarProperties.setForceDocument(true);
        if (target != null) {
            xarProperties.setTarget(target);
        }
        xarProperties.setVerbose(false);
        BeanOutputFilterStream xarFilter = ((BeanOutputFilterStreamFactory)this.xarOutputFilterStreamFactory).createOutputFilterStream((Object)xarProperties);
        XARFilter filter = (XARFilter)xarFilter.getFilter();
        BeanEntityEventGenerator generator = (BeanEntityEventGenerator)this.componentManager.getInstance((Type)new DefaultParameterizedType(null, EntityEventGenerator.class, new Type[]{this.getClass(entity)}));
        FilterEventParameters documentParameters = null;
        DocumentReference documentReference = null;
        if (entity instanceof XWikiDocument) {
            documentReference = ((XWikiDocument)entity).getDocumentReference();
            for (SpaceReference spaceReference : documentReference.getSpaceReferences()) {
                filter.beginWikiSpace(spaceReference.getName(), FilterEventParameters.EMPTY);
            }
            documentParameters = new FilterEventParameters();
            documentParameters.put((Object)"locale", (Object)((XWikiDocument)entity).getDefaultLocale());
            filter.beginWikiDocument(documentReference.getName(), documentParameters);
        }
        generator.write(entity, (Object)xarFilter, (Object)documentProperties);
        if (documentParameters != null) {
            filter.endWikiDocument(documentReference.getName(), documentParameters);
            documentReference = ((XWikiDocument)entity).getDocumentReference();
            EntityReference reference = documentReference.getParent();
            while (reference instanceof SpaceReference) {
                filter.beginWikiSpace(reference.getName(), FilterEventParameters.EMPTY);
                reference = reference.getParent();
            }
        }
        xarFilter.close();
    }
}

