/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.fileupload;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.internal.fileupload.PartFileItem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.attachment.AttachmentAccessWrapper;
import org.xwiki.attachment.validation.AttachmentValidationException;
import org.xwiki.attachment.validation.AttachmentValidator;
import org.xwiki.internal.attachment.PartAttachmentAccessWrapper;

public final class FileUploadUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUploadUtils.class);

    private FileUploadUtils() {
    }

    public static Collection<FileItem> getFileItems(long uploadMaxSize, int uploadSizeThreshold, String tempdir, HttpServletRequest request, AttachmentValidator attachmentValidator) throws XWikiException, AttachmentValidationException {
        Collection parts;
        try {
            parts = request.getParts();
        }
        catch (Exception e) {
            throw new XWikiException(11, 11008, "Exception while getting uploaded files", e);
        }
        if (!parts.isEmpty()) {
            ArrayList<FileItem> items = new ArrayList<FileItem>(parts.size());
            for (Part part : parts) {
                if (Strings.CS.startsWith((CharSequence)part.getName(), (CharSequence)"filepath")) {
                    attachmentValidator.validateAttachment((AttachmentAccessWrapper)new PartAttachmentAccessWrapper(part));
                }
                items.add(new PartFileItem(part));
            }
            return items;
        }
        DiskFileItemFactory factory = new DiskFileItemFactory(uploadSizeThreshold, new File(tempdir)){

            public FileItem createItem(String fieldName, String contentType, boolean isFormField, String fileName) {
                try {
                    DiskFileItem item = (DiskFileItem)super.createItem(fieldName, contentType, isFormField, fileName);
                    item.getOutputStream();
                    return item;
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Unable to create a temporary file for saving the attachment. Do you have write access on [%s]?", this.getRepository()), e);
                }
            }
        };
        ServletFileUpload fileupload = new ServletFileUpload((FileItemFactory)factory);
        ServletRequestContext reqContext = new ServletRequestContext(request);
        fileupload.setSizeMax(uploadMaxSize);
        try {
            List list = fileupload.parseRequest((RequestContext)reqContext);
            if (list.size() > 0) {
                LOGGER.info("Loaded " + list.size() + " uploaded files");
            }
            return list;
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            throw new XWikiException(11, 11013, "Exception uploaded file");
        }
        catch (Exception e) {
            throw new XWikiException(11, 11008, "Exception while parsing uploaded file", e);
        }
    }
}

