/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.file;

import com.xpn.xwiki.internal.file.TemporaryFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.Environment;

@Component(roles={TemporaryDeferredFileRepository.class})
@Singleton
public class TemporaryDeferredFileRepository {
    private static final int THRESHOLD = 10000;
    private final String uid = UUID.randomUUID().toString().replace('-', '_');
    private final AtomicLong counter = new AtomicLong(0L);
    @Inject
    private Environment environment;

    public File getRepository(String repositoryPath) throws IOException {
        File repository = new File(this.environment.getTemporaryDirectory(), repositoryPath);
        if (!repository.mkdirs() && !repository.exists()) {
            throw new IOException("Failed to create directory [" + String.valueOf(repository) + "]");
        }
        return repository;
    }

    public File createTemporaryFile(String repositoryPath) throws IOException {
        StringBuilder filename = new StringBuilder();
        filename.append(this.uid);
        filename.append('-');
        filename.append(this.counter.getAndIncrement());
        return new TemporaryFile(this.getRepository(repositoryPath), filename.toString());
    }

    public TemporaryDeferredFile createTemporaryDeferredFile(String repositoryPath) {
        return new TemporaryDeferredFile(repositoryPath);
    }

    public TemporaryDeferredStringFile createTemporaryDeferredStringFile(String repositoryPath, Charset charset) {
        return new TemporaryDeferredStringFile(repositoryPath, charset);
    }

    public class TemporaryDeferredFile {
        private final String repositoryPath;
        private DeferredFileOutputStream currentOutputStream;

        TemporaryDeferredFile(String repositoryPath) {
            this.repositoryPath = repositoryPath;
        }

        public InputStream getInputStream() throws IOException {
            if (this.currentOutputStream != null) {
                if (this.currentOutputStream.isInMemory()) {
                    return new ByteArrayInputStream(this.currentOutputStream.getData());
                }
                return new FileInputStream(this.currentOutputStream.getFile());
            }
            return new ByteArrayInputStream(ArrayUtils.EMPTY_BYTE_ARRAY);
        }

        public OutputStream getOutputStream() throws IOException {
            File file = TemporaryDeferredFileRepository.this.createTemporaryFile(this.repositoryPath);
            this.currentOutputStream = new DeferredFileOutputStream(10000, file);
            return this.currentOutputStream;
        }

        public long length() {
            if (this.currentOutputStream != null) {
                if (this.currentOutputStream.isInMemory()) {
                    return this.currentOutputStream.getData().length;
                }
                return this.currentOutputStream.getFile().length();
            }
            return 0L;
        }

        public byte[] getBytes() throws IOException {
            if (this.currentOutputStream != null) {
                if (this.currentOutputStream.isInMemory()) {
                    return this.currentOutputStream.getData();
                }
                return FileUtils.readFileToByteArray((File)this.currentOutputStream.getFile());
            }
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
    }

    public class TemporaryDeferredStringFile
    extends TemporaryDeferredFile {
        private final Charset charset;

        TemporaryDeferredStringFile(String repositoryPath, Charset charset) {
            super(repositoryPath);
            this.charset = charset;
        }

        public Reader getReader() throws IOException {
            return new InputStreamReader(this.getInputStream(), this.charset);
        }

        public Writer getWriter() throws IOException {
            OutputStream stream = this.getOutputStream();
            return new OutputStreamWriter(stream, this.charset);
        }

        public String getString() throws IOException {
            try (Reader reader = this.getReader();){
                StringWriter writer = new StringWriter();
                IOUtils.copyLarge((Reader)reader, (Writer)writer);
                String string = writer.toString();
                return string;
            }
        }

        public void setString(String str) throws IOException {
            try (Writer writer = this.getWriter();){
                IOUtils.write((String)str, (Writer)writer);
            }
        }
    }
}

