/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.export;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.web.XWikiRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.query.internal.DefaultQueryParameter;
import org.xwiki.tree.EntityTreeFilter;

@Component(roles={DocumentSelectionResolver.class})
@Singleton
public class DocumentSelectionResolver {
    private static final String PAGE_SEPARATOR = "&";
    private static final String ANY_CHARS = "%";
    private static final String REQUEST_PARAMETER_PAGES = "pages";
    private static final String REQUEST_PARAMETER_FILTER = "filter";
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="document")
    private QueryFilter documentQueryFilter;
    @Inject
    @Named(value="hidden/document")
    private Provider<QueryFilter> hiddenDocumentQueryFilterProvider;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentDocumentReferenceResolver;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localEntityReferenceSerializer;

    public boolean isSelectionSpecified() {
        Map parameters = ((XWikiContext)this.xcontextProvider.get()).getRequest().getParameterMap();
        return parameters.containsKey(REQUEST_PARAMETER_PAGES) || !parameters.getOrDefault(REQUEST_PARAMETER_FILTER, new String[]{""})[0].isEmpty();
    }

    public Collection<DocumentReference> getSelectedDocuments() {
        return this.getSelectedDocuments(false);
    }

    public Collection<DocumentReference> getSelectedDocuments(boolean filterHiddenDocuments) {
        Map<DocumentReference, Collection<DocumentReference>> selection = this.getSelectionFromRequest();
        EntityTreeFilter filter = this.getFilterFromRequest();
        if (filter != null) {
            this.extendSelection(selection, filter);
        }
        LinkedHashSet<DocumentReference> selectedDocuments = new LinkedHashSet<DocumentReference>();
        selectedDocuments.addAll(selection.keySet().stream().filter(this::isExactMatch).collect(Collectors.toSet()));
        selection.keySet().removeAll(selectedDocuments);
        selectedDocuments.addAll(this.getSelectedDocuments(selection, filterHiddenDocuments));
        return selectedDocuments;
    }

    private boolean isExactMatch(DocumentReference documentReference) {
        return documentReference != null && !((String)this.localEntityReferenceSerializer.serialize((EntityReference)documentReference, new Object[0])).contains(ANY_CHARS);
    }

    private Collection<DocumentReference> getSelectedDocuments(Map<DocumentReference, Collection<DocumentReference>> selection, boolean filterHiddenDocuments) {
        Optional hiddenDocumentQueryFilter = filterHiddenDocuments ? Optional.of((QueryFilter)this.hiddenDocumentQueryFilterProvider.get()) : Optional.empty();
        Map<String, Object[]> queriesByWiki = this.buildQueriesByWiki(selection);
        return queriesByWiki.entrySet().stream().map(entry -> this.executeQuery((Map.Entry<String, Object[]>)entry, hiddenDocumentQueryFilter)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Map<String, Object[]> buildQueriesByWiki(Map<DocumentReference, Collection<DocumentReference>> selection) {
        LinkedHashMap<String, Object[]> queriesByWiki = new LinkedHashMap<String, Object[]>();
        for (Map.Entry<DocumentReference, Collection<DocumentReference>> entry : selection.entrySet()) {
            String wikiName = entry.getKey() == null ? ((XWikiContext)this.xcontextProvider.get()).getWikiId() : entry.getKey().getWikiReference().getName();
            Object[] query = (Object[])queriesByWiki.get(wikiName);
            if (query == null) {
                query = new Object[]{new StringBuilder(), new ArrayList()};
                queriesByWiki.put(wikiName, query);
            }
            StringBuilder statement = (StringBuilder)query[0];
            List parameters = (List)query[1];
            List<String> constraints = this.extendQuery(entry.getKey(), entry.getValue(), parameters);
            if (constraints.isEmpty()) continue;
            statement.append(statement.length() == 0 ? "where (" : " or (");
            statement.append(StringUtils.join(constraints, (String)" and "));
            statement.append(')');
        }
        return queriesByWiki;
    }

    private List<String> extendQuery(DocumentReference includedDocumentReference, Collection<DocumentReference> excludedDocumentReferences, List<Object> parameters) {
        LinkedList<String> constraints = new LinkedList<String>();
        if (includedDocumentReference != null) {
            String includedPage = (String)this.localEntityReferenceSerializer.serialize((EntityReference)includedDocumentReference, new Object[0]);
            parameters.add(new DefaultQueryParameter(null).like(includedPage));
            constraints.add("doc.fullName like ?" + parameters.size());
        }
        Set exactMatch = excludedDocumentReferences.stream().filter(this::isExactMatch).collect(Collectors.toSet());
        LinkedHashSet<DocumentReference> partialMatch = new LinkedHashSet<DocumentReference>(excludedDocumentReferences);
        partialMatch.removeAll(exactMatch);
        if (!exactMatch.isEmpty()) {
            parameters.add(exactMatch.stream().map(x$0 -> (String)this.localEntityReferenceSerializer.serialize(x$0, new Object[0])).collect(Collectors.toSet()));
            constraints.add("doc.fullName not in (?" + parameters.size() + ")");
        }
        for (DocumentReference excludedDocumentReference : partialMatch) {
            parameters.add(new DefaultQueryParameter(null).like((String)this.localEntityReferenceSerializer.serialize((EntityReference)excludedDocumentReference, new Object[0])));
            constraints.add("doc.fullName not like ?" + parameters.size());
        }
        return constraints;
    }

    private Set<DocumentReference> executeQuery(Map.Entry<String, Object[]> entry, Optional<QueryFilter> hiddenDocumentQueryFilter) {
        String wikiName = entry.getKey();
        String statement = entry.getValue()[0].toString();
        List parameters = (List)entry.getValue()[1];
        try {
            Query query = this.queryManager.createQuery(statement, "hql");
            query.setWiki(wikiName).bindValues(parameters).addFilter(this.documentQueryFilter);
            if (hiddenDocumentQueryFilter.isPresent()) {
                query.addFilter(hiddenDocumentQueryFilter.get());
            }
            return new LinkedHashSet<DocumentReference>(query.execute());
        }
        catch (QueryException e) {
            this.logger.error("Failed to retrieve the selected documents from wiki [{}].", (Object)wikiName, (Object)e);
            return Collections.emptySet();
        }
    }

    private Map<DocumentReference, Collection<DocumentReference>> getSelectionFromRequest() {
        XWikiRequest request = ((XWikiContext)this.xcontextProvider.get()).getRequest();
        String[] pages = request.getParameterValues(REQUEST_PARAMETER_PAGES);
        String[] excludes = request.getParameterValues("excludes");
        LinkedHashMap<DocumentReference, Collection<DocumentReference>> selection = new LinkedHashMap<DocumentReference, Collection<DocumentReference>>();
        if (pages != null) {
            for (int i = 0; i < pages.length; ++i) {
                Collection<Object> excludedPages;
                DocumentReference includedPage = this.currentDocumentReferenceResolver.resolve((Object)pages[i], new Object[0]);
                if (excludes != null && i < excludes.length) {
                    excludedPages = this.decodeExcludes(excludes[i]);
                    excludedPages.removeIf(excludedPage -> !includedPage.getWikiReference().equals((Object)excludedPage.getWikiReference()));
                } else {
                    excludedPages = new LinkedHashSet();
                }
                selection.put(includedPage, excludedPages);
            }
        }
        return selection;
    }

    private Collection<DocumentReference> decodeExcludes(String encodedString) {
        String encoding = ((XWikiContext)this.xcontextProvider.get()).getRequest().getCharacterEncoding();
        LinkedHashSet<DocumentReference> excludedPages = new LinkedHashSet<DocumentReference>();
        for (String page : encodedString.split(PAGE_SEPARATOR)) {
            try {
                String decoded = URLDecoder.decode(page, encoding);
                if (decoded.isEmpty()) continue;
                excludedPages.add(this.currentDocumentReferenceResolver.resolve((Object)decoded, new Object[0]));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.warn("Failed to decode excluded page [{}] using [{}]. Root cause is [{}].", new Object[]{page, encoding, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
        }
        return excludedPages;
    }

    private EntityTreeFilter getFilterFromRequest() {
        String filterHint = ((XWikiContext)this.xcontextProvider.get()).getRequest().getParameter(REQUEST_PARAMETER_FILTER);
        if (!StringUtils.isEmpty((CharSequence)filterHint)) {
            try {
                return (EntityTreeFilter)((ComponentManager)this.contextComponentManagerProvider.get()).getInstance(EntityTreeFilter.class, filterHint);
            }
            catch (ComponentLookupException e) {
                this.logger.warn("Failed to lookup EntityTreeFilter with hint [{}]. Root cause is [{}].", (Object)filterHint, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return null;
    }

    private void extendSelection(Map<DocumentReference, Collection<DocumentReference>> selection, EntityTreeFilter filter) {
        if (selection.isEmpty()) {
            WikiReference currentWikiReference = ((XWikiContext)this.xcontextProvider.get()).getWikiReference();
            if (currentWikiReference != null) {
                selection.put(null, this.getDocumentExclusions(filter.getDescendantExclusions((EntityReference)currentWikiReference)));
            }
        } else {
            for (Map.Entry<DocumentReference, Collection<DocumentReference>> entry : selection.entrySet()) {
                this.extendExclusions(entry.getKey(), entry.getValue(), filter);
            }
        }
    }

    private void extendExclusions(DocumentReference includedDocumentReference, Collection<DocumentReference> excludedDocumentReferences, EntityTreeFilter filter) {
        if (ANY_CHARS.equals(includedDocumentReference.getName())) {
            excludedDocumentReferences.addAll(this.getDocumentExclusions(filter.getDescendantExclusions((EntityReference)includedDocumentReference.getLastSpaceReference())));
        }
    }

    private Set<DocumentReference> getDocumentExclusions(Set<EntityReference> exclusions) {
        LinkedHashSet<DocumentReference> excludedDocumentReferences = new LinkedHashSet<DocumentReference>();
        exclusions.forEach(excludedEntityReference -> {
            if (excludedEntityReference instanceof DocumentReference) {
                excludedDocumentReferences.add((DocumentReference)excludedEntityReference);
            }
        });
        return excludedDocumentReferences;
    }
}

