/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.doc.rcs;

import java.util.BitSet;
import java.util.Date;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.suigeneris.jrcs.rcs.InvalidTrunkVersionNumberException;
import org.suigeneris.jrcs.rcs.Version;
import org.suigeneris.jrcs.rcs.impl.Node;
import org.suigeneris.jrcs.rcs.impl.TrunkNode;

public class XWikiTrunkNode
extends TrunkNode {
    private static String sauthorIfEmpty = "_";
    private static BitSet safeAuthorChars = new BitSet();

    public XWikiTrunkNode(Node other) {
        this(other.version, null);
        this.date = other.getDate();
        this.author = other.getAuthor();
        this.state = other.getState();
        this.log = other.getLog();
        this.locker = other.getLocker();
    }

    public XWikiTrunkNode(Version vernum, TrunkNode next) throws InvalidTrunkVersionNumberException {
        super(vernum, next);
    }

    public void setAuthor(String user) {
        if (user == null || "".equals(user)) {
            super.setAuthor(sauthorIfEmpty);
        } else {
            byte[] enc = URLCodec.encodeUrl((BitSet)safeAuthorChars, (byte[])user.getBytes());
            String senc = new String(enc).replace('%', '_');
            super.setAuthor(senc);
        }
    }

    public String getExtendedAuthor() {
        String result;
        block3: {
            result = super.getAuthor();
            if (sauthorIfEmpty.equals(result)) {
                return "";
            }
            result = result.replace('_', '%');
            try {
                byte[] dec = URLCodec.decodeUrl((byte[])result.getBytes());
                result = new String(dec);
            }
            catch (DecoderException e) {
                result = super.getAuthor();
                if (result.matches("^(\\w|\\d|\\.)++$")) break block3;
                result = "";
            }
        }
        return result;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    static {
        safeAuthorChars.set(45);
        int c = 65;
        int c1 = 97;
        while (c <= 90) {
            safeAuthorChars.set(c);
            safeAuthorChars.set(c1);
            c = (char)(c + 1);
            c1 = (char)(c1 + 1);
        }
    }
}

