/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.doc;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiAttachmentArchive;
import com.xpn.xwiki.internal.doc.XWikiAttachmentRCSArchive;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.suigeneris.jrcs.rcs.Archive;
import org.suigeneris.jrcs.rcs.Version;
import org.suigeneris.jrcs.rcs.impl.Node;

public class ListAttachmentArchive
extends XWikiAttachmentArchive {
    private static final String GENERIC_EXCEPTION_MESSAGE = "Exception while manipulating the archive for attachment {0}";
    private static final String NOT_IMPLEMENTED_MESSAGE = "This function is not available in this implementation.";
    private final List<XWikiAttachment> revisions = new ArrayList<XWikiAttachment>();

    public ListAttachmentArchive(XWikiAttachment attachment) {
        this.setAttachment(attachment);
    }

    public ListAttachmentArchive(List<XWikiAttachment> revisions) {
        if (revisions.isEmpty()) {
            return;
        }
        this.revisions.addAll(revisions);
        Collections.sort(this.revisions, XWikiAttachmentVersionComparator.INSTANCE);
        long id = revisions.get(0).getId();
        String firstAttachName = revisions.get(0).getFilename();
        for (XWikiAttachment attach : revisions) {
            if (attach.getId() != id) {
                throw new IllegalArgumentException("Attachment " + attach.getFilename() + " has a different ID than the first attachment ( " + firstAttachName + " ) so they cannot all be revisions of the same attachment.");
            }
            attach.setAttachment_archive(this);
        }
        this.setAttachment(this.revisions.get(revisions.size() - 1));
    }

    public void add(XWikiAttachment revision) {
        this.revisions.add(revision);
    }

    @Override
    public Object clone() {
        ListAttachmentArchive out = new ListAttachmentArchive(ListAttachmentArchive.cloneAttachment(this.getAttachment()));
        out.getAttachment().setAttachment_archive(out);
        for (XWikiAttachment revision : this.revisions) {
            XWikiAttachment revClone = ListAttachmentArchive.cloneAttachment(revision);
            revClone.setAttachment_archive(out);
            out.revisions.add(revClone);
        }
        return out;
    }

    private static XWikiAttachment cloneAttachment(XWikiAttachment original) {
        XWikiAttachmentArchive arch = original.getAttachment_archive();
        try {
            original.setAttachment_archive(null);
            XWikiAttachment xWikiAttachment = original.clone();
            return xWikiAttachment;
        }
        finally {
            original.setAttachment_archive(arch);
        }
    }

    @Override
    @Deprecated
    public Archive getRCSArchive() {
        throw new RuntimeException(NOT_IMPLEMENTED_MESSAGE);
    }

    @Override
    @Deprecated
    public void setRCSArchive(Archive rcsArchive) {
        throw new RuntimeException(NOT_IMPLEMENTED_MESSAGE);
    }

    private Archive toRCS(XWikiContext context) throws Exception {
        Version[] versions = this.getVersions();
        XWikiAttachmentRCSArchive rcsArch = null;
        int revisionNumber = this.revisions.size();
        for (int i = revisionNumber - 1; i >= 0; --i) {
            XWikiAttachment rev = this.revisions.get(i);
            if (rcsArch == null) {
                rcsArch = new XWikiAttachmentRCSArchive(rev, context);
                continue;
            }
            rcsArch.addRevision(rev, context);
        }
        return rcsArch;
    }

    private void fromRCS(Archive rcsArchive) throws Exception {
        if (rcsArchive == null) {
            return;
        }
        Node[] nodes = rcsArchive.changeLog();
        for (int i = nodes.length - 1; i > -1; --i) {
            Object[] lines = rcsArchive.getRevision(nodes[i].getVersion());
            StringBuilder content = new StringBuilder();
            for (int j = 0; j < lines.length; ++j) {
                String line = lines[j].toString();
                content.append(line);
                if (j == lines.length - 1) continue;
                content.append("\n");
            }
            XWikiAttachment rev = new XWikiAttachment();
            rev.fromXML(content.toString());
            rev.setDoc(this.getAttachment().getDoc());
            rev.setAttachment_archive(this);
            rev.setVersion(nodes[i].getVersion().toString());
            this.revisions.add(rev);
        }
    }

    @Override
    public byte[] getArchive() {
        return new byte[0];
    }

    @Override
    public byte[] getArchive(XWikiContext context) throws XWikiException {
        try {
            return this.toRCS(context).toByteArray();
        }
        catch (Exception e) {
            if (e instanceof XWikiException) {
                throw (XWikiException)e;
            }
            Object[] args = new Object[]{this.getAttachment().getFilename()};
            throw new XWikiException(3, 3004, GENERIC_EXCEPTION_MESSAGE, e, args);
        }
    }

    @Override
    public void setArchive(byte[] data) throws XWikiException {
        this.revisions.clear();
        if (data != null && data.length == 0) {
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(data);
                Archive rcsArchive = new Archive(this.getAttachment().getFilename(), (InputStream)is);
                super.setRCSArchive(rcsArchive);
            }
            catch (Exception e) {
                if (e instanceof XWikiException) {
                    throw (XWikiException)e;
                }
                Object[] args = new Object[]{this.getAttachment().getFilename()};
                throw new XWikiException(3, 3004, GENERIC_EXCEPTION_MESSAGE, e, args);
            }
        }
    }

    @Override
    public String getArchiveAsString(XWikiContext context) throws XWikiException {
        if (super.getRCSArchive() == null) {
            try {
                super.setRCSArchive(this.toRCS(context));
            }
            catch (Exception e) {
                throw new XWikiException(3, 3004, GENERIC_EXCEPTION_MESSAGE, e);
            }
        }
        return super.getArchiveAsString();
    }

    @Override
    public void addCurrentAttachment(XWikiContext context) {
        XWikiAttachment currentAttachment = this.getAttachment();
        XWikiAttachment clone = ListAttachmentArchive.cloneAttachment(currentAttachment);
        clone.setAttachment_archive(this);
        this.revisions.add(clone);
    }

    @Override
    public Version[] getVersions() {
        Version[] versions = new Version[this.revisions.size()];
        int i = this.revisions.size();
        for (XWikiAttachment attach : this.revisions) {
            versions[--i] = attach.getRCSVersion();
        }
        return versions;
    }

    @Override
    public XWikiAttachment getRevision(XWikiAttachment attachment, String rev, XWikiContext context) {
        if (rev == null) {
            return null;
        }
        for (XWikiAttachment attach : this.revisions) {
            if (!rev.equals(attach.getVersion())) continue;
            XWikiAttachment out = ListAttachmentArchive.cloneAttachment(attach);
            out.setAttachment_archive(this);
            out.setDoc(attachment.getDoc(), false);
            return out;
        }
        return null;
    }

    public InputStream getRevisionContentStream(String rev, XWikiContext xcontext) throws XWikiException {
        if (rev == null) {
            return null;
        }
        for (XWikiAttachment attach : this.revisions) {
            if (!rev.equals(attach.getVersion())) continue;
            return attach.getContentInputStream(xcontext);
        }
        return null;
    }

    private static final class XWikiAttachmentVersionComparator
    implements Comparator<XWikiAttachment> {
        public static final XWikiAttachmentVersionComparator INSTANCE = new XWikiAttachmentVersionComparator();

        private XWikiAttachmentVersionComparator() {
        }

        @Override
        public int compare(XWikiAttachment a, XWikiAttachment b) {
            return a.getRCSVersion().compareTo((Object)b.getRCSVersion());
        }
    }
}

