/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.doc;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DocumentRevisionProvider;
import com.xpn.xwiki.doc.XWikiDeletedDocument;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.PageReference;
import org.xwiki.model.reference.PageReferenceResolver;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserReference;

@Component
@Named(value="deleted")
@Singleton
public class DeletedDocumentRevisionProvider
implements DocumentRevisionProvider {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private PageReferenceResolver<EntityReference> pageReferenceResolver;

    @Override
    public XWikiDocument getRevision(DocumentReference reference, String revision) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDeletedDocument deletedDocument = xcontext.getWiki().getDeletedDocument(Long.valueOf(revision), xcontext);
        if (deletedDocument != null && this.areReferencesCompatible(reference, deletedDocument.getDocumentReference())) {
            return deletedDocument.restoreDocument(xcontext);
        }
        return null;
    }

    private boolean areReferencesCompatible(DocumentReference requestedDocRef, DocumentReference deletedDocRef) {
        boolean result;
        if (requestedDocRef == null) {
            result = true;
        } else {
            PageReference requestedPageRef = this.pageReferenceResolver.resolve((Object)requestedDocRef, new Object[0]);
            PageReference deletedPageRef = this.pageReferenceResolver.resolve((Object)deletedDocRef, new Object[0]);
            result = requestedPageRef.equals((Object)deletedPageRef);
        }
        return result;
    }

    @Override
    public XWikiDocument getRevision(XWikiDocument document, String revision) throws XWikiException {
        return this.getRevision(document != null ? document.getDocumentReferenceWithLocale() : null, revision);
    }

    @Override
    public void checkAccess(Right right, UserReference userReference, DocumentReference documentReference, String revision) throws AuthorizationException, XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDeletedDocument deletedDocument = xcontext.getWiki().getDeletedDocument(Long.valueOf(revision), xcontext);
        if (deletedDocument != null) {
            xcontext.getWiki().getRecycleBinStore().checkAccess(right, userReference, deletedDocument);
        }
    }
}

