/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.doc;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DocumentRevisionProvider;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.doc.AbstractDocumentRevisionProvider;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserReference;

@Component
@Singleton
public class DefaultDocumentRevisionProvider
extends AbstractDocumentRevisionProvider {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    @Named(value="database")
    private DocumentRevisionProvider databaseDocumentRevisionProvider;

    private Pair<String, String> parseRevision(String revision) {
        int revisionPrefixIndex;
        String revisionPrefix = null;
        if (revision != null && (revisionPrefixIndex = revision.indexOf(58)) > 0) {
            revisionPrefix = revision.substring(0, revisionPrefixIndex);
        }
        String shortRevision = revisionPrefix != null ? revision.substring(revisionPrefix.length() + 1) : revision;
        return Pair.of((Object)revisionPrefix, (Object)shortRevision);
    }

    private DocumentRevisionProvider getProvider(String revisionPrefix) throws XWikiException {
        ComponentManager componentManager;
        DocumentRevisionProvider provider = this.databaseDocumentRevisionProvider;
        if (revisionPrefix != null && (componentManager = (ComponentManager)this.componentManagerProvider.get()).hasComponent(DocumentRevisionProvider.class, revisionPrefix)) {
            try {
                provider = (DocumentRevisionProvider)componentManager.getInstance(DocumentRevisionProvider.class, revisionPrefix);
            }
            catch (ComponentLookupException e) {
                throw new XWikiException("Failed to get revision provider for revision [" + revisionPrefix + "]", e);
            }
        }
        return provider;
    }

    @Override
    public XWikiDocument getRevision(DocumentReference reference, String revision) throws XWikiException {
        Pair<String, String> parsedRevision = this.parseRevision(revision);
        return this.getProvider((String)parsedRevision.getLeft()).getRevision(reference, (String)parsedRevision.getRight());
    }

    @Override
    public void checkAccess(Right right, UserReference userReference, DocumentReference documentReference, String revision) throws AuthorizationException, XWikiException {
        Pair<String, String> parsedRevision = this.parseRevision(revision);
        this.getProvider((String)parsedRevision.getLeft()).checkAccess(right, userReference, documentReference, (String)parsedRevision.getRight());
    }
}

