/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.doc;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DocumentRevisionProvider;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;

@Component
@Named(value="database")
@Singleton
public class DatabaseDocumentRevisionProvider
implements DocumentRevisionProvider {
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    @Override
    public XWikiDocument getRevision(DocumentReference reference, String revision) throws XWikiException {
        if (StringUtils.isEmpty((CharSequence)revision)) {
            return null;
        }
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(reference, xcontext);
        return this.getRevision(document, revision);
    }

    @Override
    public XWikiDocument getRevision(XWikiDocument document, String revision) throws XWikiException {
        if (StringUtils.isEmpty((CharSequence)revision)) {
            return null;
        }
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument newdoc = revision.equals(document.getVersion()) ? document : (xcontext.getWiki().hasVersioning(xcontext) ? this.loadRevision(document, revision, xcontext) : null);
        return newdoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XWikiDocument loadRevision(XWikiDocument document, String revision, XWikiContext xcontext) throws XWikiException {
        String database = xcontext.getWikiId();
        try {
            if (document.getDocumentReference().getWikiReference().getName() != null) {
                xcontext.setWikiId(document.getDocumentReference().getWikiReference().getName());
            }
            XWikiDocument xWikiDocument = xcontext.getWiki().getVersioningStore().loadXWikiDoc(document, revision, xcontext);
            return xWikiDocument;
        }
        catch (XWikiException e) {
            if (e.getCode() != 3205) {
                throw e;
            }
        }
        finally {
            xcontext.setWikiId(database);
        }
        return null;
    }
}

