/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.doc;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.xwiki.stability.Unstable;

public class BaseObjects
extends AbstractList<BaseObject> {
    private Map<Integer, BaseObject> map = new ConcurrentSkipListMap<Integer, BaseObject>();
    private int size;

    public BaseObjects() {
    }

    public BaseObjects(Collection<BaseObject> collection) {
        collection.forEach(this::add);
    }

    public BaseObjects(XWikiDocument document, BaseObjects otherObjects, boolean keepsIdentity) {
        this.size = keepsIdentity ? otherObjects.size() : 0;
        for (Map.Entry<Integer, BaseObject> entry : otherObjects.map.entrySet()) {
            BaseObject otherObject = entry.getValue();
            BaseObject clonedObject = keepsIdentity ? otherObject.clone(true) : otherObject.duplicate(document.getDocumentReference());
            clonedObject.setOwnerDocument(document);
            this.put(entry.getKey(), clonedObject);
            if (this.size > otherObject.getNumber()) continue;
            this.size = otherObject.getNumber() + 1;
        }
    }

    @Override
    public BaseObject get(int index) {
        this.rangeCheck(index);
        return this.map.get(index);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(int index, BaseObject element) {
        this.rangeCheckForAdd(index);
        if (index < this.size) {
            for (int i = this.size - 1; i >= index; --i) {
                this.put(i + 1, this.get(i));
            }
        }
        this.put(index, element);
    }

    @Override
    public BaseObject set(int index, BaseObject element) {
        this.rangeCheck(index);
        return this.put(index, element);
    }

    public BaseObject put(int index, BaseObject object) {
        BaseObject old;
        if (object == null) {
            old = this.map.remove(index);
        } else {
            object.setNumber(index);
            old = this.map.put(index, object);
        }
        if (this.size <= index) {
            this.size = index + 1;
        }
        return old;
    }

    @Override
    public BaseObject remove(int index) {
        this.rangeCheck(index);
        BaseObject previous = this.map.remove(index);
        if (index < this.size - 1) {
            for (int i = index; i < this.size - 1; ++i) {
                this.put(i, this.get(i + 1));
            }
        }
        --this.size;
        return previous;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.size = 0;
    }

    private void rangeCheck(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private void rangeCheckForAdd(int index) {
        if (index < 0 || index > this.size || index == Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    @Unstable
    public void setDirty(boolean dirty, boolean deep) {
        if (deep) {
            this.map.values().forEach(object -> object.setDirty(dirty, deep));
        }
    }
}

