/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.converter;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;

@Component
@Singleton
public class XWikiDocumentConverter
extends AbstractConverter<XWikiDocument> {
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private Provider<XWikiContext> contextProvider;

    public <G> G convert(Type targetType, Object sourceValue) {
        if (sourceValue == null) {
            return null;
        }
        if (sourceValue instanceof XWikiDocument) {
            return this.convertFromType(targetType, sourceValue);
        }
        return (G)super.convert(targetType, sourceValue);
    }

    public XWikiDocument convertToType(Type targetType, Object sourceValue) {
        if (sourceValue instanceof Document) {
            return this.convertFromDocument((Document)sourceValue);
        }
        throw new ConversionException(String.format("Unsupported source type [%s]", sourceValue.getClass()));
    }

    private XWikiDocument convertFromDocument(Document document) {
        return document.getDocument();
    }

    private <G> G convertFromType(Type targetType, Object sourceValue) {
        if (targetType.equals(String.class)) {
            return (G)this.convertToString((XWikiDocument)sourceValue);
        }
        if (EntityReference.class.isAssignableFrom(ReflectionUtils.getTypeClass((Type)targetType))) {
            return (G)this.convertToEntityReference((XWikiDocument)sourceValue);
        }
        if (targetType == Document.class) {
            return (G)this.convertToDocument((XWikiDocument)sourceValue);
        }
        throw new ConversionException(String.format("Unsupported target type [%s]", targetType));
    }

    private EntityReference convertToEntityReference(XWikiDocument document) {
        return document.getDocumentReference();
    }

    private Document convertToDocument(XWikiDocument document) {
        return document.newDocument((XWikiContext)this.contextProvider.get());
    }

    protected String convertToString(XWikiDocument value) {
        return (String)this.serializer.serialize((EntityReference)value.getDocumentReference(), new Object[0]);
    }
}

