/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.cache.rendering;

import com.xpn.xwiki.internal.cache.rendering.RenderingCacheConfiguration;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Singleton
public class DefaultRenderingCacheConfiguration
implements RenderingCacheConfiguration {
    private static final String PREFIX = "core.renderingcache.";
    private static final String PROPNAME_ENABLED = "core.renderingcache.enabled";
    private static final String PROPNAME_DOCUMENTS = "core.renderingcache.documents";
    private static final String PROPNAME_DURATION = "core.renderingcache.duration";
    private static final int PROPVALUE_DURATION = 300;
    private static final String PROPNAME_SIZE = "core.renderingcache.size";
    private static final int PROPVALUE_SIZE = 100;
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource farmConfiguration;
    @Inject
    @Named(value="wiki")
    private ConfigurationSource wikiConfiguration;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> wikiSerializer;
    @Inject
    private ModelContext modelContext;
    private Pattern farmPattern;

    @Override
    public boolean isEnabled() {
        return this.isFarmEnabled();
    }

    public boolean isFarmEnabled() {
        return (Boolean)this.farmConfiguration.getProperty(PROPNAME_ENABLED, (Object)false);
    }

    public boolean isWikiEnabled() {
        return (Boolean)this.wikiConfiguration.getProperty(PROPNAME_ENABLED, (Object)true);
    }

    @Override
    public int getDuration() {
        return (Integer)this.farmConfiguration.getProperty(PROPNAME_DURATION, (Object)300);
    }

    @Override
    public int getSize() {
        return (Integer)this.farmConfiguration.getProperty(PROPNAME_SIZE, (Object)100);
    }

    @Override
    public boolean isCached(DocumentReference documentReference) {
        if (documentReference != null && this.isFarmEnabled()) {
            if (this.isCachedInFarm(documentReference)) {
                return true;
            }
            return this.isCachedInWiki(documentReference);
        }
        return false;
    }

    private boolean isCachedInFarm(DocumentReference documentReference) {
        Pattern pattern = this.getFarmPattern();
        if (pattern != null) {
            String documentReferenceString = (String)this.serializer.serialize((EntityReference)documentReference, new Object[0]);
            return pattern.matcher(documentReferenceString).matches();
        }
        return false;
    }

    public boolean isCachedInWiki(DocumentReference documentReference) {
        Pattern pattern;
        if (this.isWikiEnabled() && this.modelContext.getCurrentEntityReference() != null && documentReference.getWikiReference().getName().equals(this.modelContext.getCurrentEntityReference().extractReference(EntityType.WIKI).getName()) && (pattern = this.getWikiPattern()) != null) {
            return pattern.matcher((CharSequence)this.serializer.serialize((EntityReference)documentReference, new Object[0])).matches() || pattern.matcher((CharSequence)this.wikiSerializer.serialize((EntityReference)documentReference, new Object[0])).matches();
        }
        return false;
    }

    private Pattern getFarmPattern() {
        if (this.farmPattern == null) {
            this.farmPattern = this.getPattern((List)this.farmConfiguration.getProperty(PROPNAME_DOCUMENTS, List.class));
        }
        return this.farmPattern;
    }

    private Pattern getWikiPattern() {
        return this.getPattern((List)this.wikiConfiguration.getProperty(PROPNAME_DOCUMENTS, List.class));
    }

    private Pattern getPattern(List<String> configuration) {
        Pattern pattern = null;
        if (configuration != null && !configuration.isEmpty()) {
            StringBuffer patternBuffer = new StringBuffer();
            for (String patternString : configuration) {
                if (patternBuffer.length() > 0) {
                    patternBuffer.append('|');
                }
                patternBuffer.append('(');
                patternBuffer.append(patternString);
                patternBuffer.append(')');
            }
            pattern = Pattern.compile(patternBuffer.toString());
        }
        return pattern;
    }
}

