/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.internal.XWikiInitializerJobStatus;
import com.xpn.xwiki.internal.XWikiInitializerRequest;
import com.xpn.xwiki.util.XWikiStubContextProvider;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.Request;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component
@Named(value="xwiki.init")
@Singleton
public class XWikiInitializerJob
extends AbstractJob<XWikiInitializerRequest, XWikiInitializerJobStatus> {
    public static final String JOBTYPE = "xwiki.init";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private XWikiStubContextProvider stubContextProvider;
    @Inject
    private ObservationManager observation;
    private Thread thread;

    protected XWikiInitializerJobStatus createNewStatus(XWikiInitializerRequest request) {
        return new XWikiInitializerJobStatus(request, this.observationManager, this.loggerManager);
    }

    public String getType() {
        return JOBTYPE;
    }

    public synchronized void startAsync() {
        if (this.thread == null) {
            this.initialize((Request)new XWikiInitializerRequest());
            this.thread = new Thread((Runnable)((Object)this));
            this.thread.setDaemon(true);
            this.thread.setName("XWiki initialization");
            this.thread.start();
        }
    }

    protected void runInternal() throws Exception {
        this.logger.info("Start XWiki initialization");
        this.progressManager.pushLevelProgress(2, (Object)this);
        try {
            this.progressManager.startStep((Object)this);
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            XWiki xwiki = new XWiki(xcontext, xcontext.getEngineContext(), true);
            this.stubContextProvider.initialize(xcontext);
            this.progressManager.endStep((Object)this);
            this.progressManager.startStep((Object)this);
            this.logger.info("XWiki initialization done");
            this.observation.notify((Event)new ApplicationReadyEvent(), (Object)xwiki, (Object)xcontext);
            xcontext.getEngineContext().setAttribute("xwiki", xwiki);
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    protected void jobFinished(Throwable exception) {
        super.jobFinished(exception);
        this.thread = null;
    }
}

