/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.environment.Environment;
import org.xwiki.properties.ConverterManager;

@Component
@Named(value="xwikicfg")
@Singleton
public class XWikiCfgConfigurationSource
implements ConfigurationSource,
Initializable {
    public static final String CFG_ENV_NAME = "XWikiConfig";
    public static final String ROLEHINT = "xwikicfg";
    @Inject
    private Environment environment;
    @Inject
    private ConverterManager converter;
    @Inject
    private Logger logger;
    private Properties properties = new Properties();
    private String configurationLocation;

    public static String getConfigPath() {
        String configurationLocation;
        block2: {
            try {
                Context envContext = (Context)new InitialContext().lookup("java:comp/env");
                configurationLocation = (String)envContext.lookup(CFG_ENV_NAME);
            }
            catch (Exception e) {
                configurationLocation = "/etc/xwiki/xwiki.cfg";
                if (new File(configurationLocation).exists()) break block2;
                configurationLocation = "/WEB-INF/xwiki.cfg";
            }
        }
        return configurationLocation;
    }

    public void initialize() throws InitializationException {
        this.configurationLocation = XWikiCfgConfigurationSource.getConfigPath();
        try (InputStream xwikicfgis = this.loadConfiguration();){
            if (xwikicfgis != null) {
                this.properties.load(xwikicfgis);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to load configuration", (Throwable)e);
        }
    }

    private InputStream loadConfiguration() {
        this.configurationLocation = XWikiCfgConfigurationSource.getConfigPath();
        File f = new File(this.configurationLocation);
        try {
            if (f.exists()) {
                return new FileInputStream(f);
            }
        }
        catch (Exception e) {
            this.logger.debug("Failed to load the file [{}] using direct file access. Trying to load it as a resource using the Servlet Context...", (Object)this.configurationLocation, (Object)e);
        }
        InputStream xwikicfgis = this.environment.getResourceAsStream(this.configurationLocation);
        if (xwikicfgis == null) {
            this.logger.debug("Failed to load the file [{}] as a resource using the Servlet Context. Trying to load it as classpath resource...", (Object)this.configurationLocation);
            xwikicfgis = Thread.currentThread().getContextClassLoader().getResourceAsStream("xwiki.cfg");
        }
        return xwikicfgis;
    }

    public String getConfigurationLocation() {
        return this.configurationLocation;
    }

    private <T> T convert(String value, Class<T> targetClass, T defaultValue) {
        try {
            if (targetClass == String[].class) {
                return (T)StringUtils.split((String)value, (String)" ,");
            }
            return (T)this.converter.convert(targetClass, (Object)value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public <T> T getProperty(String key, T defaultValue) {
        String value = (String)this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return (T)(defaultValue == null ? value : this.convert(value, defaultValue.getClass(), defaultValue));
    }

    public <T> T getProperty(String key, Class<T> valueClass) {
        String value = (String)this.getProperty(key);
        return this.convert(value, valueClass, null);
    }

    public <T> T getProperty(String key) {
        return (T)StringUtils.trim((String)this.properties.getProperty(key));
    }

    public List<String> getKeys() {
        return EnumerationUtils.toList(this.properties.propertyNames());
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public void set(Properties properties) {
        this.properties = properties;
    }
}

