/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.export.html;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.ExportURLFactory;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiServletResponseStub;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Provider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.environment.Environment;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.url.URLContextManager;
import org.xwiki.url.filesystem.FilesystemExportContext;
import org.xwiki.url.internal.filesystem.FilesystemExportContextProvider;

public class HtmlPackager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlPackager.class);
    private static final String POINT = ".";
    private static final String CONTEXT_TDOC = "tdoc";
    private static final String ZIPPATH_SEPARATOR = "/";
    private String name = "html.export";
    private String description = "";
    private Set<DocumentReference> pageReferences = new HashSet<DocumentReference>();
    private Environment environment = (Environment)Utils.getComponent(Environment.class);
    private EntityReferenceSerializer<String> pathEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "path");

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public void addPage(String page) {
        this.pageReferences.add(this.resolvePage(page));
    }

    @Deprecated
    public void addPages(Collection<String> pages) {
        for (String page : pages) {
            this.pageReferences.add(this.resolvePage(page));
        }
    }

    public void addPageReference(DocumentReference pageReference) {
        this.pageReferences.add(pageReference);
    }

    public void addPageReferences(Collection<DocumentReference> pageReferences) {
        this.pageReferences.addAll(pageReferences);
    }

    private DocumentReference resolvePage(String pageName) {
        DocumentReferenceResolver resolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "current");
        return resolver.resolve((Object)pageName, new Object[0]);
    }

    private void renderDocument(DocumentReference pageReference, ZipOutputStream zos, FilesystemExportContext exportContext, XWikiContext context) throws XWikiException, IOException {
        XWikiDocument doc = context.getWiki().getDocument(pageReference, context);
        if (doc.isNew()) {
            return;
        }
        String zipname = "pages/" + (String)this.pathEntityReferenceSerializer.serialize((EntityReference)pageReference, new Object[0]);
        String language = doc.getLanguage();
        if (language != null && language.length() != 0) {
            zipname = zipname + POINT + language;
        }
        zipname = zipname + ".html";
        ZipEntry zipentry = new ZipEntry(zipname);
        zos.putNextEntry(zipentry);
        try {
            context.setWikiId(doc.getDocumentReference().getWikiReference().getName());
            context.setDoc(doc);
            XWikiDocument tdoc = doc.getTranslatedDocument(context);
            context.put(CONTEXT_TDOC, tdoc);
            exportContext.setDocParentLevels(this.computeDocumentDepth((EntityReference)doc.getDocumentReference()));
            String content = this.evaluateDocumentContent(context);
            zos.write(content.getBytes(context.getWiki().getEncoding()));
            zos.closeEntry();
        }
        catch (Exception e) {
            throw new IOException(String.format("Failed to render document [%s] for HTML export", pageReference), e);
        }
    }

    private int computeDocumentDepth(EntityReference reference) {
        int depth = 0;
        EntityReference currentReference = reference;
        while (currentReference != null) {
            currentReference = currentReference.getParent();
            ++depth;
        }
        return depth;
    }

    private String evaluateDocumentContent(XWikiContext context) throws IOException {
        String content;
        context.getWiki().getPluginManager().beginParsing(context);
        Utils.enablePlaceholders(context);
        try {
            content = context.getWiki().evaluateTemplate("view.vm", context);
            content = Utils.replacePlaceholders(content, context);
        }
        finally {
            Utils.disablePlaceholders(context);
        }
        content = context.getWiki().getPluginManager().endParsing(content.trim(), context);
        return content;
    }

    private void renderDocuments(ZipOutputStream zos, ExportURLFactory urlf, FilesystemExportContext exportContext, XWikiContext context) throws XWikiException, IOException {
        ExecutionContextManager ecm = Utils.getComponent(ExecutionContextManager.class);
        for (DocumentReference pageReference : this.pageReferences) {
            try {
                XWikiContext renderContext = this.initializeContexts(ecm, urlf, exportContext, context);
                this.renderDocument(pageReference, zos, urlf.getFilesystemExportContext(), renderContext);
            }
            catch (ExecutionContextException e) {
                throw new XWikiException(12, 3, "Failed to initialize Execution Context", e);
            }
            finally {
                ecm.popContext();
            }
        }
    }

    private XWikiContext initializeContexts(ExecutionContextManager ecm, ExportURLFactory urlf, FilesystemExportContext exportContext, XWikiContext originalContext) throws ExecutionContextException {
        XWikiContext renderContext = originalContext.clone();
        ExecutionContext executionContext = new ExecutionContext();
        renderContext.declareInExecutionContext(executionContext);
        ecm.pushContext(executionContext, false);
        FilesystemExportContextProvider.set((ExecutionContext)executionContext, (FilesystemExportContext)exportContext);
        renderContext.put("action", "view");
        renderContext.setURLFactory(urlf);
        Utils.getComponent(URLContextManager.class).setURLFormatId("filesystem");
        renderContext.setResponse(new XWikiServletResponseStub());
        return renderContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(XWikiContext context) throws IOException, XWikiException {
        context.getResponse().setContentType("application/zip");
        context.getResponse().addHeader("Content-disposition", "attachment; filename=" + Util.encodeURI(this.name, context) + ".zip");
        context.setFinished(true);
        File dir = this.environment.getTemporaryDirectory();
        File tempdir = new File(dir, RandomStringUtils.secure().nextAlphanumeric(8));
        tempdir.mkdirs();
        try {
            File attachmentDir = new File(tempdir, "attachment");
            attachmentDir.mkdirs();
            ExportURLFactory urlf = new ExportURLFactory();
            Provider exportContextProvider = (Provider)Utils.getComponent((Type)new DefaultParameterizedType(null, Provider.class, new Type[]{FilesystemExportContext.class}));
            FilesystemExportContext exportContext = (FilesystemExportContext)exportContextProvider.get();
            urlf.init(this.pageReferences, tempdir, exportContext, context);
            ZipOutputStream zos = new ZipOutputStream((OutputStream)context.getResponse().getOutputStream());
            this.renderDocuments(zos, urlf, exportContext, context);
            for (String skinName : urlf.getFilesystemExportContext().getNeededSkins()) {
                HtmlPackager.addSkinToZip(skinName, zos, urlf.getFilesystemExportContext().getExportedSkinFiles(), context);
            }
            HtmlPackager.addDirToZip(tempdir, (FileFilter)TrueFileFilter.TRUE, zos, "", null);
            this.generateIndexPage(zos, context);
            zos.setComment(this.description);
            zos.finish();
            zos.flush();
        }
        finally {
            HtmlPackager.deleteDirectory(tempdir);
        }
    }

    private void generateIndexPage(ZipOutputStream zos, XWikiContext context) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("<!DOCTYPE HTML>\n<html lang=\"en-US\">\n    <head>\n        <meta charset=\"UTF-8\">\n        <title>Export Index</title>\n    </head>\n    <body>\n      <ul>\n");
        for (DocumentReference reference : this.pageReferences) {
            builder.append("        <li><a href=\"");
            builder.append("pages/");
            String relativeURL = new File("").toURI().relativize(new File((String)this.pathEntityReferenceSerializer.serialize((EntityReference)reference, new Object[0])).toURI()).toString();
            builder.append(relativeURL);
            builder.append(".html");
            builder.append("\">");
            builder.append(reference.toString());
            builder.append("</a></li>\n");
        }
        builder.append("      </ul>\n    </body>\n</html>\n");
        ZipEntry zipentry = new ZipEntry("index.html");
        zos.putNextEntry(zipentry);
        zos.write(builder.toString().getBytes(context.getWiki().getEncoding()));
        zos.closeEntry();
    }

    private static void deleteDirectory(File directory) {
        if (!directory.isDirectory()) {
            return;
        }
        try {
            FileUtils.deleteDirectory((File)directory);
        }
        catch (IOException e) {
            LOGGER.error("Failed to delete HTML export temporary directory", (Throwable)e);
        }
    }

    private static void addSkinToZip(String skinName, ZipOutputStream out, Collection<String> exportedSkinFiles, XWikiContext context) throws IOException {
        String realPath = context.getWiki().getEngineContext().getRealPath("/skins/" + skinName);
        if (realPath != null) {
            File file = new File(realPath);
            NotFileFilter filter = new NotFileFilter((IOFileFilter)new SuffixFileFilter(new String[]{".vm", ".less", "skin.properties"}));
            HtmlPackager.addDirToZip(file, (FileFilter)filter, out, "skins/" + skinName + ZIPPATH_SEPARATOR, exportedSkinFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addDirToZip(File directory, FileFilter filter, ZipOutputStream out, String basePath, Collection<String> exportedSkinFiles) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding dir [" + directory.getPath() + "] to the Zip file being generated.");
        }
        if (!directory.isDirectory()) {
            return;
        }
        File[] files = directory.listFiles(filter);
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                HtmlPackager.addDirToZip(file, filter, out, basePath + file.getName() + ZIPPATH_SEPARATOR, exportedSkinFiles);
                continue;
            }
            String path = basePath + file.getName();
            if (exportedSkinFiles != null && exportedSkinFiles.contains(path)) continue;
            out.putNextEntry(new ZipEntry(path));
            try {
                FileUtils.copyFile((File)file, (OutputStream)out);
            }
            finally {
                out.closeEntry();
            }
        }
    }
}

