/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.doc.rcs;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.rcs.XWikiPatch;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeContent;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeId;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeInfo;
import com.xpn.xwiki.internal.doc.rcs.XWikiTrunkNode;
import com.xpn.xwiki.util.AbstractSimpleClass;
import com.xpn.xwiki.web.Utils;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.suigeneris.jrcs.diff.PatchFailedException;
import org.suigeneris.jrcs.rcs.Archive;
import org.suigeneris.jrcs.rcs.InvalidFileFormatException;
import org.suigeneris.jrcs.rcs.InvalidTrunkVersionNumberException;
import org.suigeneris.jrcs.rcs.Version;
import org.suigeneris.jrcs.rcs.impl.Node;
import org.suigeneris.jrcs.rcs.impl.NodeNotFoundException;
import org.suigeneris.jrcs.rcs.impl.TrunkNode;
import org.suigeneris.jrcs.rcs.parse.ParseException;
import org.suigeneris.jrcs.util.ToString;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.user.UserReferenceSerializer;

public class XWikiRCSArchive
extends Archive {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiRCSArchive.class);

    public XWikiRCSArchive(Collection<XWikiRCSNodeInfo> nodeInfos, XWikiContext context) throws XWikiException {
        super(new Object[0], "");
        this.nodes.clear();
        this.head = null;
        if (nodeInfos.size() > 0) {
            for (XWikiRCSNodeInfo nodeInfo : nodeInfos) {
                XWikiJRCSNode node = new XWikiJRCSNode(nodeInfo.getId().getVersion(), null);
                node.setAuthor(nodeInfo.getAuthor());
                node.setDate(nodeInfo.getDate());
                node.setLog(nodeInfo.getComment());
                XWikiRCSNodeContent content = nodeInfo.getContent(context);
                node.setText(StringUtils.defaultString((String)content.getPatch().getContent()));
                node.setDiff(nodeInfo.isDiff());
                this.nodes.put(node.getVersion(), node);
            }
            XWikiJRCSNode last = null;
            for (Version ver : this.nodes.keySet()) {
                XWikiJRCSNode node = (XWikiJRCSNode)((Object)this.nodes.get(ver));
                if (last != null) {
                    last.setRCSNext((Node)node);
                }
                last = node;
                if (this.head != null) continue;
                this.head = node;
            }
        }
    }

    public XWikiRCSArchive(String archiveText) throws ParseException {
        super("", (Reader)new StringReader(archiveText));
    }

    @Deprecated(since="13.10.7")
    public Collection getNodes(long docId) throws NodeNotFoundException, InvalidFileFormatException, PatchFailedException {
        return this.getNodes(null, docId);
    }

    public Collection getNodes(WikiReference wikiReference, long docId) throws NodeNotFoundException, InvalidFileFormatException, PatchFailedException {
        ArrayList<AbstractSimpleClass> result = new ArrayList<AbstractSimpleClass>(this.nodes.values().size());
        Iterator it = this.nodes.values().iterator();
        while (it.hasNext()) {
            XWikiJRCSNode node = new XWikiJRCSNode((Node)it.next());
            XWikiRCSNodeInfo nodeInfo = new XWikiRCSNodeInfo();
            nodeInfo.setId(new XWikiRCSNodeId(wikiReference, docId, node.getVersion()));
            nodeInfo.setDiff(node.isDiff());
            if (!node.hasOldFormat()) {
                nodeInfo.setAuthor(node.getExtendedAuthor());
                nodeInfo.setComment(node.getLog());
                nodeInfo.setDate(node.getDate());
            } else {
                try {
                    String xml = this.getRevisionAsString(node.getVersion());
                    XWikiDocument doc = new XWikiDocument();
                    doc.fromXML(xml);
                    UserReferenceSerializer userReferenceSerializer = (UserReferenceSerializer)Utils.getComponent((Type)new DefaultParameterizedType(null, UserReferenceSerializer.class, new Type[]{String.class}));
                    nodeInfo.setAuthor((String)userReferenceSerializer.serialize(doc.getAuthors().getOriginalMetadataAuthor()));
                    nodeInfo.setComment(doc.getComment());
                    nodeInfo.setDate(doc.getDate());
                }
                catch (Exception e) {
                    LOGGER.warn("Error in revision [" + node.getVersion().toString() + "]: [" + e.getMessage() + "]. Ignoring non-fatal error, the Author, Comment and Date are not set.");
                }
            }
            XWikiRCSNodeContent content = new XWikiRCSNodeContent(nodeInfo.getId());
            content.setPatch(new XWikiPatch(node.getTextString(), node.isDiff()));
            nodeInfo.setContent(content);
            result.add(nodeInfo);
            result.add(content);
        }
        if (result.size() > 0) {
            ((XWikiRCSNodeInfo)result.get(0)).setDiff(false);
            ((XWikiRCSNodeContent)result.get(1)).getPatch().setDiff(false);
        }
        return result;
    }

    public String getRevisionAsString(Version version) throws NodeNotFoundException, InvalidFileFormatException, PatchFailedException {
        return ToString.arrayToString((Object[])super.getRevision(version), (String)RCS_NEWLINE);
    }

    private static class XWikiJRCSNode
    extends XWikiTrunkNode {
        public static String sfullVersion = "full";
        public static String sdiffVersion = "diff";

        public XWikiJRCSNode(Version vernum, TrunkNode next) throws InvalidTrunkVersionNumberException {
            super(vernum, next);
        }

        public XWikiJRCSNode(Node other) {
            this(other.version, null);
            this.setDate(other.getDate());
            this.author = other.getAuthor();
            this.setState(other.getState());
            this.setLog(other.getLog());
            this.setLocker(other.getLocker());
            this.setText(other.getText());
        }

        public boolean isDiff() {
            boolean isdiff;
            boolean bl = isdiff = !sfullVersion.equals(this.getState());
            if (this.getTextString() != null && isdiff != !this.getTextString().startsWith("<")) {
                LOGGER.warn("isDiff: Archive is inconsistent. Text and diff field are contradicting. version=" + String.valueOf(this.getVersion()));
                isdiff = !isdiff;
            }
            return isdiff;
        }

        public void setDiff(boolean isdiff) {
            if (this.getTextString() != null && isdiff != !this.getTextString().startsWith("<")) {
                LOGGER.warn("setDiff: Archive is inconsistent. Text and diff field are contradicting. version=" + String.valueOf(this.getVersion()));
                isdiff = !isdiff;
            }
            this.setState(isdiff ? sdiffVersion : sfullVersion);
        }

        public boolean hasOldFormat() {
            return !sfullVersion.equals(this.getState()) && !sdiffVersion.equals(this.getState());
        }

        public String getTextString() {
            return this.mergedText()[0].toString();
        }

        public void patch(List original, boolean annotate) throws InvalidFileFormatException, PatchFailedException {
            if (!this.isDiff()) {
                throw new IllegalArgumentException();
            }
            super.patch(original, annotate);
        }
    }
}

