/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.doc.rcs;

import java.util.List;
import java.util.StringTokenizer;
import org.suigeneris.jrcs.diff.Diff;
import org.suigeneris.jrcs.diff.DifferentiationFailedException;
import org.suigeneris.jrcs.diff.PatchFailedException;
import org.suigeneris.jrcs.diff.Revision;
import org.suigeneris.jrcs.diff.delta.AddDelta;
import org.suigeneris.jrcs.diff.delta.Chunk;
import org.suigeneris.jrcs.diff.delta.DeleteDelta;
import org.suigeneris.jrcs.diff.delta.Delta;
import org.suigeneris.jrcs.rcs.InvalidFileFormatException;
import org.suigeneris.jrcs.util.ToString;

public class XWikiPatchUtils {
    private XWikiPatchUtils() {
    }

    public static String getDiff(Object[] orig, Object[] rev) throws DifferentiationFailedException {
        return Diff.diff((Object[])orig, (Object[])rev).toRCSString();
    }

    public static String getDiff(String orig, String rev) throws DifferentiationFailedException {
        return XWikiPatchUtils.getDiff(ToString.stringToArray((String)orig), ToString.stringToArray((String)rev));
    }

    public static void patch(List<String> orig, String diff) throws InvalidFileFormatException, PatchFailedException {
        String cmd;
        Revision revision = new Revision();
        Object[] lines = ToString.stringToArray((String)diff);
        for (int it = 0; it < lines.length && (cmd = lines[it].toString()).length() != 0; ++it) {
            int count;
            int n;
            char action;
            StringTokenizer t = new StringTokenizer(cmd, "ad ", true);
            try {
                action = t.nextToken().charAt(0);
                n = Integer.parseInt(t.nextToken());
                t.nextToken();
                count = Integer.parseInt(t.nextToken());
            }
            catch (Exception e) {
                throw new InvalidFileFormatException("line::" + e.getClass().getName(), (Throwable)e);
            }
            if (action == 'd') {
                revision.addDelta((Delta)new DeleteDelta(new Chunk(n - 1, count)));
                continue;
            }
            if (action == 'a') {
                revision.addDelta((Delta)new AddDelta(n, new Chunk(XWikiPatchUtils.getTextLines(lines, it + 1, it + 1 + count), 0, count, n - 1)));
                it += count;
                continue;
            }
            throw new InvalidFileFormatException();
        }
        revision.applyTo(orig);
    }

    private static Object[] getTextLines(Object[] lines, int from, int to) {
        Object[] ret = new Object[to - from + 1];
        for (int i = from; i < to; ++i) {
            ret[i - from] = lines[i];
        }
        return ret;
    }
}

