/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.doc;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.internal.doc.ListAttachmentArchive;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.suigeneris.jrcs.rcs.Archive;
import org.suigeneris.jrcs.rcs.Version;
import org.suigeneris.jrcs.rcs.impl.Node;
import org.suigeneris.jrcs.util.ToString;

public class XWikiAttachmentArchive
implements Cloneable {
    private static final String GENERIC_EXCEPTION_MESSAGE = "Exception while manipulating the archive for attachment {0}";
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiAttachmentArchive.class);
    private XWikiAttachment attachment;
    private Archive archive;

    public long getId() {
        return this.attachment.getId();
    }

    public void setId(long id) {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            LOGGER.error("Error while attachmentArchive.clone()", (Throwable)e);
            return null;
        }
    }

    public XWikiAttachmentArchive clone(XWikiAttachment attachment, XWikiContext context) {
        ListAttachmentArchive newArchive = new ListAttachmentArchive(Arrays.stream(this.getVersions()).map(ToString::toString).map(version -> {
            try {
                XWikiAttachment newRevision = this.getRevision(this.getAttachment(), (String)version, context);
                newRevision.setFilename(attachment.getFilename());
                newRevision.setDoc(attachment.getDoc());
                newRevision.setContent(newRevision.getContentInputStream(context));
                return newRevision;
            }
            catch (XWikiException e) {
                LOGGER.warn("Failed to access revision [{}] for attachment [{}]. Cause: [{}].", new Object[]{version, this.attachment, ExceptionUtils.getRootCauseMessage((Throwable)e)});
                return null;
            }
            catch (IOException e) {
                LOGGER.warn("Failed to copy to copy the content of attachment [{}] in revision [{}]. Cause: [{}].", new Object[]{this.attachment, version, ExceptionUtils.getRootCauseMessage((Throwable)e)});
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        newArchive.setAttachment(attachment);
        return newArchive;
    }

    @Deprecated
    public Archive getRCSArchive() {
        return this.archive;
    }

    @Deprecated
    public void setRCSArchive(Archive archive) {
        this.archive = archive;
    }

    public String getArchiveAsString() throws XWikiException {
        if (this.archive == null) {
            return "";
        }
        return this.archive.toString(Archive.RCS_NEWLINE);
    }

    public String getArchiveAsString(XWikiContext context) throws XWikiException {
        if (this.archive == null && context != null) {
            this.updateArchive(context);
        }
        return this.getArchiveAsString();
    }

    public byte[] getArchive() throws XWikiException {
        if (this.archive == null) {
            return new byte[0];
        }
        return this.archive.toByteArray();
    }

    public byte[] getArchive(XWikiContext context) throws XWikiException {
        if (this.archive == null && context != null) {
            this.updateArchive(context);
        }
        return this.getArchive();
    }

    public void setArchive(byte[] data) throws XWikiException {
        if (ArrayUtils.isEmpty((byte[])data)) {
            this.archive = null;
        } else {
            try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
                this.archive = new Archive(this.getAttachment().getFilename(), (InputStream)is);
            }
            catch (Exception e) {
                Object[] args = new Object[]{this.getAttachment().getFilename()};
                throw new XWikiException(3, 3004, GENERIC_EXCEPTION_MESSAGE, e, args);
            }
        }
    }

    public void setArchive(String data) throws XWikiException {
        if (StringUtils.isEmpty((CharSequence)data)) {
            this.archive = null;
        } else {
            try (StringReader reader = new StringReader(data);){
                this.archive = new Archive(this.getAttachment().getFilename(), (Reader)reader);
            }
            catch (Error | Exception e) {
                Object[] args = new Object[]{this.getAttachment().getFilename()};
                throw new XWikiException(3, 3004, GENERIC_EXCEPTION_MESSAGE, e, args);
            }
        }
    }

    @Deprecated
    public void updateArchive(byte[] data, XWikiContext context) throws XWikiException {
        this.updateArchive(context);
    }

    public void updateArchive(XWikiContext context) throws XWikiException {
        XWikiAttachment currentAttachment = this.getAttachment();
        currentAttachment.incrementVersion();
        currentAttachment.setDate(new Date());
        this.addCurrentAttachment(context);
    }

    public void addCurrentAttachment(XWikiContext context) throws XWikiException {
        XWikiAttachment currentAttachment = this.getAttachment();
        try {
            Object[] lines = ToString.stringToArray((String)currentAttachment.toStringXML(true, false, context));
            if (this.archive != null) {
                this.archive.addRevision(lines, "");
            } else {
                this.archive = new Archive(lines, this.getAttachment().getFilename(), this.getAttachment().getVersion());
            }
            this.archive.findNode(this.archive.getRevisionVersion()).setAuthor("xwiki");
        }
        catch (Exception e) {
            Object[] args = new Object[]{this.getAttachment().getFilename()};
            throw new XWikiException(3, 3004, GENERIC_EXCEPTION_MESSAGE, e, args);
        }
    }

    public XWikiAttachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(XWikiAttachment attachment) {
        this.attachment = attachment;
    }

    public Version[] getVersions() {
        Version[] versions;
        Archive rcsArchive = this.getRCSArchive();
        if (rcsArchive != null) {
            Node[] nodes = rcsArchive.changeLog();
            versions = new Version[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                versions[i] = nodes[i].getVersion();
            }
        } else {
            versions = new Version[]{this.attachment.getRCSVersion()};
        }
        return versions;
    }

    public XWikiAttachment getRevision(XWikiAttachment attachment, String rev, XWikiContext context) throws XWikiException {
        try {
            Archive rcsArchive = this.getRCSArchive();
            if (rcsArchive == null) {
                return this.attachment.getVersion().equals(rev) ? this.attachment : null;
            }
            Version version = rcsArchive.getRevisionVersion(rev);
            if (version == null) {
                return null;
            }
            Object[] lines = rcsArchive.getRevision(version);
            StringBuilder content = new StringBuilder();
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i].toString();
                content.append(line);
                if (i == lines.length - 1) continue;
                content.append("\n");
            }
            String scontent = content.toString();
            XWikiAttachment revattach = new XWikiAttachment();
            revattach.fromXML(scontent);
            revattach.setDoc(attachment.getDoc(), false);
            revattach.setVersion(rev);
            return revattach;
        }
        catch (Exception e) {
            Object[] args = new Object[]{attachment.getFilename()};
            throw new XWikiException(3, 3004, GENERIC_EXCEPTION_MESSAGE, e, args);
        }
    }
}

