/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.doc;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DeletedAttachmentContent;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.internal.store.hibernate.HibernateDeletedAttachmentContent;
import com.xpn.xwiki.util.AbstractSimpleClass;
import com.xpn.xwiki.web.Utils;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;

public class DeletedAttachment
extends AbstractSimpleClass {
    private long id;
    private long docId;
    private String docName;
    private String filename;
    private Date date;
    private String deleter;
    private String contentStore;
    private DeletedAttachmentContent content;

    protected DeletedAttachment() {
    }

    private DeletedAttachment(long docId, String docName, String filename, String storeType, String deleter, Date deleteDate) {
        this.docId = docId;
        this.docName = docName;
        this.filename = filename;
        this.deleter = deleter;
        this.date = deleteDate;
        this.contentStore = storeType;
    }

    public DeletedAttachment(XWikiAttachment attachment, String deleter, Date deleteDate, XWikiContext context) throws XWikiException {
        this(attachment.getDocId(), attachment.getDoc().getFullName(), attachment.getFilename(), null, deleter, deleteDate);
        this.setAttachment(attachment, context);
    }

    public DeletedAttachment(long docId, String docName, String filename, String storeType, String deleter, Date deleteDate, DeletedAttachmentContent content) {
        this(docId, docName, filename, storeType, deleter, deleteDate);
        this.content = content;
    }

    public DeletedAttachment(long docId, String docName, String filename, String storeType, String deleter, Date deleteDate, DeletedAttachmentContent content, long id) {
        this(docId, docName, filename, storeType, deleter, deleteDate, content);
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    protected void setId(long id) {
        this.id = id;
    }

    public long getDocId() {
        return this.docId;
    }

    protected void setDocId(long docId) {
        this.docId = docId;
    }

    public String getDocName() {
        return this.docName;
    }

    protected void setDocName(String docName) {
        this.docName = docName;
    }

    public String getFilename() {
        return this.filename;
    }

    protected void setFilename(String filename) {
        this.filename = filename;
    }

    public AttachmentReference getAttachmentReference() {
        DocumentReference documentReference = DeletedAttachment.getDocumentReferenceResolver().resolve((Object)this.getDocName(), new Object[0]);
        return new AttachmentReference(this.getFilename(), documentReference);
    }

    private static DocumentReferenceResolver<String> getDocumentReferenceResolver() {
        return (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "currentmixed");
    }

    public Date getDate() {
        return this.date;
    }

    protected void setDate(Date date) {
        this.date = date;
    }

    public String getDeleter() {
        return this.deleter;
    }

    protected void setDeleter(String deleter) {
        this.deleter = deleter;
    }

    public String getContentStore() {
        return this.contentStore;
    }

    public void setContentStore(String xmlStore) {
        this.contentStore = xmlStore;
    }

    public String getXml() {
        if (this.content != null) {
            try {
                return this.content.getContentAsString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return "";
    }

    protected void setXml(String xml) {
        if (StringUtils.isNotEmpty((CharSequence)xml)) {
            try {
                this.content = new HibernateDeletedAttachmentContent(xml);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Deprecated
    protected void setAttachment(XWikiAttachment attachment, XWikiContext context) throws XWikiException {
        this.content = new HibernateDeletedAttachmentContent(attachment);
    }

    @Deprecated
    public XWikiAttachment restoreAttachment(XWikiAttachment attachment, XWikiContext context) throws XWikiException {
        return this.restoreAttachment(attachment);
    }

    public XWikiAttachment restoreAttachment(XWikiAttachment attachment) throws XWikiException {
        try {
            return this.content != null ? this.content.getXWikiAttachment(attachment) : null;
        }
        catch (IOException e) {
            throw new XWikiException(2, 2002, "Error restoring document", e, null);
        }
    }

    public XWikiAttachment restoreAttachment() throws XWikiException {
        return this.restoreAttachment(null);
    }
}

