/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.doc;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.user.api.XWikiRightService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.ObjectPropertyReference;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Singleton
public class DefaultDocumentAccessBridge
implements DocumentAccessBridge {
    private static final LocalDocumentReference USERCLASS_REFERENCE = new LocalDocumentReference("XWiki", "XWikiUsers");
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="readonly")
    private Provider<XWikiContext> readonlyContextProvider;
    @Inject
    @Named(value="currentmixed")
    private DocumentReferenceResolver<String> currentMixedDocumentReferenceResolver;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactWikiEntityReferenceSerializer;
    @Inject
    private Provider<ContextualAuthorizationManager> authorizationProvider;
    @Inject
    private Logger logger;

    private XWikiContext getContext() {
        return (XWikiContext)this.contextProvider.get();
    }

    public DocumentReference getDocumentReference(EntityReference entityReference) {
        XWikiContext context = this.getContext();
        if (context != null) {
            return context.getWiki().getDocumentReference(entityReference, context);
        }
        return null;
    }

    @Deprecated
    public DocumentModelBridge getDocument(String documentReference) throws Exception {
        XWikiContext xcontext = this.getContext();
        return xcontext.getWiki().getDocument(documentReference, xcontext).getTranslatedDocument(xcontext);
    }

    @Deprecated
    public DocumentModelBridge getDocument(DocumentReference documentReference) throws Exception {
        return this.getTranslatedDocumentInstance(documentReference);
    }

    public DocumentModelBridge getDocumentInstance(DocumentReference documentReference) throws Exception {
        XWikiContext xcontext = this.getContext();
        return xcontext.getWiki().getDocument(documentReference, xcontext);
    }

    public DocumentModelBridge getDocumentInstance(EntityReference reference) throws Exception {
        XWikiContext xcontext = this.getContext();
        return xcontext.getWiki().getDocument(reference, xcontext);
    }

    public DocumentModelBridge getTranslatedDocumentInstance(DocumentReference documentReference) throws Exception {
        XWikiContext xcontext = this.getContext();
        return xcontext.getWiki().getDocument(documentReference, xcontext).getTranslatedDocument(xcontext);
    }

    public DocumentModelBridge getTranslatedDocumentInstance(EntityReference entityReference) throws Exception {
        XWikiContext xcontext = this.getContext();
        return xcontext.getWiki().getDocument(entityReference, xcontext).getTranslatedDocument(xcontext);
    }

    public DocumentModelBridge getTranslatedDocumentInstance(DocumentModelBridge document) throws Exception {
        XWikiContext xcontext = this.getContext();
        if (document instanceof XWikiDocument) {
            return ((XWikiDocument)document).getTranslatedDocument(xcontext);
        }
        return this.getTranslatedDocumentInstance(document.getDocumentReference());
    }

    public DocumentReference getCurrentDocumentReference() {
        XWikiDocument currentDocument = null;
        XWikiContext context = this.getContext();
        if (context != null) {
            currentDocument = context.getDoc();
        }
        return currentDocument == null ? null : currentDocument.getDocumentReference();
    }

    @Deprecated
    public String getDocumentContent(String documentReference) throws Exception {
        XWikiContext xcontext = this.getContext();
        return this.getDocumentContent(documentReference, xcontext.getLanguage());
    }

    public String getDocumentContentForDefaultLanguage(DocumentReference documentReference) throws Exception {
        XWikiContext xcontext = this.getContext();
        return xcontext.getWiki().getDocument(documentReference, xcontext).getContent();
    }

    @Deprecated
    public String getDocumentContentForDefaultLanguage(String documentReference) throws Exception {
        XWikiContext xcontext = this.getContext();
        return xcontext.getWiki().getDocument(documentReference, xcontext).getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDocumentContent(DocumentReference documentReference, String language) throws Exception {
        XWikiContext xcontext = this.getContext();
        String originalRev = (String)xcontext.get("rev");
        try {
            xcontext.remove("rev");
            String string = xcontext.getWiki().getDocument(documentReference, xcontext).getTranslatedContent(language, xcontext);
            return string;
        }
        finally {
            if (originalRev != null) {
                xcontext.put("rev", originalRev);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getDocumentContent(String documentReference, String language) throws Exception {
        XWikiContext xcontext = this.getContext();
        String originalRev = (String)xcontext.get("rev");
        try {
            xcontext.remove("rev");
            String string = xcontext.getWiki().getDocument(documentReference, xcontext).getTranslatedContent(language, xcontext);
            return string;
        }
        finally {
            if (originalRev != null) {
                xcontext.put("rev", originalRev);
            }
        }
    }

    public boolean exists(DocumentReference documentReference) throws XWikiException {
        XWikiContext context = this.getContext();
        if (context != null) {
            return context.getWiki().exists(documentReference, context);
        }
        return false;
    }

    @Deprecated
    public boolean exists(String documentReference) throws XWikiException {
        XWikiContext context = this.getContext();
        if (context != null) {
            return context.getWiki().exists(documentReference, context);
        }
        return false;
    }

    public void setDocumentContent(DocumentReference documentReference, String content, String editComment, boolean isMinorEdit) throws Exception {
        XWikiContext xcontext = this.getContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(documentReference, xcontext);
        doc = doc.clone();
        doc.setContent(content);
        this.saveDocument(doc, editComment, isMinorEdit);
    }

    @Deprecated
    public void setDocumentContent(String documentReference, String content, String editComment, boolean isMinorEdit) throws Exception {
        XWikiContext xcontext = this.getContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(documentReference, xcontext);
        doc = doc.clone();
        doc.setContent(content);
        this.saveDocument(doc, editComment, isMinorEdit);
    }

    @Deprecated
    public String getDocumentSyntaxId(String documentReference) throws Exception {
        XWikiContext xcontext = this.getContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(documentReference, xcontext);
        return doc.getSyntaxId();
    }

    public void setDocumentSyntaxId(DocumentReference documentReference, String syntaxId) throws Exception {
        XWikiContext xcontext = this.getContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(documentReference, xcontext);
        doc = doc.clone();
        doc.setSyntaxId(syntaxId);
        this.saveDocument(doc, String.format("Changed document syntax from [%s] to [%s].", doc.getSyntax(), syntaxId), true);
    }

    @Deprecated
    public void setDocumentSyntaxId(String documentReference, String syntaxId) throws Exception {
        XWikiContext xcontext = this.getContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(documentReference, xcontext);
        doc = doc.clone();
        String oldSyntaxId = doc.getSyntaxId();
        doc.setSyntaxId(syntaxId);
        this.saveDocument(doc, String.format("Changed document syntax from [%s] to [%s].", oldSyntaxId, syntaxId), true);
    }

    public void setDocumentParentReference(DocumentReference documentReference, DocumentReference parentReference) throws Exception {
        XWikiContext xcontext = this.getContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(documentReference, xcontext);
        doc = doc.clone();
        doc.setParent((String)this.compactWikiEntityReferenceSerializer.serialize((EntityReference)parentReference, new Object[]{doc.getDocumentReference()}));
        this.saveDocument(doc, String.format("Changed document parent to [%s].", this.defaultEntityReferenceSerializer.serialize((EntityReference)parentReference, new Object[0])), true);
    }

    public void setDocumentTitle(DocumentReference documentReference, String title) throws Exception {
        XWikiContext xcontext = this.getContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(documentReference, xcontext);
        doc = doc.clone();
        doc.setTitle(title);
        this.saveDocument(doc, String.format("Changed document title to [%s].", title), true);
    }

    public int getObjectNumber(DocumentReference documentReference, DocumentReference classReference, String propertyName, String valueToMatch) {
        try {
            XWikiContext xcontext = this.getContext();
            XWikiDocument doc = xcontext.getWiki().getDocument(documentReference, xcontext);
            BaseObject object = doc.getXObject(classReference, propertyName, valueToMatch, false);
            return object != null ? object.getNumber() : -1;
        }
        catch (XWikiException e) {
            return -1;
        }
    }

    public Object getProperty(ObjectPropertyReference objectPropertyReference) {
        ObjectReference objectReference = (ObjectReference)objectPropertyReference.extractReference(EntityType.OBJECT);
        return this.getProperty(objectReference, objectPropertyReference.getName());
    }

    public Object getProperty(ObjectReference objectReference, String propertyName) {
        Object value = null;
        try {
            XWikiContext xcontext = this.getContext();
            if (xcontext != null && xcontext.getWiki() != null) {
                BaseProperty property;
                DocumentReference documentReference = (DocumentReference)objectReference.extractReference(EntityType.DOCUMENT);
                XWikiDocument doc = xcontext.getWiki().getDocument(documentReference, xcontext);
                BaseObject object = doc.getXObject(objectReference);
                if (object != null && (property = (BaseProperty)object.get(propertyName)) != null) {
                    value = property.getValue();
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to get property", (Throwable)e);
        }
        return value;
    }

    public Object getProperty(String documentReference, String className, int objectNumber, String propertyName) {
        Object value = null;
        try {
            BaseProperty property;
            XWikiDocument doc;
            BaseObject object;
            XWikiContext xcontext = this.getContext();
            if (xcontext != null && xcontext.getWiki() != null && (object = (doc = xcontext.getWiki().getDocument(documentReference, xcontext)).getObject(className, objectNumber)) != null && (property = (BaseProperty)object.get(propertyName)) != null) {
                value = property.getValue();
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to get property", (Throwable)e);
        }
        return value;
    }

    @Deprecated
    public Object getProperty(String documentReference, String className, String propertyName) {
        Object value = null;
        try {
            BaseProperty property;
            XWikiDocument doc;
            BaseObject object;
            XWikiContext xcontext = this.getContext();
            if (xcontext != null && xcontext.getWiki() != null && (object = (doc = xcontext.getWiki().getDocument(documentReference, xcontext)).getObject(className)) != null && (property = (BaseProperty)object.get(propertyName)) != null) {
                value = property.getValue();
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to get property", (Throwable)e);
        }
        return value;
    }

    public Object getProperty(DocumentReference documentReference, DocumentReference classReference, String propertyName) {
        Object value = null;
        try {
            BaseProperty property;
            XWikiDocument doc;
            BaseObject object;
            XWikiContext xcontext = this.getContext();
            if (xcontext != null && xcontext.getWiki() != null && (object = (doc = xcontext.getWiki().getDocument(documentReference, xcontext)).getXObject(classReference)) != null && (property = (BaseProperty)object.get(propertyName)) != null) {
                value = property.getValue();
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to get property", (Throwable)e);
        }
        return value;
    }

    public Object getProperty(DocumentReference documentReference, DocumentReference classReference, int objectNumber, String propertyName) {
        Object value = null;
        try {
            BaseProperty property;
            XWikiDocument doc;
            BaseObject object;
            XWikiContext xcontext = this.getContext();
            if (xcontext != null && xcontext.getWiki() != null && (object = (doc = xcontext.getWiki().getDocument(documentReference, xcontext)).getXObject(classReference, objectNumber)) != null && (property = (BaseProperty)object.get(propertyName)) != null) {
                value = property.getValue();
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to get property", (Throwable)e);
        }
        return value;
    }

    public Object getProperty(String documentReference, String propertyName) {
        Object value = null;
        try {
            BaseProperty property;
            XWikiDocument doc;
            BaseObject object;
            XWikiContext xcontext = this.getContext();
            if (xcontext != null && xcontext.getWiki() != null && (object = (doc = xcontext.getWiki().getDocument(documentReference, xcontext)).getFirstObject(propertyName, xcontext)) != null && (property = (BaseProperty)object.get(propertyName)) != null) {
                value = property.getValue();
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to get property", (Throwable)e);
        }
        return value;
    }

    public List<Object> getProperties(String documentReference, String className) {
        List<Object> result;
        try {
            XWikiContext xcontext = this.getContext();
            result = new ArrayList<Object>(xcontext.getWiki().getDocument(documentReference, xcontext).getObject(className).getFieldList());
        }
        catch (Exception ex) {
            result = Collections.emptyList();
        }
        return result;
    }

    public String getPropertyType(String className, String propertyName) throws Exception {
        BaseProperty property;
        XWikiContext xcontext = this.getContext();
        PropertyClass pc = null;
        try {
            pc = (PropertyClass)xcontext.getWiki().getDocument(className, xcontext).getXClass().get(propertyName);
        }
        catch (XWikiException e) {
            this.logger.warn("Failed to get document [{}]. Root cause: [{}]", (Object)className, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        if (pc != null && (property = pc.newProperty()) != null) {
            return property.getClass().getName();
        }
        return null;
    }

    public boolean isPropertyCustomMapped(String className, String property) throws Exception {
        XWikiContext xcontext = this.getContext();
        if (!xcontext.getWiki().hasCustomMappings()) {
            return false;
        }
        List<String> lst = xcontext.getWiki().getClass(className, xcontext).getCustomMappingPropertyList(xcontext);
        return lst != null && lst.contains(property);
    }

    @Deprecated
    public void setProperty(String documentReference, String className, String propertyName, Object propertyValue) throws Exception {
        XWikiContext xcontext = this.getContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(documentReference, xcontext);
        BaseObject obj = (doc = doc.clone()).getObject(className, true, xcontext);
        if (obj != null) {
            obj.set(propertyName, propertyValue, xcontext);
            this.saveDocument(doc, String.format("Property [%s] set.", propertyName), true);
        }
    }

    public void setProperty(DocumentReference documentReference, DocumentReference classReference, String propertyName, Object propertyValue) throws Exception {
        XWikiContext xcontext = this.getContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(documentReference, xcontext);
        BaseObject obj = (doc = doc.clone()).getXObject(classReference, true, xcontext);
        if (obj != null) {
            obj.set(propertyName, propertyValue, xcontext);
            this.saveDocument(doc, String.format("Property [%s] set.", propertyName), true);
        }
    }

    @Deprecated
    public byte[] getAttachmentContent(String documentReference, String attachmentFilename) throws Exception {
        XWikiContext xcontext = this.getContext();
        XWikiAttachment attachment = xcontext.getWiki().getDocument(documentReference, xcontext).getAttachment(attachmentFilename);
        return attachment != null ? attachment.getContent(xcontext) : new byte[]{};
    }

    @Deprecated(since="14.7RC1")
    public InputStream getAttachmentContent(AttachmentReference attachmentReference) throws Exception {
        return this.getAttachmentContent((EntityReference)attachmentReference);
    }

    public InputStream getAttachmentContent(EntityReference reference) throws Exception {
        XWikiContext xcontext = this.getContext();
        EntityReference documentReference = reference.extractReference(EntityType.DOCUMENT);
        XWikiDocument attachmentDocument = xcontext.getWiki().getDocument(documentReference, xcontext);
        XWikiAttachment attachment = attachmentDocument.getAttachment(reference.getName());
        return attachment != null ? attachment.getContentInputStream(xcontext) : null;
    }

    public void setAttachmentContent(AttachmentReference attachmentReference, byte[] attachmentData) throws Exception {
        XWikiContext xcontext = this.getContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(attachmentReference.getDocumentReference(), xcontext);
        doc = doc.clone();
        this.setAttachmentContent(doc, attachmentReference.getName(), attachmentData, xcontext);
    }

    public void setAttachmentContent(AttachmentReference attachmentReference, InputStream attachmentData) throws Exception {
        XWikiContext xcontext = this.getContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(attachmentReference.getDocumentReference(), xcontext);
        doc = doc.clone();
        this.setAttachmentContent(doc, attachmentReference.getName(), attachmentData, xcontext);
    }

    @Deprecated
    public void setAttachmentContent(String documentReference, String attachmentFilename, byte[] attachmentData) throws Exception {
        XWikiContext xcontext = this.getContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(documentReference, xcontext);
        doc = doc.clone();
        this.setAttachmentContent(doc, attachmentFilename, attachmentData, xcontext);
    }

    private void setAttachmentContent(XWikiDocument doc, String attachmentFilename, byte[] attachmentData, XWikiContext xcontext) throws Exception {
        this.setAttachmentContent(doc, attachmentFilename, new ByteArrayInputStream(attachmentData != null ? attachmentData : new byte[]{}), xcontext);
    }

    private void setAttachmentContent(XWikiDocument doc, String attachmentFilename, InputStream attachmentData, XWikiContext xcontext) throws Exception {
        if (doc.getAttachment(attachmentFilename) == null) {
            doc.setComment("Add new attachment " + attachmentFilename);
        } else {
            doc.setComment("Update attachment " + attachmentFilename);
        }
        doc.setAttachment(attachmentFilename, attachmentData, xcontext);
        doc.setAuthorReference(this.getCurrentUserReference());
        if (doc.isNew()) {
            doc.setCreatorReference(this.getCurrentUserReference());
        }
        xcontext.getWiki().saveDocument(doc, xcontext);
    }

    public List<AttachmentReference> getAttachmentReferences(DocumentReference documentReference) throws Exception {
        XWikiContext xcontext = this.getContext();
        List<XWikiAttachment> attachments = xcontext.getWiki().getDocument(documentReference, xcontext).getAttachmentList();
        ArrayList<AttachmentReference> attachmentReferences = new ArrayList<AttachmentReference>(attachments.size());
        for (XWikiAttachment attachment : attachments) {
            attachmentReferences.add(attachment.getReference());
        }
        return attachmentReferences;
    }

    public String getAttachmentVersion(AttachmentReference attachmentReference) throws Exception {
        XWikiContext xcontext = this.getContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(attachmentReference.getDocumentReference(), xcontext);
        XWikiAttachment attachment = doc.getAttachment(attachmentReference.getName());
        return attachment == null ? null : attachment.getVersion();
    }

    public String getDocumentURL(DocumentReference documentReference, String action, String queryString, String anchor) {
        return this.getDocumentURL(documentReference, action, queryString, anchor, false);
    }

    public String getDocumentURL(DocumentReference documentReference, String action, String queryString, String anchor, boolean isFullURL) {
        if (documentReference == null) {
            return this.getDocumentURL(this.getContext().getDoc().getDocumentReference(), action, queryString, anchor, isFullURL);
        }
        if (isFullURL) {
            return this.getContext().getURLFactory().createExternalURL(this.extractSpacesFromDocumentReference(documentReference), documentReference.getName(), action, queryString, anchor, documentReference.getWikiReference().getName(), this.getContext()).toString();
        }
        return this.getContext().getWiki().getURL(documentReference, action, queryString, anchor, this.getContext());
    }

    public String getDocumentURL(EntityReference entityReference, String action, String queryString, String anchor) {
        return this.getDocumentURL(entityReference, action, queryString, anchor, false);
    }

    public String getDocumentURL(EntityReference entityReference, String action, String queryString, String anchor, boolean isFullURL) {
        XWikiContext xcontext = this.getContext();
        DocumentReference documentReference = xcontext.getWiki().getDocumentReference(entityReference, xcontext);
        return this.getDocumentURL(documentReference, action, queryString, anchor, isFullURL);
    }

    @Deprecated
    public String getURL(String documentReference, String action, String queryString, String anchor) {
        XWikiContext xcontext = this.getContext();
        String computedDocumentName = documentReference;
        if (StringUtils.isEmpty((CharSequence)documentReference)) {
            computedDocumentName = xcontext.getDoc().getFullName();
        }
        return xcontext.getWiki().getURL(computedDocumentName, action, queryString, anchor, xcontext);
    }

    @Deprecated
    public String getAttachmentURL(String documentReference, String attachmentName) {
        String attachmentURL;
        XWikiContext xcontext = this.getContext();
        try {
            attachmentURL = xcontext.getWiki().getAttachmentURL(documentReference == null ? xcontext.getDoc().getFullName() : documentReference, attachmentName, xcontext);
        }
        catch (XWikiException e) {
            throw new RuntimeException("Failed to get attachment URL", e);
        }
        return attachmentURL;
    }

    public String getAttachmentURL(AttachmentReference attachmentReference, boolean isFullURL) {
        return this.getAttachmentURL(attachmentReference, null, isFullURL);
    }

    public String getAttachmentURL(AttachmentReference attachmentReference, String queryString, boolean isFullURL) {
        String url;
        if (isFullURL) {
            XWikiContext xcontext = this.getContext();
            url = xcontext.getURLFactory().createAttachmentURL(attachmentReference.getName(), this.extractSpacesFromDocumentReference(attachmentReference.getDocumentReference()), attachmentReference.getDocumentReference().getName(), "download", queryString, attachmentReference.getDocumentReference().getWikiReference().getName(), xcontext).toString();
        } else {
            XWikiContext xcontext = this.getContext();
            String documentReference = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)attachmentReference.getDocumentReference(), new Object[0]);
            if (documentReference == null) {
                documentReference = xcontext.getDoc().getFullName();
            }
            String fileName = attachmentReference.getName();
            try {
                url = xcontext.getWiki().getAttachmentURL(documentReference, fileName, queryString, xcontext);
            }
            catch (XWikiException e) {
                throw new RuntimeException("Failed to get attachment URL", e);
            }
        }
        return url;
    }

    @Deprecated
    public List<String> getAttachmentURLs(DocumentReference documentReference, boolean isFullURL) throws Exception {
        ArrayList<String> urls = new ArrayList<String>();
        for (AttachmentReference attachmentReference : this.getAttachmentReferences(documentReference)) {
            urls.add(this.getAttachmentURL(attachmentReference, isFullURL));
        }
        return urls;
    }

    public boolean isDocumentViewable(DocumentReference documentReference) {
        return this.hasRight(documentReference, "view");
    }

    @Deprecated
    public boolean isDocumentViewable(String documentReference) {
        return this.hasRight(documentReference, "view");
    }

    @Deprecated
    public boolean isDocumentEditable(String documentReference) {
        return this.hasRight(documentReference, "edit");
    }

    public boolean isDocumentEditable(DocumentReference documentReference) {
        return this.hasRight(documentReference, "edit");
    }

    public boolean hasProgrammingRights() {
        return ((ContextualAuthorizationManager)this.authorizationProvider.get()).hasAccess(Right.PROGRAM);
    }

    @Deprecated
    public String getCurrentUser() {
        DocumentReference userReference = this.getContext().getUserReference();
        if (userReference != null) {
            return (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)userReference, new Object[0]);
        }
        return "XWiki.XWikiGuest";
    }

    public DocumentReference getCurrentUserReference() {
        XWikiContext xcontext = this.getContext();
        return xcontext != null ? xcontext.getUserReference() : null;
    }

    public boolean isAdvancedUser() {
        return this.isAdvancedUser((EntityReference)this.getCurrentUserReference());
    }

    public boolean isAdvancedUser(EntityReference userReference) {
        boolean advanced = false;
        if (!XWikiRightService.isGuest(userReference)) {
            advanced = true;
            if (!XWikiRightService.isSuperAdmin(userReference)) {
                XWikiContext xcontext = this.getContext();
                try {
                    XWikiDocument userDocument = xcontext.getWiki().getDocument(userReference, xcontext);
                    advanced = Strings.CS.equals(userDocument.getStringValue((EntityReference)USERCLASS_REFERENCE, "usertype"), "Advanced");
                }
                catch (XWikiException e) {
                    this.logger.error("Failed to get document", (Throwable)e);
                }
            }
        }
        return advanced;
    }

    public void setCurrentUser(String userName) {
        this.getContext().setUser(userName);
    }

    public String getDefaultEncoding() {
        return this.getContext().getWiki().getEncoding();
    }

    public void popDocumentFromContext(Map<String, Object> backupObjects) {
        XWikiDocument.restoreContext(backupObjects, this.getContext());
    }

    @Deprecated
    public void pushDocumentInContext(Map<String, Object> backupObjects, String documentReference) throws Exception {
        XWikiContext xcontext = this.getContext();
        XWikiDocument.backupContext(backupObjects, xcontext);
        xcontext = this.getContext();
        xcontext.getWiki().getDocument(documentReference, xcontext).setAsContextDoc(xcontext);
    }

    public void pushDocumentInContext(Map<String, Object> backupObjects, DocumentReference documentReference) throws Exception {
        this.pushDocumentInContext(backupObjects, this.getDocumentInstance(documentReference));
    }

    public void pushDocumentInContext(Map<String, Object> backupObjects, DocumentModelBridge document) throws Exception {
        XWikiContext xcontext = this.getContext();
        XWikiDocument.backupContext(backupObjects, xcontext);
        xcontext = this.getContext();
        ((XWikiDocument)document).setAsContextDoc(xcontext);
    }

    public String getCurrentWiki() {
        XWikiContext xcontext = this.getContext();
        return xcontext != null ? xcontext.getWikiId() : null;
    }

    public DocumentReference getCurrentAuthorReference() {
        XWikiContext xcontext = (XWikiContext)this.readonlyContextProvider.get();
        return xcontext != null ? xcontext.getAuthorReference() : null;
    }

    private boolean hasRight(DocumentReference documentReference, String right) {
        return this.hasRight((String)this.defaultEntityReferenceSerializer.serialize((EntityReference)documentReference, new Object[0]), right);
    }

    private boolean hasRight(String documentReference, String right) {
        boolean hasRight = false;
        XWikiContext xcontext = this.getContext();
        try {
            hasRight = xcontext.getWiki().getRightService().hasAccessLevel(right, xcontext.getUser(), documentReference, xcontext);
        }
        catch (XWikiException xWikiException) {
            // empty catch block
        }
        return hasRight;
    }

    private void saveDocument(XWikiDocument doc, String comment, boolean isMinorEdit) throws Exception {
        doc.setAuthorReference(this.getContext().getUserReference());
        if (doc.isNew()) {
            doc.setCreatorReference(this.getContext().getUserReference());
        }
        this.getContext().getWiki().saveDocument(doc, comment, isMinorEdit, this.getContext());
    }

    private String extractSpacesFromDocumentReference(DocumentReference reference) {
        EntityReference spaceReference = reference.getLastSpaceReference().removeParent((EntityReference)reference.getWikiReference());
        return (String)this.defaultEntityReferenceSerializer.serialize(spaceReference, new Object[0]);
    }
}

