/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.doc;

import com.xpn.xwiki.doc.MandatoryDocumentInitializer;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.sheet.SheetBinder;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

public abstract class AbstractMandatoryDocumentInitializer
implements MandatoryDocumentInitializer,
Initializable {
    @Inject
    @Named(value="document")
    protected SheetBinder documentSheetBinder;
    @Inject
    protected WikiDescriptorManager wikiDescriptorManager;
    @Inject
    protected DocumentReferenceResolver<EntityReference> resolver;
    private EntityReference reference;
    private String title;

    public AbstractMandatoryDocumentInitializer(EntityReference reference) {
        this(reference, null);
    }

    public AbstractMandatoryDocumentInitializer(EntityReference reference, String title) {
        this.reference = reference;
        this.title = title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws InitializationException {
        if (this.reference != null && this.reference.extractReference(EntityType.WIKI) == null && this.isMainWikiOnly()) {
            AbstractMandatoryDocumentInitializer abstractMandatoryDocumentInitializer = this;
            synchronized (abstractMandatoryDocumentInitializer) {
                if (this.reference.extractReference(EntityType.WIKI) == null) {
                    DocumentReference mainWikiEntityReference = this.resolver.resolve((Object)this.reference, new Object[]{new WikiReference(this.wikiDescriptorManager.getMainWikiId())});
                    this.reference = mainWikiEntityReference;
                }
            }
        }
    }

    @Override
    public EntityReference getDocumentReference() {
        return this.reference;
    }

    @Override
    public boolean updateDocument(XWikiDocument document) {
        return this.updateDocumentFields(document, this.getTitle());
    }

    protected boolean updateTitle(XWikiDocument document) {
        if (StringUtils.isEmpty((CharSequence)document.getTitle())) {
            String returnedTitle = this.getTitle();
            if (!StringUtils.isEmpty((CharSequence)returnedTitle)) {
                document.setTitle(this.getTitle());
            }
            return true;
        }
        return false;
    }

    protected String getTitle() {
        return this.title;
    }

    protected boolean isMainWikiOnly() {
        return false;
    }

    protected boolean updateDocumentFields(XWikiDocument document, String title) {
        boolean needsUpdate = false;
        if (document.getCreatorReference() == null) {
            document.setCreator("superadmin");
            needsUpdate = true;
        }
        if (document.getAuthorReference() == null) {
            document.setAuthorReference(document.getCreatorReference());
            needsUpdate = true;
        }
        if (document.getParentReference() == null) {
            EntityReference spaceReference = this.getDocumentReference().extractReference(EntityType.SPACE);
            DocumentReference fullReference = this.resolver.resolve(null, new Object[]{spaceReference});
            LocalDocumentReference localReference = new LocalDocumentReference(fullReference);
            document.setParentReference((EntityReference)localReference);
            needsUpdate = true;
        }
        if (StringUtils.isNotEmpty((CharSequence)title) && StringUtils.isBlank((CharSequence)document.getTitle())) {
            document.setTitle(title);
            needsUpdate = true;
        }
        if (!document.isHidden().booleanValue()) {
            document.setHidden(true);
            needsUpdate = true;
        }
        return needsUpdate;
    }

    protected int intFromBoolean(Boolean value) {
        return value == null ? -1 : (value != false ? 1 : 0);
    }
}

