/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.criteria.impl;

import com.xpn.xwiki.criteria.impl.Period;
import com.xpn.xwiki.criteria.impl.PeriodFactory;
import com.xpn.xwiki.criteria.impl.Range;
import com.xpn.xwiki.criteria.impl.RangeFactory;
import java.util.Date;
import org.xwiki.stability.Unstable;

public class RevisionCriteria {
    private String author = "";
    private Period period = PeriodFactory.createMaximumPeriod();
    private Range range = RangeFactory.createAllRange();
    private boolean includeMinorVersions = false;

    public RevisionCriteria() {
    }

    public RevisionCriteria(String author, Period period, Range range, boolean includeMinorVersions) {
        if (author != null) {
            this.setAuthor(author);
        }
        if (period != null) {
            this.setPeriod(period);
        }
        if (range != null) {
            this.setRange(range);
        }
        this.setIncludeMinorVersions(includeMinorVersions);
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public Date getMinDate() {
        return new Date(this.period.getStart());
    }

    public Date getMaxDate() {
        return new Date(this.period.getEnd());
    }

    public boolean getIncludeMinorVersions() {
        return this.includeMinorVersions;
    }

    public void setIncludeMinorVersions(boolean includeMinorVersions) {
        this.includeMinorVersions = includeMinorVersions;
    }

    @Unstable
    public boolean isAllInclusive() {
        return this.includeMinorVersions && this.getAuthor().isEmpty() && this.getRange().getSize() == 0 && this.getPeriod().getStart() == Long.MIN_VALUE && this.getPeriod().getEnd() == Long.MAX_VALUE;
    }
}

