/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.criteria.impl;

import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class Period {
    private static final DateTimeFormatter DAY_PERIOD_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMdd");
    private static final DateTimeFormatter MONTH_PERIOD_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMM");
    private Interval interval;

    public Period(long start, long end) {
        this.interval = new Interval(start, end);
    }

    public long getStart() {
        return this.interval.getStartMillis();
    }

    public long getEnd() {
        return this.interval.getEndMillis();
    }

    public int getStartCode() {
        return Integer.parseInt(this.getFormatter().print((ReadableInstant)this.interval.getStart()));
    }

    public int getEndCode() {
        return Integer.parseInt(this.getFormatter().print((ReadableInstant)this.interval.getEnd()));
    }

    private DateTimeFormatter getFormatter() {
        if (this.interval.toPeriod().getMonths() >= 1) {
            return MONTH_PERIOD_FORMATTER;
        }
        return DAY_PERIOD_FORMATTER;
    }
}

