/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.api;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.AttachmentDiff;
import com.xpn.xwiki.api.Class;
import com.xpn.xwiki.api.Collection;
import com.xpn.xwiki.api.DocumentCompatibilityAspect;
import com.xpn.xwiki.api.DocumentSection;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.api.PropertyClass;
import com.xpn.xwiki.api.RevisionInfo;
import com.xpn.xwiki.criteria.impl.Period;
import com.xpn.xwiki.criteria.impl.PeriodFactory;
import com.xpn.xwiki.criteria.impl.Range;
import com.xpn.xwiki.criteria.impl.RangeFactory;
import com.xpn.xwiki.criteria.impl.RevisionCriteria;
import com.xpn.xwiki.criteria.impl.Scope;
import com.xpn.xwiki.criteria.impl.ScopeFactory;
import com.xpn.xwiki.doc.DocumentRevisionProvider;
import com.xpn.xwiki.doc.MetaDataDiff;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.XWikiDocumentArchive;
import com.xpn.xwiki.doc.XWikiLink;
import com.xpn.xwiki.doc.XWikiLock;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.ObjectDiff;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.plugin.fileupload.FileUploadPlugin;
import com.xpn.xwiki.stats.api.XWikiStatsService;
import com.xpn.xwiki.stats.impl.DocumentStats;
import com.xpn.xwiki.stats.impl.RefererStats;
import com.xpn.xwiki.util.TOCGenerator;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.suigeneris.jrcs.diff.DifferentiationFailedException;
import org.suigeneris.jrcs.diff.delta.Delta;
import org.suigeneris.jrcs.rcs.Version;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.filter.instance.input.DocumentInstanceInputProperties;
import org.xwiki.filter.output.DefaultWriterOutputTarget;
import org.xwiki.filter.output.OutputTarget;
import org.xwiki.filter.xar.output.XAROutputProperties;
import org.xwiki.internal.document.DocumentRequiredRightsReader;
import org.xwiki.model.document.DocumentAuthors;
import org.xwiki.model.internal.document.SafeDocumentAuthors;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.model.reference.PageReference;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.DocumentAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRight;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRights;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRightsManager;
import org.xwiki.stability.Unstable;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

public class Document
extends Api {
    private static final Logger LOGGER = LoggerFactory.getLogger(Document.class);
    protected XWikiDocument initialDoc;
    protected XWikiDocument doc;
    protected Object currentObj;
    private DocumentReferenceResolver<String> currentMixedDocumentReferenceResolver;
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    private EntityReferenceSerializer<String> localEntityReferenceSerializer;
    private DocumentRevisionProvider documentRevisionProvider;
    private ConfigurationSource configuration;
    private DocumentRequiredRightsManager documentRequiredRightsManager;
    private DocumentAuthorizationManager documentAuthorizationManager;

    private DocumentReferenceResolver<String> getCurrentMixedDocumentReferenceResolver() {
        if (this.currentMixedDocumentReferenceResolver == null) {
            this.currentMixedDocumentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "currentmixed");
        }
        return this.currentMixedDocumentReferenceResolver;
    }

    private EntityReferenceSerializer<String> getDefaultEntityReferenceSerializer() {
        if (this.defaultEntityReferenceSerializer == null) {
            this.defaultEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING);
        }
        return this.defaultEntityReferenceSerializer;
    }

    private EntityReferenceSerializer<String> getLocalEntityReferenceSerializer() {
        if (this.localEntityReferenceSerializer == null) {
            this.localEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "local");
        }
        return this.localEntityReferenceSerializer;
    }

    private DocumentRevisionProvider getDocumentRevisionProvider() {
        if (this.documentRevisionProvider == null) {
            this.documentRevisionProvider = Utils.getComponent(DocumentRevisionProvider.class);
        }
        return this.documentRevisionProvider;
    }

    private ConfigurationSource getConfiguration() {
        if (this.configuration == null) {
            this.configuration = Utils.getComponent(ConfigurationSource.class);
        }
        return this.configuration;
    }

    private DocumentRequiredRightsManager getDocumentRequiredRightsManager() {
        if (this.documentRequiredRightsManager == null) {
            this.documentRequiredRightsManager = Utils.getComponent(DocumentRequiredRightsManager.class);
        }
        return this.documentRequiredRightsManager;
    }

    private DocumentAuthorizationManager getDocumentAuthorizationManager() {
        if (this.documentAuthorizationManager == null) {
            this.documentAuthorizationManager = Utils.getComponent(DocumentAuthorizationManager.class);
        }
        return this.documentAuthorizationManager;
    }

    public Document(XWikiDocument doc, XWikiContext context) {
        super(context);
        this.doc = this.initialDoc = doc;
    }

    public XWikiDocument getDocument() {
        if (this.hasProgrammingRights()) {
            return this.doc;
        }
        return null;
    }

    protected XWikiDocument getDoc() {
        if (this.initialDoc == this.doc) {
            this.doc = this.initialDoc.clone();
        }
        return this.doc;
    }

    public long getId() {
        return this.doc.getId();
    }

    public DocumentReference getDocumentReference() {
        return this.doc.getDocumentReference();
    }

    public DocumentReference getDocumentReferenceWithLocale() {
        return this.doc.getDocumentReferenceWithLocale();
    }

    public PageReference getPageReference() {
        return this.doc.getPageReference();
    }

    public PageReference getPageReferenceWithLocale() {
        return this.doc.getPageReferenceWithLocale();
    }

    @Deprecated
    public String getName() {
        return this.doc.getDocumentReference().getName();
    }

    public String getSpace() {
        return this.doc.getSpace();
    }

    public String getWiki() {
        return this.doc.getDocumentReference().getWikiReference().getName();
    }

    public String getFullName() {
        return (String)this.getLocalEntityReferenceSerializer().serialize((EntityReference)this.doc.getDocumentReference(), new java.lang.Object[0]);
    }

    public String getPrefixedFullName() {
        return (String)this.getDefaultEntityReferenceSerializer().serialize((EntityReference)this.doc.getDocumentReference(), new java.lang.Object[0]);
    }

    public Version getRCSVersion() {
        return this.doc.getRCSVersion();
    }

    public String getVersion() {
        return this.doc.getVersion();
    }

    public String getPreviousVersion() {
        return this.doc.getPreviousVersion();
    }

    public String getTitle() {
        return this.doc.getTitle();
    }

    public String getDisplayTitle() {
        return this.doc.getRenderedTitle(this.getXWikiContext());
    }

    public String getPlainTitle() {
        return this.doc.getRenderedTitle(Syntax.PLAIN_1_0, this.getXWikiContext());
    }

    public String getRenderedTitle(String syntaxId) throws XWikiException {
        try {
            return this.doc.getRenderedTitle(Syntax.valueOf((String)syntaxId), this.getXWikiContext());
        }
        catch (ParseException e) {
            LOGGER.error("Failed to parse provided syntax identifier [" + syntaxId + "]", (Throwable)e);
            throw new XWikiException(4, 0, "Failed to parse syntax identifier [" + syntaxId + "]", e);
        }
        catch (Exception e) {
            LOGGER.error("Failed to render document [" + this.getPrefixedFullName() + "] title content", (Throwable)e);
            throw new XWikiException(4, 0, "Failed to render document [" + this.getPrefixedFullName() + "] content title", e);
        }
    }

    public String getFormat() {
        return this.doc.getFormat();
    }

    public String getAuthor() {
        return this.doc.getAuthor();
    }

    public DocumentReference getAuthorReference() {
        return this.doc.getAuthorReference();
    }

    public String getContentAuthor() {
        return this.doc.getContentAuthor();
    }

    public DocumentReference getContentAuthorReference() {
        return this.doc.getContentAuthorReference();
    }

    public Date getDate() {
        return this.doc.getDate();
    }

    public Date getContentUpdateDate() {
        return this.doc.getContentUpdateDate();
    }

    public Date getCreationDate() {
        return this.doc.getCreationDate();
    }

    public String getParent() {
        return this.doc.getParent();
    }

    public DocumentReference getParentReference() {
        return this.doc.getParentReference();
    }

    public String getCreator() {
        return this.doc.getCreator();
    }

    public DocumentReference getCreatorReference() {
        return this.doc.getCreatorReference();
    }

    public String getContent() {
        return this.doc.getContent();
    }

    public XDOM getXDOM() {
        return this.doc.getXDOM();
    }

    public Syntax getSyntax() {
        return this.doc.getSyntax();
    }

    @Deprecated
    public String getSyntaxId() {
        return this.doc.getSyntax().toIdString();
    }

    @Deprecated
    public String getLanguage() {
        return this.doc.getLanguage();
    }

    public Locale getLocale() {
        return this.doc.getLocale();
    }

    public String getTemplate() {
        String templateReferenceAsString = "";
        DocumentReference templateDocumentReference = this.doc.getTemplateDocumentReference();
        if (templateDocumentReference != null) {
            templateReferenceAsString = (String)this.getLocalEntityReferenceSerializer().serialize((EntityReference)templateDocumentReference, new java.lang.Object[0]);
        }
        return templateReferenceAsString;
    }

    @Deprecated
    public String getRealLanguage() throws XWikiException {
        return this.doc.getRealLanguage(this.getXWikiContext());
    }

    public Locale getRealLocale() {
        return this.doc.getRealLocale();
    }

    @Deprecated
    public String getDefaultLanguage() {
        return this.doc.getDefaultLanguage();
    }

    public Locale getDefaultLocale() {
        return this.doc.getDefaultLocale();
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.doc.setDefaultLocale(defaultLocale);
    }

    public String getDefaultTemplate() {
        return this.doc.getDefaultTemplate();
    }

    public String getComment() {
        return this.doc.getComment();
    }

    public boolean isMinorEdit() {
        return this.doc.isMinorEdit();
    }

    public List<Locale> getTranslationLocales() throws XWikiException {
        return this.doc.getTranslationLocales(this.getXWikiContext());
    }

    public String getTranslatedContent() throws XWikiException {
        return this.doc.getTranslatedContent(this.getXWikiContext());
    }

    public String getTranslatedContent(String locale) throws XWikiException {
        return this.doc.getTranslatedContent(locale, this.getXWikiContext());
    }

    public Document getTranslatedDocument(String locale) throws XWikiException {
        return this.doc.getTranslatedDocument(locale, this.getXWikiContext()).newDocument(this.getXWikiContext());
    }

    public Document getTranslatedDocument() throws XWikiException {
        return this.doc.getTranslatedDocument(this.getXWikiContext()).newDocument(this.getXWikiContext());
    }

    public String displayDocument(Syntax targetSyntax) throws XWikiException {
        return this.doc.displayDocument(targetSyntax, this.getXWikiContext());
    }

    public String displayDocument(Syntax targetSyntax, boolean restricted) throws XWikiException {
        return this.doc.displayDocument(targetSyntax, restricted, this.getXWikiContext());
    }

    public String displayDocument() throws XWikiException {
        return this.doc.displayDocument(this.getXWikiContext());
    }

    public String displayDocument(boolean restricted) throws XWikiException {
        return this.doc.displayDocument(restricted, this.getXWikiContext());
    }

    public String getRenderedContent() throws XWikiException {
        return this.doc.getRenderedContent(this.getXWikiContext());
    }

    public String getRenderedContent(boolean transformationContextIsolated) throws XWikiException {
        return this.doc.getRenderedContent(transformationContextIsolated, this.getXWikiContext());
    }

    @Deprecated
    public String getRenderedContent(String text) throws XWikiException {
        return this.getRenderedContent(text, Syntax.XWIKI_1_0.toIdString());
    }

    public String getRenderedContent(String text, String syntaxId) throws XWikiException {
        return this.getRenderedContent(text, syntaxId, false);
    }

    public String getRenderedContentRestricted(String text, String syntaxId) throws XWikiException {
        return this.getRenderedContent(text, syntaxId, true);
    }

    private String getRenderedContent(String text, String syntaxId, boolean restricted) throws XWikiException {
        return this.doc.getRenderedContent(text, syntaxId, restricted, this.getCallerDocument(this.getXWikiContext()), this.getXWikiContext());
    }

    public String getRenderedContent(String text, String sourceSyntaxId, String targetSyntaxId) throws XWikiException {
        return this.doc.getRenderedContent(text, sourceSyntaxId, targetSyntaxId, false, this.getCallerDocument(this.getXWikiContext()), this.getXWikiContext());
    }

    private XWikiDocument getCallerDocument(XWikiContext xcontext) {
        XWikiDocument sdoc = (XWikiDocument)xcontext.get("sdoc");
        if (sdoc == null) {
            sdoc = xcontext.getDoc();
        }
        return sdoc;
    }

    public String getRenderedContent(Syntax targetSyntax) throws XWikiException {
        return this.doc.getRenderedContent(targetSyntax, this.getXWikiContext());
    }

    public String getEscapedContent() throws XWikiException {
        return this.doc.getEscapedContent(this.getXWikiContext());
    }

    public String getArchive() throws XWikiException {
        return this.doc.getDocumentArchive(this.getXWikiContext()).getArchive(this.getXWikiContext());
    }

    public XWikiDocumentArchive getDocumentArchive() throws XWikiException {
        if (this.hasProgrammingRights()) {
            return this.doc.getDocumentArchive(this.getXWikiContext());
        }
        return null;
    }

    public boolean isNew() {
        return this.doc.isNew();
    }

    public String getAttachmentURL(String filename) {
        return this.doc.getAttachmentURL(filename, this.getXWikiContext());
    }

    public String getAttachmentURL(String filename, String action) {
        return this.doc.getAttachmentURL(filename, action, this.getXWikiContext());
    }

    public String getAttachmentURL(String filename, String action, String queryString) {
        return this.doc.getAttachmentURL(filename, action, queryString, this.getXWikiContext());
    }

    public String getAttachmentRevisionURL(String filename, String version) {
        return this.doc.getAttachmentRevisionURL(filename, version, this.getXWikiContext());
    }

    public String getAttachmentRevisionURL(String filename, String version, String queryString) {
        return this.doc.getAttachmentRevisionURL(filename, version, queryString, this.getXWikiContext());
    }

    public String getURL() {
        return this.doc.getURL("view", this.getXWikiContext());
    }

    public String getURL(String action) {
        return this.doc.getURL(action, this.getXWikiContext());
    }

    public String getURL(String action, String queryString) {
        return this.doc.getURL(action, queryString, this.getXWikiContext());
    }

    public String getExternalURL() {
        return this.doc.getExternalURL("view", this.getXWikiContext());
    }

    public String getExternalURL(String action) {
        return this.doc.getExternalURL(action, this.getXWikiContext());
    }

    public String getExternalURL(String action, String queryString) {
        return this.doc.getExternalURL(action, queryString, this.getXWikiContext());
    }

    public String getParentURL() throws XWikiException {
        return this.doc.getParentURL(this.getXWikiContext());
    }

    public Class getxWikiClass() {
        BaseClass bclass = this.getDoc().getXClass();
        if (bclass == null) {
            return null;
        }
        return new Class(bclass, this.getXWikiContext());
    }

    public Class[] getxWikiClasses() {
        List<BaseClass> list = this.getDoc().getXClasses(this.getXWikiContext());
        if (list == null) {
            return null;
        }
        Class[] result = new Class[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = new Class(list.get(i), this.getXWikiContext());
        }
        return result;
    }

    public int createNewObject(String classname) throws XWikiException {
        int index = this.getDoc().createNewObject(classname, this.getXWikiContext());
        this.updateAuthor();
        return index;
    }

    public Object newObject(String classname) throws XWikiException {
        int nb = this.createNewObject(classname);
        return this.getObject(classname, nb);
    }

    @Unstable
    public Object newObject(EntityReference classReference) throws XWikiException {
        int index = this.getDoc().createXObject(classReference, this.getXWikiContext());
        this.updateAuthor();
        return this.getObject(classReference, index);
    }

    public boolean isFromCache() {
        return this.doc.isFromCache();
    }

    public int getObjectNumbers(String classname) {
        return this.doc.getObjectNumbers(classname);
    }

    public Map<String, Vector<Object>> getxWikiObjects() {
        Map<DocumentReference, List<BaseObject>> map = this.getDoc().getXObjects();
        HashMap<String, Vector<Object>> resultmap = new HashMap<String, Vector<Object>>();
        for (Map.Entry<DocumentReference, List<BaseObject>> entry : map.entrySet()) {
            List<BaseObject> objects = entry.getValue();
            if (objects == null) continue;
            resultmap.put((String)this.getLocalEntityReferenceSerializer().serialize((EntityReference)entry.getKey(), new java.lang.Object[0]), this.getXObjects(objects));
        }
        return resultmap;
    }

    protected Vector<Object> getXObjects(List<BaseObject> objects) {
        if (objects == null) {
            return new Vector<Object>(0);
        }
        Vector<Object> result = new Vector<Object>(objects.size());
        for (BaseObject bobj : objects) {
            if (bobj == null) continue;
            result.add(this.newObjectApi(bobj, this.getXWikiContext()));
        }
        return result;
    }

    public Vector<Object> getObjects(String className) {
        List<BaseObject> objects = this.getDoc().getXObjects(this.doc.resolveClassReference(className));
        return this.getXObjects(objects);
    }

    @Unstable
    public List<Object> getObjects(EntityReference classReference) {
        List<BaseObject> objects = this.getDoc().getXObjects(classReference);
        return this.getXObjects(objects);
    }

    public Object getFirstObject(String fieldname) {
        try {
            BaseObject obj = this.getDoc().getFirstObject(fieldname, this.getXWikiContext());
            if (obj == null) {
                return null;
            }
            return this.newObjectApi(obj, this.getXWikiContext());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getObject(String classname, String key, String value, boolean failover) {
        try {
            BaseObject obj = this.getDoc().getObject(classname, key, value, failover);
            if (obj == null) {
                return null;
            }
            return this.newObjectApi(obj, this.getXWikiContext());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Vector<Object> getObjects(String classname, String key, String value) {
        Vector<Object> result = new Vector<Object>();
        if (StringUtils.isBlank((CharSequence)key) || value == null) {
            return this.getObjects(classname);
        }
        try {
            Vector<BaseObject> allObjects = this.getDoc().getObjects(classname);
            if (allObjects == null || allObjects.size() == 0) {
                return result;
            }
            for (BaseObject obj : allObjects) {
                BaseProperty prop;
                if (obj == null || (prop = (BaseProperty)obj.get(key)) == null || prop.getValue() == null || !value.equals(prop.getValue().toString())) continue;
                result.add(this.newObjectApi(obj, this.getXWikiContext()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public Object getObject(String classname, String key, String value) {
        try {
            BaseObject obj = this.getDoc().getObject(classname, key, value);
            if (obj == null) {
                return null;
            }
            return this.newObjectApi(obj, this.getXWikiContext());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getObject(String classname) {
        return this.getObject(classname, false);
    }

    public Object getObject(String classname, boolean create) {
        try {
            BaseObject obj = this.getDoc().getObject(classname, create, this.getXWikiContext());
            if (obj == null) {
                return null;
            }
            return this.newObjectApi(obj, this.getXWikiContext());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getObject(String classname, int nb) {
        try {
            BaseObject obj = this.getDoc().getObject(classname, nb);
            if (obj == null) {
                return null;
            }
            return this.newObjectApi(obj, this.getXWikiContext());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Unstable
    public Object getObject(EntityReference classReference, int nb) {
        try {
            BaseObject obj = this.getDoc().getXObject(classReference, nb);
            if (obj == null) {
                return null;
            }
            return this.newObjectApi(obj, this.getXWikiContext());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getObject(ObjectReference objectReference) {
        try {
            BaseObject obj = this.getDoc().getXObject(objectReference);
            return obj == null ? null : this.newObjectApi(obj, this.getXWikiContext());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getObject(ObjectReference objectReference, boolean create) {
        try {
            BaseObject obj = this.getDoc().getXObject(objectReference, create, this.getXWikiContext());
            return obj == null ? null : this.newObjectApi(obj, this.getXWikiContext());
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object newObjectApi(BaseObject obj, XWikiContext context) {
        return obj.newObjectApi(obj, context);
    }

    public String getXMLContent() throws XWikiException {
        StringWriter writer = new StringWriter();
        DefaultWriterOutputTarget outputTarget = new DefaultWriterOutputTarget((Writer)writer);
        DocumentInstanceInputProperties documentProperties = new DocumentInstanceInputProperties();
        documentProperties.setWithWikiDocumentContentHTML(true);
        documentProperties.setWithWikiAttachmentsContent(false);
        documentProperties.setWithJRCSRevisions(false);
        documentProperties.setWithRevisions(false);
        documentProperties.setExcludedPropertyTypes(Set.of("Email", "Password"));
        XAROutputProperties xarProperties = new XAROutputProperties();
        xarProperties.setPreserveVersion(false);
        xarProperties.setTarget((OutputTarget)outputTarget);
        this.doc.toXML(documentProperties, xarProperties);
        return writer.toString();
    }

    public String toXML() throws XWikiException {
        if (this.hasProgrammingRights()) {
            return this.doc.toXML(this.getXWikiContext());
        }
        return "";
    }

    public org.dom4j.Document toXMLDocument() throws XWikiException {
        if (this.hasProgrammingRights()) {
            return this.doc.toXMLDocument(this.getXWikiContext());
        }
        return null;
    }

    public Version[] getRevisions() throws XWikiException {
        return this.doc.getRevisions(this.getXWikiContext());
    }

    @Unstable
    public long getRevisionsCount(RevisionCriteria criteria) throws XWikiException {
        return this.doc.getRevisionsCount(criteria, this.getXWikiContext());
    }

    public String[] getRecentRevisions() throws XWikiException {
        return this.doc.getRecentRevisions(5, this.getXWikiContext());
    }

    public String[] getRecentRevisions(int nb) throws XWikiException {
        return this.doc.getRecentRevisions(nb, this.getXWikiContext());
    }

    public List<String> getRevisions(RevisionCriteria criteria) throws XWikiException {
        return this.doc.getRevisions(criteria, this.context);
    }

    public RevisionInfo getRevisionInfo(String version) throws XWikiException {
        return new RevisionInfo(this.doc.getRevisionInfo(version, this.getXWikiContext()), this.getXWikiContext());
    }

    public List<Attachment> getAttachmentList() {
        ArrayList<Attachment> apis = new ArrayList<Attachment>();
        for (XWikiAttachment attachment : this.getDoc().getAttachmentList()) {
            apis.add(new Attachment(this, attachment, this.getXWikiContext()));
        }
        return apis;
    }

    public Vector<Object> getComments() {
        return this.getComments(true);
    }

    public Vector<Object> getComments(boolean asc) {
        return this.getXObjects(this.getDoc().getComments(asc));
    }

    public void use(Object object) {
        this.currentObj = object;
    }

    public void use(String className) {
        this.currentObj = this.getObject(className);
    }

    public void use(String className, int nb) {
        this.currentObj = this.getObject(className, nb);
    }

    public String getActiveClass() {
        if (this.currentObj == null) {
            return null;
        }
        return this.currentObj.getName();
    }

    public String displayPrettyName(String fieldname) {
        if (this.currentObj == null) {
            return this.doc.displayPrettyName(fieldname, this.getXWikiContext());
        }
        return this.doc.displayPrettyName(fieldname, this.currentObj.getBaseObject(), this.getXWikiContext());
    }

    public String displayPrettyName(String fieldname, Object obj) {
        if (obj == null) {
            return "";
        }
        return this.doc.displayPrettyName(fieldname, obj.getBaseObject(), this.getXWikiContext());
    }

    public String displayPrettyName(String fieldname, boolean showMandatory) {
        if (this.currentObj == null) {
            return this.doc.displayPrettyName(fieldname, showMandatory, this.getXWikiContext());
        }
        return this.doc.displayPrettyName(fieldname, showMandatory, this.currentObj.getBaseObject(), this.getXWikiContext());
    }

    public String displayPrettyName(String fieldname, boolean showMandatory, Object obj) {
        if (obj == null) {
            return "";
        }
        return this.doc.displayPrettyName(fieldname, showMandatory, obj.getBaseObject(), this.getXWikiContext());
    }

    public String displayPrettyName(String fieldname, boolean showMandatory, boolean before) {
        if (this.currentObj == null) {
            return this.doc.displayPrettyName(fieldname, showMandatory, before, this.getXWikiContext());
        }
        return this.doc.displayPrettyName(fieldname, showMandatory, before, this.currentObj.getBaseObject(), this.getXWikiContext());
    }

    public String displayPrettyName(String fieldname, boolean showMandatory, boolean before, Object obj) {
        if (obj == null) {
            return "";
        }
        return this.doc.displayPrettyName(fieldname, showMandatory, before, obj.getBaseObject(), this.getXWikiContext());
    }

    public String display(String fieldname) {
        if (this.currentObj == null) {
            return this.doc.display(fieldname, this.getXWikiContext());
        }
        return this.doc.display(fieldname, this.currentObj.getBaseObject(), this.getXWikiContext());
    }

    public String display(String fieldname, String mode) {
        if (this.currentObj == null) {
            return this.doc.display(fieldname, mode, this.getXWikiContext());
        }
        return this.doc.display(fieldname, mode, this.currentObj.getBaseObject(), this.getXWikiContext());
    }

    public String display(String fieldname, String mode, String prefix) {
        if (this.currentObj == null) {
            return this.doc.display(fieldname, mode, prefix, this.getXWikiContext());
        }
        return this.doc.display(fieldname, mode, prefix, this.currentObj.getBaseObject(), this.getSyntaxId(), this.getXWikiContext());
    }

    public String display(String fieldname, Object obj) {
        if (obj == null) {
            return "";
        }
        return this.doc.display(fieldname, obj.getBaseObject(), this.getXWikiContext());
    }

    public String display(String fieldname, String type, Object obj, String wrappingSyntaxId) {
        if (obj == null) {
            return "";
        }
        return this.doc.display(fieldname, type, obj.getBaseObject(), wrappingSyntaxId, this.getXWikiContext());
    }

    public String display(String fieldname, String mode, Object obj) {
        if (obj == null) {
            return "";
        }
        return this.doc.display(fieldname, mode, obj.getBaseObject(), this.getXWikiContext());
    }

    public String display(String fieldname, String mode, String prefix, Object obj) {
        if (obj == null) {
            return "";
        }
        return this.doc.display(fieldname, mode, prefix, obj.getBaseObject(), this.getSyntaxId(), this.getXWikiContext());
    }

    public String displayForm(String className, String header, String format) {
        return this.doc.displayForm(className, header, format, this.getXWikiContext());
    }

    public String displayForm(String className, String header, String format, boolean linebreak) {
        return this.doc.displayForm(className, header, format, linebreak, this.getXWikiContext());
    }

    public String displayForm(String className) {
        return this.doc.displayForm(className, this.getXWikiContext());
    }

    public String displayRendered(PropertyClass pclass, String prefix, Collection object) throws XWikiException {
        if (pclass == null || object == null) {
            return "";
        }
        return this.doc.displayRendered(pclass.getBasePropertyClass(), prefix, object.getCollection(), this.getXWikiContext());
    }

    public String displayView(PropertyClass pclass, String prefix, Collection object) {
        if (pclass == null || object == null) {
            return "";
        }
        return this.doc.displayView(pclass.getBasePropertyClass(), prefix, object.getCollection(), this.getXWikiContext());
    }

    public String displayEdit(PropertyClass pclass, String prefix, Collection object) {
        if (pclass == null || object == null) {
            return "";
        }
        return this.doc.displayEdit(pclass.getBasePropertyClass(), prefix, object.getCollection(), this.getXWikiContext());
    }

    public String displayHidden(PropertyClass pclass, String prefix, Collection object) {
        if (pclass == null || object == null) {
            return "";
        }
        return this.doc.displayHidden(pclass.getBasePropertyClass(), prefix, object.getCollection(), this.getXWikiContext());
    }

    public List<String> getIncludedPages() {
        return this.doc.getIncludedPages(this.getXWikiContext());
    }

    public List<String> getIncludedMacros() {
        return this.doc.getIncludedMacros(this.getXWikiContext());
    }

    public List<String> getLinkedPages() {
        return new ArrayList<String>(this.doc.getUniqueLinkedPages(this.getXWikiContext()));
    }

    public Attachment getAttachment(String filename) {
        XWikiAttachment attach = this.getDoc().getAttachment(filename);
        if (attach == null) {
            return null;
        }
        return new Attachment(this, attach, this.getXWikiContext());
    }

    public Attachment removeAttachment(String filename) {
        XWikiAttachment attachment = this.getDoc().getAttachment(filename);
        if (attachment != null && (attachment = this.doc.removeAttachment(attachment)) != null) {
            return new Attachment(this, attachment, this.getXWikiContext());
        }
        return null;
    }

    public List<Delta> getContentDiff(Document origdoc, Document newdoc) throws XWikiException, DifferentiationFailedException {
        try {
            if (origdoc == null && newdoc == null) {
                return Collections.emptyList();
            }
            if (origdoc == null) {
                return this.doc.getContentDiff(new XWikiDocument(newdoc.getDocumentReference()), newdoc.doc, this.getXWikiContext());
            }
            if (newdoc == null) {
                return this.doc.getContentDiff(origdoc.doc, new XWikiDocument(origdoc.getDocumentReference()), this.getXWikiContext());
            }
            return this.doc.getContentDiff(origdoc.doc, newdoc.doc, this.getXWikiContext());
        }
        catch (Exception e) {
            java.lang.Object[] args = new java.lang.Object[]{origdoc.getFullName(), origdoc.getVersion(), newdoc.getVersion()};
            ArrayList<Delta> list = new ArrayList<Delta>();
            XWikiException xe = new XWikiException(13, 13021, "Error while making content diff of {0} between version {1} and version {2}", e, args);
            String errormsg = Util.getHTMLExceptionMessage(xe, this.getXWikiContext());
            list.add((Delta)errormsg);
            return list;
        }
    }

    public List<Delta> getXMLDiff(Document origdoc, Document newdoc) throws XWikiException, DifferentiationFailedException {
        try {
            if (origdoc == null && newdoc == null) {
                return Collections.emptyList();
            }
            if (origdoc == null) {
                return this.doc.getXMLDiff(new XWikiDocument(newdoc.getDocumentReference()), newdoc.doc, this.getXWikiContext());
            }
            if (newdoc == null) {
                return this.doc.getXMLDiff(origdoc.doc, new XWikiDocument(origdoc.getDocumentReference()), this.getXWikiContext());
            }
            return this.doc.getXMLDiff(origdoc.doc, newdoc.doc, this.getXWikiContext());
        }
        catch (Exception e) {
            java.lang.Object[] args = new java.lang.Object[]{origdoc.getFullName(), origdoc.getVersion(), newdoc.getVersion()};
            ArrayList<Delta> list = new ArrayList<Delta>();
            XWikiException xe = new XWikiException(13, 13027, "Error while making xml diff of {0} between version {1} and version {2}", e, args);
            String errormsg = Util.getHTMLExceptionMessage(xe, this.getXWikiContext());
            list.add((Delta)errormsg);
            return list;
        }
    }

    public List<Delta> getRenderedContentDiff(Document origdoc, Document newdoc) throws XWikiException, DifferentiationFailedException {
        try {
            if (origdoc == null && newdoc == null) {
                return Collections.emptyList();
            }
            if (origdoc == null) {
                return this.doc.getRenderedContentDiff(new XWikiDocument(newdoc.getDocumentReference()), newdoc.doc, this.getXWikiContext());
            }
            if (newdoc == null) {
                return this.doc.getRenderedContentDiff(origdoc.doc, new XWikiDocument(origdoc.getDocumentReference()), this.getXWikiContext());
            }
            return this.doc.getRenderedContentDiff(origdoc.doc, newdoc.doc, this.getXWikiContext());
        }
        catch (Exception e) {
            java.lang.Object[] args = new java.lang.Object[]{origdoc.getFullName(), origdoc.getVersion(), newdoc.getVersion()};
            ArrayList<Delta> list = new ArrayList<Delta>();
            XWikiException xe = new XWikiException(13, 13022, "Error while making rendered diff of {0} between version {1} and version {2}", e, args);
            String errormsg = Util.getHTMLExceptionMessage(xe, this.getXWikiContext());
            list.add((Delta)errormsg);
            return list;
        }
    }

    public List<MetaDataDiff> getMetaDataDiff(Document origdoc, Document newdoc) throws XWikiException {
        try {
            if (origdoc == null && newdoc == null) {
                return Collections.emptyList();
            }
            if (origdoc == null) {
                return this.doc.getMetaDataDiff(new XWikiDocument(newdoc.getDocumentReference()), newdoc.doc, this.getXWikiContext());
            }
            if (newdoc == null) {
                return this.doc.getMetaDataDiff(origdoc.doc, new XWikiDocument(origdoc.getDocumentReference()), this.getXWikiContext());
            }
            return this.doc.getMetaDataDiff(origdoc.doc, newdoc.doc, this.getXWikiContext());
        }
        catch (Exception e) {
            java.lang.Object[] args = origdoc != null ? new java.lang.Object[]{origdoc.getFullName(), origdoc.getVersion(), newdoc.getVersion()} : new java.lang.Object[]{this.doc.getFullName(), null, newdoc.getVersion()};
            ArrayList<MetaDataDiff> list = new ArrayList<MetaDataDiff>();
            XWikiException xe = new XWikiException(13, 13023, "Error while making meta data diff of {0} between version {1} and version {2}", e, args);
            String errormsg = Util.getHTMLExceptionMessage(xe, this.getXWikiContext());
            list.add((MetaDataDiff)((java.lang.Object)errormsg));
            return list;
        }
    }

    public List<List<ObjectDiff>> getObjectDiff(Document origdoc, Document newdoc) {
        try {
            if (origdoc == null && newdoc == null) {
                return Collections.emptyList();
            }
            if (origdoc == null) {
                return this.doc.getObjectDiff(new XWikiDocument(newdoc.getDocumentReference()), newdoc.doc, this.getXWikiContext());
            }
            if (newdoc == null) {
                return this.doc.getObjectDiff(origdoc.doc, new XWikiDocument(origdoc.getDocumentReference()), this.getXWikiContext());
            }
            return this.doc.getObjectDiff(origdoc.doc, newdoc.doc, this.getXWikiContext());
        }
        catch (Exception e) {
            java.lang.Object[] args = new java.lang.Object[]{origdoc.getFullName(), origdoc.getVersion(), newdoc.getVersion()};
            ArrayList<List<ObjectDiff>> list = new ArrayList<List<ObjectDiff>>();
            XWikiException xe = new XWikiException(13, 13025, "Error while making meta object diff of {0} between version {1} and version {2}", e, args);
            String errormsg = Util.getHTMLExceptionMessage(xe, this.getXWikiContext());
            list.add((List<ObjectDiff>)((java.lang.Object)errormsg));
            return list;
        }
    }

    public List<List<ObjectDiff>> getClassDiff(Document origdoc, Document newdoc) {
        try {
            if (origdoc == null && newdoc == null) {
                return Collections.emptyList();
            }
            if (origdoc == null) {
                return this.doc.getClassDiff(new XWikiDocument(newdoc.getDocumentReference()), newdoc.doc, this.getXWikiContext());
            }
            if (newdoc == null) {
                return this.doc.getClassDiff(origdoc.doc, new XWikiDocument(origdoc.getDocumentReference()), this.getXWikiContext());
            }
            return this.doc.getClassDiff(origdoc.doc, newdoc.doc, this.getXWikiContext());
        }
        catch (Exception e) {
            java.lang.Object[] args = new java.lang.Object[]{origdoc.getFullName(), origdoc.getVersion(), newdoc.getVersion()};
            ArrayList<List<ObjectDiff>> list = new ArrayList<List<ObjectDiff>>();
            XWikiException xe = new XWikiException(13, 13024, "Error while making class diff of {0} between version {1} and version {2}", e, args);
            String errormsg = Util.getHTMLExceptionMessage(xe, this.getXWikiContext());
            list.add((List<ObjectDiff>)((java.lang.Object)errormsg));
            return list;
        }
    }

    public List<AttachmentDiff> getAttachmentDiff(Document origdoc, Document newdoc) {
        try {
            if (origdoc == null && newdoc == null) {
                return Collections.emptyList();
            }
            if (origdoc == null) {
                return this.wrapAttachmentDiff(this.doc.getAttachmentDiff(new XWikiDocument(newdoc.getDocumentReference()), newdoc.doc, this.getXWikiContext()));
            }
            if (newdoc == null) {
                return this.wrapAttachmentDiff(this.doc.getAttachmentDiff(origdoc.doc, new XWikiDocument(origdoc.getDocumentReference()), this.getXWikiContext()));
            }
            return this.wrapAttachmentDiff(this.doc.getAttachmentDiff(origdoc.doc, newdoc.doc, this.getXWikiContext()));
        }
        catch (Exception e) {
            java.lang.Object[] args = new java.lang.Object[]{origdoc != null ? origdoc.getFullName() : null, origdoc != null ? origdoc.getVersion() : null, newdoc != null ? newdoc.getVersion() : null};
            ArrayList<AttachmentDiff> list = new ArrayList<AttachmentDiff>();
            XWikiException xe = new XWikiException(13, 13026, "Error while making attachment diff of {0} between version {1} and version {2}", e, args);
            String errormsg = Util.getHTMLExceptionMessage(xe, this.getXWikiContext());
            list.add((AttachmentDiff)((java.lang.Object)errormsg));
            return list;
        }
    }

    private List<AttachmentDiff> wrapAttachmentDiff(List<com.xpn.xwiki.doc.AttachmentDiff> diffs) {
        ArrayList<AttachmentDiff> safeAttachmentDiffs = new ArrayList<AttachmentDiff>();
        for (com.xpn.xwiki.doc.AttachmentDiff diff : diffs) {
            safeAttachmentDiffs.add(new AttachmentDiff(diff, this.getXWikiContext()));
        }
        return safeAttachmentDiffs;
    }

    public List<Delta> getLastChanges() throws XWikiException, DifferentiationFailedException {
        return this.doc.getLastChanges(this.getXWikiContext());
    }

    public DocumentStats getCurrentMonthPageStats(String action) {
        Scope scope = ScopeFactory.createPageScope(this.getFullName());
        Range range = RangeFactory.ALL;
        Period period = PeriodFactory.getCurrentMonth();
        XWikiStatsService statisticsService = this.getXWikiContext().getWiki().getStatsService(this.getXWikiContext());
        List<DocumentStats> stats = statisticsService.getDocumentStatistics(action, scope, period, range, this.context);
        if (stats.size() > 0) {
            return stats.get(0);
        }
        return new DocumentStats();
    }

    public DocumentStats getCurrentMonthSpaceStats(String action) {
        Scope scope = ScopeFactory.createSpaceScope(this.doc.getSpace(), false);
        Range range = RangeFactory.ALL;
        Period period = PeriodFactory.getCurrentMonth();
        XWikiStatsService statisticsService = this.getXWikiContext().getWiki().getStatsService(this.getXWikiContext());
        List<DocumentStats> stats = statisticsService.getDocumentStatistics(action, scope, period, range, this.context);
        if (stats.size() > 0) {
            return stats.get(0);
        }
        return new DocumentStats();
    }

    public List<RefererStats> getCurrentMonthRefStats() {
        Scope scope = ScopeFactory.createPageScope(this.getFullName());
        Range range = RangeFactory.ALL;
        Period period = PeriodFactory.getCurrentMonth();
        XWikiStatsService statisticsService = this.getXWikiContext().getWiki().getStatsService(this.getXWikiContext());
        List<RefererStats> stats = statisticsService.getRefererStatistics("", scope, period, range, this.context);
        return stats;
    }

    public boolean checkAccess(String right) {
        try {
            return this.getXWikiContext().getWiki().checkAccess(right, this.doc, this.getXWikiContext());
        }
        catch (XWikiException e) {
            return false;
        }
    }

    public boolean hasAccessLevel(String level) {
        try {
            return this.getXWikiContext().getWiki().getRightService().hasAccessLevel(level, this.getXWikiContext().getUser(), this.getPrefixedFullName(), this.getXWikiContext());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean hasAccessLevel(String level, String user) {
        try {
            return this.getXWikiContext().getWiki().getRightService().hasAccessLevel(level, user, this.getPrefixedFullName(), this.getXWikiContext());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean hasAccess(Right right, DocumentReference userReference) {
        return this.getAuthorizationManager().hasAccess(right, userReference, (EntityReference)this.getDocumentReference());
    }

    public boolean hasAccess(Right right) {
        return this.hasAccess(right, this.getXWikiContext().getUserReference());
    }

    public boolean getLocked() {
        try {
            XWikiLock lock = this.doc.getLock(this.getXWikiContext());
            return lock != null && !this.getXWikiContext().getUser().equals(lock.getUserName());
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getLockingUser() {
        try {
            XWikiLock lock = this.doc.getLock(this.getXWikiContext());
            if (lock != null && !this.getXWikiContext().getUser().equals(lock.getUserName())) {
                return lock.getUserName();
            }
            return "";
        }
        catch (XWikiException e) {
            return "";
        }
    }

    public Date getLockingDate() {
        try {
            XWikiLock lock = this.doc.getLock(this.getXWikiContext());
            if (lock != null && !this.getXWikiContext().getUser().equals(lock.getUserName())) {
                return lock.getDate();
            }
            return null;
        }
        catch (XWikiException e) {
            return null;
        }
    }

    public java.lang.Object get(String classOrFieldName) {
        if (this.currentObj != null) {
            return this.doc.display(classOrFieldName, this.currentObj.getBaseObject(), this.getXWikiContext());
        }
        BaseObject object = this.doc.getFirstObject(classOrFieldName, this.getXWikiContext());
        if (object != null) {
            return this.doc.display(classOrFieldName, object, this.getXWikiContext());
        }
        return this.getDoc().getObject(classOrFieldName);
    }

    public java.lang.Object getValue(String fieldName) {
        Object object = this.currentObj == null ? new Object(this.getDoc().getFirstObject(fieldName, this.getXWikiContext()), this.getXWikiContext()) : this.currentObj;
        return this.getValue(fieldName, object);
    }

    public java.lang.Object getValue(String fieldName, Object object) {
        if (object != null) {
            return object.getValue(fieldName);
        }
        return null;
    }

    public String getTextArea() {
        return XWiki.getTextArea(this.doc.getContent(), this.getXWikiContext());
    }

    public Map<String, Map<String, java.lang.Object>> getTOC(int init, int max, boolean numbered) {
        this.getXWikiContext().put("tocNumbered", new Boolean(numbered));
        return TOCGenerator.generateTOC(this.getContent(), init, max, numbered, this.getXWikiContext());
    }

    public String getTags() {
        return this.doc.getTags(this.getXWikiContext());
    }

    public List<String> getTagList() {
        return this.getDoc().getTagsList(this.getXWikiContext());
    }

    public List<String> getTagsPossibleValues() {
        return this.doc.getTagsPossibleValues(this.getXWikiContext());
    }

    public void insertText(String text, String marker) throws XWikiException {
        if (this.hasAccessLevel("edit")) {
            this.getDoc().insertText(text, marker, this.getXWikiContext());
            this.updateAuthor();
            this.updateContentAuthor();
        }
    }

    public boolean equals(java.lang.Object arg0) {
        if (!(arg0 instanceof Document)) {
            return false;
        }
        Document d = (Document)arg0;
        return d.getXWikiContext().equals(this.getXWikiContext()) && this.doc.equals(d.doc);
    }

    public boolean same(XWikiDocument document) {
        return document == this.doc || document == this.initialDoc;
    }

    public List<String> getBacklinks() throws XWikiException {
        return this.doc.getBackLinkedPages(this.getXWikiContext());
    }

    public List<DocumentReference> getBackLinkedReferences() throws XWikiException {
        return this.doc.getBackLinkedReferences(this.getXWikiContext());
    }

    public List<XWikiLink> getLinks() throws XWikiException {
        return new ArrayList<XWikiLink>(this.doc.getUniqueWikiLinkedPages(this.getXWikiContext()));
    }

    public List<DocumentSection> getSections() throws XWikiException {
        return this.doc.getSections();
    }

    public List<String> getChildren() throws XWikiException {
        return this.doc.getChildren(this.getXWikiContext());
    }

    public List<DocumentReference> getChildrenReferences() throws XWikiException {
        return this.doc.getChildrenReferences(this.getXWikiContext());
    }

    public List<String> getChildren(int nb, int start) throws XWikiException {
        return this.doc.getChildren(nb, start, this.getXWikiContext());
    }

    public String getDefaultEditMode() throws XWikiException {
        return this.doc.getDefaultEditMode(this.getXWikiContext());
    }

    public String getDefaultEditURL() throws XWikiException {
        return this.doc.getDefaultEditURL(this.getXWikiContext());
    }

    public String getEditURL(String action, String mode) throws XWikiException {
        return this.doc.getEditURL(action, mode, this.getXWikiContext());
    }

    public String getEditURL(String action, String mode, String locale) {
        return this.doc.getEditURL(action, mode, locale, this.getXWikiContext());
    }

    public boolean isCurrentUserCreator() {
        return this.doc.isCurrentUserCreator(this.getXWikiContext());
    }

    public boolean isCurrentUserPage() {
        return this.doc.isCurrentUserPage(this.getXWikiContext());
    }

    public boolean isCurrentLocalUserPage() {
        return this.doc.isCurrentLocalUserPage(this.getXWikiContext());
    }

    public boolean isCreator(String username) {
        return this.doc.isCreator(username);
    }

    public void set(String fieldname, java.lang.Object value) throws XWikiException {
        Object obj = this.currentObj != null ? this.currentObj : this.getFirstObject(fieldname);
        this.set(fieldname, value, obj);
    }

    public void set(String fieldname, java.lang.Object value, Object obj) throws XWikiException {
        if (obj == null) {
            return;
        }
        obj.set(fieldname, value);
    }

    public void setTitle(String title) {
        this.getDoc().setTitle(title);
        this.updateAuthor();
        this.updateContentAuthor();
    }

    public void setCustomClass(String customClass) {
        this.getDoc().setCustomClass(customClass);
        this.updateAuthor();
    }

    public void setParent(String parent) {
        this.getDoc().setParent(parent);
        this.updateAuthor();
    }

    private void updateContentAuthor() {
        XWikiContext xcontext = this.getXWikiContext();
        this.getDoc().setContentAuthorReference(xcontext.getAuthorReference());
    }

    private void updateAuthor() {
        Document.updateAuthor(this.getDoc(), this.getXWikiContext());
    }

    protected static void updateAuthor(XWikiDocument document, XWikiContext xcontext) {
        DocumentReference author = xcontext.getAuthorReference();
        document.setAuthorReference(author);
        XWikiDocument secureDocument = xcontext.getSecureDocument();
        if (secureDocument != null) {
            DocumentRequiredRightsManager requiredRightsManager = Utils.getComponent(DocumentRequiredRightsManager.class);
            DocumentReference secureDocumentReference = secureDocument.getDocumentReference();
            try {
                DocumentRequiredRights secureRequiredRights = requiredRightsManager.getRequiredRights(secureDocumentReference).orElse(DocumentRequiredRights.EMPTY);
                DocumentRequiredRights requiredRights = requiredRightsManager.getRequiredRights(document.getDocumentReference()).orElse(DocumentRequiredRights.EMPTY);
                DocumentAuthorizationManager authorizationManager = Utils.getComponent(DocumentAuthorizationManager.class);
                if (!(!secureRequiredRights.enforce() || authorizationManager.hasAccess(Right.PROGRAM, null, author, secureDocumentReference) || requiredRights.enforce() && Document.hasAllRequiredRights(requiredRights, secureDocumentReference, author))) {
                    document.setRestricted(true);
                }
            }
            catch (AuthorizationException e) {
                document.setRestricted(true);
                LOGGER.error("Failed to load or check required rights in update of document [{}]", (java.lang.Object)document.getDocumentReference(), (java.lang.Object)e);
            }
        }
    }

    private static boolean hasAllRequiredRights(DocumentRequiredRights requiredRights, DocumentReference secureDocumentReference, DocumentReference author) {
        DocumentAuthorizationManager authorizationManager = Utils.getComponent(DocumentAuthorizationManager.class);
        return requiredRights.rights().stream().allMatch(requiredRight -> authorizationManager.hasAccess(requiredRight.right(), requiredRight.scope(), author, secureDocumentReference));
    }

    public void setContent(String content) {
        this.getDoc().setContent(content);
        this.updateAuthor();
        this.updateContentAuthor();
    }

    public void setContent(XDOM content) throws XWikiException {
        this.getDoc().setContent(content);
        this.updateAuthor();
        this.updateContentAuthor();
    }

    public void setSyntax(Syntax syntax) {
        this.getDoc().setSyntax(syntax);
        this.updateAuthor();
        this.updateContentAuthor();
    }

    public void setSyntaxId(String syntaxId) {
        this.getDoc().setSyntaxId(syntaxId);
        this.updateAuthor();
        this.updateContentAuthor();
    }

    public void setDefaultTemplate(String dtemplate) {
        this.getDoc().setDefaultTemplate(dtemplate);
        this.updateAuthor();
    }

    public void setComment(String comment) {
        this.getDoc().setComment(comment);
    }

    public void setMinorEdit(boolean isMinor) {
        this.getDoc().setMinorEdit(isMinor);
    }

    public void save() throws XWikiException {
        this.save("", false);
    }

    public void save(String comment) throws XWikiException {
        this.save(comment, false);
    }

    private UserReferenceResolver<CurrentUserReference> getCurrentUserReferenceResolver() {
        return (UserReferenceResolver)Utils.getComponent((Type)new DefaultParameterizedType(null, UserReferenceResolver.class, new Type[]{CurrentUserReference.class}));
    }

    public void save(String comment, boolean minorEdit) throws XWikiException {
        if (this.hasAccessLevel("edit")) {
            DocumentAuthors authors = this.getDoc().getAuthors();
            authors.setOriginalMetadataAuthor(this.getCurrentUserReferenceResolver().resolve((java.lang.Object)CurrentUserReference.INSTANCE, new java.lang.Object[0]));
            if (this.hasProgrammingRights() || !((Boolean)this.getConfiguration().getProperty("security.script.save.checkAuthor", (java.lang.Object)true)).booleanValue()) {
                this.saveDocument(comment, minorEdit);
            } else {
                this.saveAsAuthor(comment, minorEdit);
            }
        } else {
            java.lang.Object[] args = new java.lang.Object[]{this.getDefaultEntityReferenceSerializer().serialize((EntityReference)this.getDocumentReference(), new java.lang.Object[0])};
            throw new XWikiException(9, 9001, "Access denied in edit mode on document {0}", null, args);
        }
    }

    public void saveWithProgrammingRights() throws XWikiException {
        this.saveWithProgrammingRights("", false);
    }

    public void saveWithProgrammingRights(String comment) throws XWikiException {
        this.saveWithProgrammingRights(comment, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveWithProgrammingRights(String comment, boolean minorEdit) throws XWikiException {
        block5: {
            if (this.hasProgrammingRights()) {
                XWikiContext context = this.getXWikiContext();
                String currentWikiId = context.getWikiId();
                try {
                    context.setWikiId(this.getWiki());
                    if (!context.getWiki().isReadOnly()) {
                        this.saveDocument(comment, minorEdit, false);
                        break block5;
                    }
                    java.lang.Object[] args = new java.lang.Object[]{this.getDefaultEntityReferenceSerializer().serialize((EntityReference)this.getDocumentReference(), new java.lang.Object[0]), this.getWiki()};
                    throw new XWikiException(9, 9001, "Access denied in edit mode on document [{0}]. The wiki [{1}] is in read only mode.", null, args);
                }
                finally {
                    context.setWikiId(currentWikiId);
                }
            }
            java.lang.Object[] args = new java.lang.Object[]{this.getFullName()};
            throw new XWikiException(9, 9001, "Access denied with no programming rights document {0}", null, args);
        }
    }

    public void saveAsAuthor() throws XWikiException {
        this.saveAsAuthor("", false);
    }

    public void saveAsAuthor(String comment) throws XWikiException {
        this.saveAsAuthor(comment, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAsAuthor(String comment, boolean minorEdit) throws XWikiException {
        XWikiContext xcontext = this.getXWikiContext();
        this.getDoc().getAuthors().setOriginalMetadataAuthor(this.getCurrentUserReferenceResolver().resolve((java.lang.Object)CurrentUserReference.INSTANCE, new java.lang.Object[0]));
        DocumentReference author = this.getEffectiveAuthorReference();
        if (this.hasAccess(Right.EDIT, author)) {
            DocumentReference currentUser = xcontext.getUserReference();
            try {
                xcontext.setUserReference(author);
                this.saveDocument(comment, minorEdit);
            }
            finally {
                xcontext.setUserReference(currentUser);
            }
        } else {
            java.lang.Object[] args = new java.lang.Object[]{author, xcontext.getDoc(), this.getFullName()};
            throw new XWikiException(9, 9001, "Access denied; user {0}, acting through script in document {1} cannot save document {2}", null, args);
        }
    }

    protected void saveDocument(String comment, boolean minorEdit) throws XWikiException {
        this.saveDocument(comment, minorEdit, true);
    }

    private void saveDocument(String comment, boolean minorEdit, boolean checkSaving) throws XWikiException {
        XWikiDocument doc = this.getDoc();
        UserReference currentUserReference = this.getCurrentUserReferenceResolver().resolve((java.lang.Object)CurrentUserReference.INSTANCE, new java.lang.Object[0]);
        doc.getAuthors().setEffectiveMetadataAuthor(currentUserReference);
        if (doc.isNew()) {
            doc.getAuthors().setCreator(currentUserReference);
        }
        XWikiContext xWikiContext = this.getXWikiContext();
        if (checkSaving) {
            DocumentReference author = doc.getAuthorReference();
            XWikiDocument secureDocument = xWikiContext.getSecureDocument();
            if (secureDocument != null) {
                this.checkRequiredRightsForSaving(secureDocument, doc, xWikiContext.getAuthorReference());
            }
            xWikiContext.getWiki().checkSavingDocument(author, doc, comment, minorEdit, xWikiContext);
        }
        xWikiContext.getWiki().saveDocument(doc, comment, minorEdit, xWikiContext);
        this.initialDoc = this.doc;
    }

    private void checkRequiredRightsForSaving(XWikiDocument secureDocument, XWikiDocument doc, DocumentReference author) throws XWikiException {
        DocumentRequiredRights secureDocumentRequiredRights;
        try {
            secureDocumentRequiredRights = this.getDocumentRequiredRightsManager().getRequiredRights(secureDocument.getDocumentReference()).orElse(DocumentRequiredRights.EMPTY);
        }
        catch (AuthorizationException e) {
            throw new XWikiException(9, 9001, "The required rights for document [%s] couldn't be loaded".formatted(secureDocument.getDocumentReference()), e);
        }
        try {
            if (secureDocumentRequiredRights.enforce() && !this.getDocumentAuthorizationManager().hasAccess(Right.PROGRAM, null, author, secureDocument.getDocumentReference())) {
                DocumentRequiredRights rightsToCheck;
                if (this.isTranslation()) {
                    rightsToCheck = this.getDocumentRequiredRightsManager().getRequiredRights(doc.getDocumentReference()).orElse(DocumentRequiredRights.EMPTY);
                    if (!rightsToCheck.enforce()) {
                        throw new XWikiException(9, 9001, "The document cannot be saved because rights on the secure document [%s] are restricted using required rights and the document to save [%s] doesn't enforce required rights.".formatted(secureDocument.getDocumentReference(), doc.getDocumentReference()));
                    }
                } else {
                    if (!doc.isEnforceRequiredRights()) {
                        doc.setEnforceRequiredRights(true);
                    }
                    DocumentRequiredRightsReader rightsReader = Utils.getComponent(DocumentRequiredRightsReader.class);
                    rightsToCheck = rightsReader.readRequiredRights(doc);
                }
                for (DocumentRequiredRight requiredRight : rightsToCheck.rights()) {
                    this.getDocumentAuthorizationManager().checkAccess(requiredRight.right(), requiredRight.scope(), author, secureDocument.getDocumentReference());
                }
            }
        }
        catch (AuthorizationException e) {
            throw new XWikiException(9, 9001, "The document cannot be saved because rights on the secure document [%s] are restricted using required rights and the document to save [%s] has more rights than the secure document.".formatted(secureDocument.getDocumentReference(), doc.getDocumentReference()), e);
        }
    }

    public Object addObjectFromRequest() throws XWikiException {
        Object obj = new Object(this.getDoc().addXObjectFromRequest(this.getXWikiContext()), this.getXWikiContext());
        this.updateAuthor();
        return obj;
    }

    public Object addObjectFromRequest(String className) throws XWikiException {
        Object obj = new Object(this.getDoc().addObjectFromRequest(className, this.getXWikiContext()), this.getXWikiContext());
        this.updateAuthor();
        return obj;
    }

    public List<Object> addObjectsFromRequest(String className) throws XWikiException {
        return this.addObjectsFromRequest(className, "");
    }

    public Object addObjectFromRequest(String className, String prefix) throws XWikiException {
        Object obj = new Object(this.getDoc().addObjectFromRequest(className, prefix, this.getXWikiContext()), this.getXWikiContext());
        this.updateAuthor();
        return obj;
    }

    public List<Object> addObjectsFromRequest(String className, String prefix) throws XWikiException {
        List<BaseObject> objs = this.getDoc().addObjectsFromRequest(className, prefix, this.getXWikiContext());
        ArrayList<Object> wrapped = new ArrayList<Object>();
        for (BaseObject object : objs) {
            wrapped.add(new Object(object, this.getXWikiContext()));
        }
        this.updateAuthor();
        return wrapped;
    }

    public Object updateObjectFromRequest(String className) throws XWikiException {
        Object obj = new Object(this.getDoc().updateObjectFromRequest(className, this.getXWikiContext()), this.getXWikiContext());
        this.updateAuthor();
        return obj;
    }

    public List<Object> updateObjectsFromRequest(String className) throws XWikiException {
        return this.updateObjectsFromRequest(className, "");
    }

    public Object updateObjectFromRequest(String className, String prefix) throws XWikiException {
        Object obj = new Object(this.getDoc().updateObjectFromRequest(className, prefix, this.getXWikiContext()), this.getXWikiContext());
        this.updateAuthor();
        return obj;
    }

    public List<Object> updateObjectsFromRequest(String className, String prefix) throws XWikiException {
        List<BaseObject> objs = this.getDoc().updateObjectsFromRequest(className, prefix, this.getXWikiContext());
        ArrayList<Object> wrapped = new ArrayList<Object>();
        for (BaseObject object : objs) {
            wrapped.add(new Object(object, this.getXWikiContext()));
        }
        this.updateAuthor();
        return wrapped;
    }

    public boolean isAdvancedContent() {
        return this.doc.isAdvancedContent();
    }

    public boolean isProgrammaticContent() {
        return this.doc.isProgrammaticContent();
    }

    public boolean removeObject(Object object) {
        return this.getDoc().removeObject(object.getBaseObject());
    }

    public boolean removeObjects(String className) {
        return this.getDoc().removeObjects(className);
    }

    protected void deleteDocument() throws XWikiException {
        this.getXWikiContext().getWiki().deleteDocument(this.doc, this.getXWikiContext());
        this.initialDoc = this.doc;
    }

    public void delete() throws XWikiException {
        if (!this.hasAccessLevel("delete")) {
            java.lang.Object[] args = new java.lang.Object[]{this.getFullName()};
            throw new XWikiException(9, 9001, "Access denied in edit mode on document {0}", null, args);
        }
        this.deleteDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAsAuthor() throws XWikiException {
        XWikiContext xcontext = this.getXWikiContext();
        DocumentReference author = this.getEffectiveAuthorReference();
        if (this.hasAccess(Right.DELETE, author)) {
            DocumentReference currentUser = xcontext.getUserReference();
            try {
                xcontext.setUserReference(author);
                this.deleteDocument();
            }
            finally {
                xcontext.setUserReference(currentUser);
            }
        } else {
            java.lang.Object[] args = new java.lang.Object[]{author, xcontext.getDoc(), this.getFullName()};
            throw new XWikiException(9, 9001, "Access denied; user {0}, acting through script in document {1} cannot delete document {2}", null, args);
        }
    }

    public void deleteWithProgrammingRights() throws XWikiException {
        if (!this.hasProgrammingRights()) {
            java.lang.Object[] args = new java.lang.Object[]{this.getFullName()};
            throw new XWikiException(9, 9001, "Access denied with no programming rights document {0}", null, args);
        }
        this.deleteDocument();
    }

    public String getVersionHashCode() {
        return this.doc.getVersionHashCode(this.getXWikiContext());
    }

    public int addAttachments() throws XWikiException {
        return this.addAttachments(null);
    }

    public int addAttachments(String fieldName) throws XWikiException {
        if (!this.hasAccessLevel("edit")) {
            java.lang.Object[] args = new java.lang.Object[]{this.getFullName()};
            throw new XWikiException(9, 9001, "Access denied in edit mode on document {0}", null, args);
        }
        XWiki xwiki = this.getXWikiContext().getWiki();
        FileUploadPlugin fileupload = (FileUploadPlugin)xwiki.getPlugin("fileupload", this.getXWikiContext());
        List<FileItem> fileuploadlist = fileupload.getFileItems(this.getXWikiContext());
        ArrayList<XWikiAttachment> attachments = new ArrayList<XWikiAttachment>();
        this.context.put("addedAttachments", attachments);
        int nb = 0;
        if (fileuploadlist == null) {
            return 0;
        }
        for (FileItem item : fileuploadlist) {
            String name = item.getFieldName();
            if (fieldName != null && !fieldName.equals(name) || item.isFormField()) continue;
            byte[] data = fileupload.getFileItemData(name, this.getXWikiContext());
            String fname = fileupload.getFileName(name, this.getXWikiContext());
            int i = fname.lastIndexOf("\\");
            if (i == -1) {
                i = fname.lastIndexOf("/");
            }
            String filename = fname.substring(i + 1);
            filename = filename.replaceAll("\\+", " ");
            if (data == null || data.length <= 0) continue;
            XWikiAttachment attachment = this.getDoc().addAttachment(filename, data, this.getXWikiContext());
            this.getDoc().saveAttachmentContent(attachment, this.getXWikiContext());
            attachments.add(attachment);
            ++nb;
        }
        if (nb > 0) {
            this.getXWikiContext().getWiki().saveDocument(this.getDoc(), this.getXWikiContext());
            this.initialDoc = this.doc;
        }
        return nb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attachment addAttachment(String fileName, InputStream iStream) {
        try {
            Attachment attachment = new Attachment(this, this.getDoc().setAttachment(fileName, iStream, this.getXWikiContext()), this.getXWikiContext());
            return attachment;
        }
        catch (IOException iOException) {
        }
        finally {
            this.updateAuthor();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attachment addAttachment(String fileName, byte[] data) {
        try {
            Attachment attachment = new Attachment(this, this.getDoc().addAttachment(fileName, data, this.getXWikiContext()), this.getXWikiContext());
            return attachment;
        }
        catch (XWikiException xWikiException) {
        }
        finally {
            this.updateAuthor();
        }
        return null;
    }

    public boolean validate() throws XWikiException {
        return this.doc.validate(this.getXWikiContext());
    }

    public boolean validate(String[] classNames) throws XWikiException {
        return this.doc.validate(classNames, this.getXWikiContext());
    }

    public String getValidationScript() {
        return this.getDoc().getValidationScript();
    }

    public void setValidationScript(String validationScript) {
        this.getDoc().setValidationScript(validationScript);
        this.updateAuthor();
    }

    public void rename(DocumentReference newReference) throws XWikiException {
        XWiki xWiki = this.context.getWiki();
        if (this.hasAccessLevel("delete") && xWiki.checkAccess("edit", xWiki.getDocument(newReference, this.context), this.context)) {
            List<DocumentReference> backLinkedReferences = this.getDocument().getBackLinkedReferences(this.context);
            List<DocumentReference> childrenReferences = this.getDocument().getChildrenReferences(this.context);
            xWiki.renameDocument(this.getDocumentReference(), newReference, true, backLinkedReferences, childrenReferences, this.context);
        }
    }

    public void rename(String newDocumentName, List<String> backlinkDocumentNames) throws XWikiException {
        this.rename(newDocumentName, backlinkDocumentNames, Collections.emptyList());
    }

    public void rename(String newDocumentName, List<String> backlinkDocumentNames, List<String> childDocumentNames) throws XWikiException {
        ArrayList<DocumentReference> backlinkDocumentReferences = new ArrayList<DocumentReference>();
        for (String backlinkDocumentName : backlinkDocumentNames) {
            backlinkDocumentReferences.add(this.getCurrentMixedDocumentReferenceResolver().resolve((java.lang.Object)backlinkDocumentName, new java.lang.Object[0]));
        }
        ArrayList<DocumentReference> childDocumentReferences = new ArrayList<DocumentReference>();
        for (String childDocumentName : childDocumentNames) {
            childDocumentReferences.add(this.getCurrentMixedDocumentReferenceResolver().resolve((java.lang.Object)childDocumentName, new java.lang.Object[0]));
        }
        this.rename(this.getCurrentMixedDocumentReferenceResolver().resolve((java.lang.Object)newDocumentName, new java.lang.Object[0]), backlinkDocumentReferences, childDocumentReferences);
    }

    public void rename(DocumentReference newReference, List<DocumentReference> backlinkDocumentNames, List<DocumentReference> childDocumentNames) throws XWikiException {
        XWiki xWiki = this.context.getWiki();
        if (this.hasAccessLevel("delete") && xWiki.checkAccess("edit", xWiki.getDocument(newReference, this.context), this.context)) {
            int counter = childDocumentNames.size();
            List<String> actuallyChildren = this.getChildren();
            while (counter > 0) {
                if (actuallyChildren.contains(childDocumentNames.get(--counter)) || xWiki.checkAccess("edit", xWiki.getDocument(childDocumentNames.get(counter), this.context), this.context)) continue;
                return;
            }
            xWiki.renameDocument(this.getDocumentReference(), newReference, true, backlinkDocumentNames, childDocumentNames, this.context);
        }
    }

    public Document getDocumentRevision(String revision) {
        try {
            DocumentRevisionProvider revisionProvider = this.getDocumentRevisionProvider();
            revisionProvider.checkAccess(Right.VIEW, (UserReference)CurrentUserReference.INSTANCE, this.getDocumentReference(), revision);
            XWikiDocument documentRevision = revisionProvider.getRevision(this.doc, revision);
            return documentRevision != null ? new Document(documentRevision, this.context) : null;
        }
        catch (AuthorizationException e) {
            LOGGER.info("Access denied for loading revision [{}] of document [{}]: [{}]", new java.lang.Object[]{revision, this.getDocumentReferenceWithLocale(), ExceptionUtils.getRootCauseMessage((Throwable)e)});
        }
        catch (Exception e) {
            LOGGER.error("Failed to load revision [{}] of document [{}]", new java.lang.Object[]{revision, this.getDocumentReferenceWithLocale(), e});
        }
        return null;
    }

    public Document getPreviousDocument() throws XWikiException {
        return this.getDocumentRevision(this.getPreviousVersion());
    }

    public boolean isMostRecent() {
        return this.doc.isMostRecent();
    }

    public boolean isRestricted() {
        return this.doc.isRestricted();
    }

    public String toString() {
        return this.doc.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean convertSyntax(String targetSyntaxId) throws XWikiException {
        try {
            this.getDoc().convertSyntax(targetSyntaxId, this.context);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to convert document [" + this.getPrefixedFullName() + "] to syntax [" + targetSyntaxId + "]", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.updateAuthor();
            this.updateContentAuthor();
        }
        return true;
    }

    public boolean isHidden() {
        return this.doc.isHidden();
    }

    public void setHidden(boolean hidden) {
        this.doc.setHidden(hidden);
    }

    @Unstable
    public boolean isEnforceRequiredRights() {
        return this.doc.isEnforceRequiredRights();
    }

    @Unstable
    public void setEnforceRequiredRights(boolean enforceRequiredRights) {
        this.getDoc().setEnforceRequiredRights(enforceRequiredRights);
        this.updateAuthor();
        this.updateContentAuthor();
    }

    public void dropPermissions() {
        ExecutionContext context = Utils.getComponent(Execution.class).getContext();
        context.setProperty("hasDroppedPermissions", (java.lang.Object)System.identityHashCode(context));
    }

    public boolean isTranslation() {
        return 1 == this.getDoc().getTranslation();
    }

    public int getLocalReferenceMaxLength() {
        return this.doc.getLocalReferenceMaxLength();
    }

    public DocumentAuthors getAuthors() {
        if (this.hasAccess(Right.PROGRAM)) {
            return this.getDoc().getAuthors();
        }
        return new SafeDocumentAuthors(this.doc.getAuthors());
    }

    @Unstable
    public void setAuthor(UserReference userReference) throws AccessDeniedException {
        this.getContextualAuthorizationManager().checkAccess(Right.PROGRAM);
        this.getDoc().setAuthor(userReference);
    }

    public /* synthetic */ DocumentReferenceResolver ajc$privMethod$com_xpn_xwiki_api_DocumentCompatibilityAspect$com_xpn_xwiki_api_Document$getCurrentMixedDocumentReferenceResolver() {
        return this.getCurrentMixedDocumentReferenceResolver();
    }

    public /* synthetic */ XWikiContext ajc$superDispatch$com_xpn_xwiki_api_Document$getXWikiContext() {
        return super.getXWikiContext();
    }

    @Deprecated(since="16.0RC1")
    public String displayTooltip(String string) {
        return DocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_DocumentCompatibilityAspect$com_xpn_xwiki_api_Document$displayTooltip(this, string);
    }

    @Deprecated(since="16.0RC1")
    public String displayTooltip(String string, Object object) {
        return DocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_DocumentCompatibilityAspect$com_xpn_xwiki_api_Document$displayTooltip(this, string, object);
    }

    @Deprecated
    public DocumentStats getCurrentMonthWebStats(String string) {
        return DocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_DocumentCompatibilityAspect$com_xpn_xwiki_api_Document$getCurrentMonthWebStats(this, string);
    }

    @Deprecated
    public List<String> getTranslationList() throws XWikiException {
        return DocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_DocumentCompatibilityAspect$com_xpn_xwiki_api_Document$getTranslationList(this);
    }

    @Deprecated
    public String getWeb() {
        return DocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_DocumentCompatibilityAspect$com_xpn_xwiki_api_Document$getWeb(this);
    }

    @Deprecated
    public void rename(String string) throws XWikiException {
        DocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_DocumentCompatibilityAspect$com_xpn_xwiki_api_Document$rename(this, string);
    }

    @Deprecated
    public void renameDocument(String string) throws XWikiException {
        DocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_DocumentCompatibilityAspect$com_xpn_xwiki_api_Document$renameDocument(this, string);
    }

    @Deprecated
    public void renameDocument(String string, List<String> list) throws XWikiException {
        DocumentCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_DocumentCompatibilityAspect$com_xpn_xwiki_api_Document$renameDocument(this, string, list);
    }
}

